#include <LineDlg.h>
#include <kapp.h>

LineDlg::LineDlg(QWidget *parent, const char *name, int nLines)
	: QDialog(parent,name,TRUE)
{
	NLines = nLines;
	resize(230,NLines*60+50);
	setMaximumSize(230,NLines*60+50);
	setMinimumSize(230,NLines*60+50);
	for (int i=0;i<NLines;i++) {
		Label[i] = new QLabel(this);
		Label[i]->setGeometry(10,10+i*60,210,20);
		EditText[i] = new KLined(this);
		EditText[i]->setGeometry(10,35+i*60,210,25);
	}
	EditText[0]->setFocus();
	connect(EditText[0],SIGNAL(completion()),SLOT(tabPressed()));
	QPushButton	*ok = new QPushButton(i18n("OK"),this);
	ok->setGeometry(10,NLines*60+10,70,30);
	connect(ok,SIGNAL(clicked()),SLOT(accept()));
	ok->setDefault(TRUE);
	QPushButton	*cancel = new QPushButton(i18n("Cancel"),this);
	cancel->setGeometry(150,NLines*60+10,70,30);
	connect(cancel,SIGNAL(clicked()),SLOT(reject()));
	Completion = 0;
}

void LineDlg::enableCompletion()
{
	Completion = new FileCompletion(this);
	QObject::connect(Completion,SIGNAL(setText(const char*)),EditText[0],SLOT(setText(const char*)));
}

void LineDlg::tabPressed()
{
	if (Completion) Completion->make_completion(EditText[0]->text());
	else if (NLines > 1) EditText[NLines-1]->setFocus();
}