#include "OpenDlg.h"
#include <qpushbutton.h>
#include <qlabel.h>
#include <kapp.h>

OpenDlg::OpenDlg(KMimeAppList *list, KPIconLoader *Loader, QWidget *parent = 0, const char *name = 0)
	: QDialog(parent,name,TRUE)
{
	this->list = list;
	this->Loader = Loader;

	setCaption(i18n("Open with ..."));
	setMaximumSize(800,800);
	setMinimumSize(250,250);
	resize(350,450);

	QLabel	*label = new QLabel(i18n("Select an application :"),this);
	label->setGeometry(10,10,330,20);

	EditText = new QLineEdit(this);
	EditText->setGeometry(10,40,0,0);
	EditText->setMinimumSize(220,25);
	EditText->setMaximumSize(680,25);
	EditText->setFocus();

	KDEOnlyCheckbox = new QCheckBox(this);
	KDEOnlyCheckbox->setAutoResize(true);
	KDEOnlyCheckbox->setText(i18n("Show only well-known applications"));
	KDEOnlyCheckbox->move(10,75);
	KDEOnlyCheckbox->show();
	connect(KDEOnlyCheckbox,SIGNAL(toggled(bool)),SLOT(filterApplications(bool)));

	ListView = new QListView(this);
	ListView->setGeometry(10,100,0,0);
	ListView->setFrameStyle(QFrame::Panel | QFrame::Sunken);
	ListView->setLineWidth(2);
	ListView->addColumn(i18n("Name"));
	ListView->setColumnWidth(0,100);
	ListView->addColumn(i18n("Description"));
	ListView->setColumnWidth(1,100);
	ListView->addColumn(i18n("Command"));
	ListView->setColumnWidth(2,100);
	connect(ListView,SIGNAL(selectionChanged(QListViewItem*)),SLOT(activated(QListViewItem*)));
	connect(ListView,SIGNAL(doubleClicked(QListViewItem*)),SLOT(dblClicked(QListViewItem*)));

	QListViewItem	*item;
	KMimeAppListIterator	it(*list);
	for (;it.current();++it) {
		item = new QListViewItem(ListView,it.current()->AppName.data(),it.current()->Description.data(),it.current()->ExecString.data());
		item->setPixmap(0,*(Loader->loadKDEIcon(it.current()->MimeIcon.data())));
	}

	ok = new QPushButton(i18n("Ok"),this);
	ok->setGeometry(0,0,70,25);
	ok->setDefault(TRUE);
	connect(ok,SIGNAL(clicked()),SLOT(accept()));

	cancel = new QPushButton(i18n("Cancel"),this);
	cancel->setGeometry(0,0,70,25);
	connect(cancel,SIGNAL(clicked()),SLOT(reject()));

	// default is to show only "well-known" apps
	emit filterApplications(true);
	KDEOnlyCheckbox->setChecked(true);
}

OpenDlg::~OpenDlg()
{
}

void OpenDlg::activated(QListViewItem *item)
{ EditText->setText(item->text(2));}

void OpenDlg::dblClicked(QListViewItem *)
{ accept();}

void OpenDlg::filterApplications(bool show_well_known_only)
{
	ListView->clear();

	// show only apps that have an icon, assuming these are the
	// important apps
	QListViewItem	*item;
	KMimeAppListIterator	it(*list);
	for (;it.current();++it) {
		item = new QListViewItem(ListView,it.current()->AppName.data(),it.current()->Description.data(),it.current()->ExecString.data());
		item->setPixmap(0,*(Loader->loadKDEIcon(it.current()->MimeIcon.data())));
		if( item->pixmap(0)->isNull() && show_well_known_only ) {
			delete item;
		}
	}

}

void OpenDlg::resizeEvent(QResizeEvent *)
{
	cancel->move(width()-180, height()-35);
	ok->move(width()-90, height()-35);
	EditText->resize(width()-20, 25);
	ListView->resize(width()-20, height()-155);
}
