#include "OptionsDetail.h"
#include <kapp.h>
#include <qmessagebox.h>

OptionsDetail::OptionsDetail(QWidget *parent, const char *name)
	: QWidget(parent,name)
{
	ListView = new QListView(this);
	ListView->setFrameStyle(QFrame::Panel | QFrame::Sunken);
	ListView->setLineWidth(2);
	ListView->addColumn(i18n("Type"));
	ListView->addColumn(i18n("Width"));
	ListView->setSorting(-1);
	ListView->setAllColumnsShowFocus(TRUE);
	connect(ListView,SIGNAL(selectionChanged(QListViewItem*)),SLOT(selectionChanged(QListViewItem*)));

	ItemList.setAutoDelete(TRUE);

	butt[0] = new QPushButton(i18n("Add"),this);
	connect(butt[0],SIGNAL(clicked()),SLOT(addClicked()));
	butt[1] = new QPushButton(i18n("Delete"),this);
	connect(butt[1],SIGNAL(clicked()),SLOT(deleteClicked()));
	butt[2] = new QPushButton(i18n("Modify"),this);
	connect(butt[2],SIGNAL(clicked()),SLOT(modifyClicked()));

	lab[0] = new QLabel(i18n("Type"),this);
	lab[1] = new QLabel(i18n("Width"),this);
	lab[2] = new QLabel(i18n("Date format :"),this);

	Type = new QComboBox(this);

	Width = new QLineEdit(this);

	DateFormat = new QComboBox(this);
	DateFormat->insertItem(i18n("Date & Time"));
	DateFormat->insertItem(i18n("Date"));
	DateFormat->insertItem(i18n("Time"));
	DateFormat->insertItem(i18n("Condensed"));
	DateFormat->insertItem(i18n("ISO format"));
	DateFormat->insertItem(i18n("Adapted"));

	SelectionMode = new QComboBox(this);
	SelectionMode->insertItem(i18n("Via name column"));
	SelectionMode->insertItem(i18n("Via complete row"));

	lab[3] = new QLabel(i18n("Selection mode :"),this);
}

OptionsDetail::~OptionsDetail()
{
}

void OptionsDetail::addClicked()
{
/*	if (ItemList.count() == 5)
		QMessageBox::critical(this,i18n("Error"),i18n("Can't have more than 5 columns"),QMessageBox::Ok | QMessageBox::Default,0);
	else {*/
		QString	num, width(Width->text());
		if ((width.isEmpty() || width == "0") &&
		    QMessageBox::warning(this,i18n("Warning"),i18n("Column will have null size"),i18n("Continue"),i18n("Cancel"),0,1,1) == 1
		   ) return;
		num.setNum(Type->currentItem());
		QListViewItem	*item = new QListViewItem(ListView,ItemList.last(),Type->currentText(),(width.isEmpty() ? "0" : width.data()),num.data());
		ItemList.append(item);
		Modified = TRUE;
//	}
}

void OptionsDetail::deleteClicked()
{
	if (ItemList.count() == 1)
		QMessageBox::critical(this,i18n("Error"),i18n("You must define at least one column"),QMessageBox::Ok | QMessageBox::Default,0);
	else {
		QListViewItem	*item = ListView->currentItem();
		if (item) { ItemList.removeRef(item); Modified = TRUE;}
	}
}

void OptionsDetail::modifyClicked()
{
	QListViewItem	*item = ListView->currentItem();
	if (item) {
		QString	num, width(Width->text());
		item->setText(0,Type->currentText());
		item->setText(1,(width.isEmpty() ? "0" : width.data()));
		num.setNum(Type->currentItem());
		item->setText(3,num.data());
		Modified = TRUE;
	}
}

void OptionsDetail::setColumns(QStrList& ColType, QStrList& ColWidth, QString *ColName)
{
	for (int i=0;i<15;i++) Type->insertItem(ColName[i].data());
	QString	num;
	for (int i=ColType.count()-1;i>=0;i--) {
		num = ColType.at(i);
		QListViewItem	*item = new QListViewItem(ListView,ColName[num.toInt()],ColWidth.at(i),num.data());
		ItemList.insert(0,item);
	}
}

void OptionsDetail::selectionChanged(QListViewItem *item)
{
	Width->setText(item->text(1));
	QString	num = item->text(2);
	Type->setCurrentItem(num.toInt());
}

void OptionsDetail::getColumns(QStrList& ColType, QStrList& ColWidth)
{
	ColType.clear();
	ColWidth.clear();
	QListIterator<QListViewItem>	it(ItemList);
	for (;it.current();++it) {
		ColType.append(it.current()->text(2));
		ColWidth.append(it.current()->text(1));
	}
}

void OptionsDetail::resizeEvent(QResizeEvent*)
{
	int	h = height()/2, w = width()-20-80-10, s = (h-15-90)/2;
	ListView->setGeometry(10,10,w,h-15);
	for (int i=0;i<3;i++) butt[i]->setGeometry(width()-90,10+i*(30+s),80,30);
	w = (width()-30)/2;
	lab[3]->setGeometry(10,height()-40,w,25);
	SelectionMode->setGeometry(20+w,height()-40,w,25);
	lab[2]->setGeometry(10,height()-75,w,25);
	DateFormat->setGeometry(20+w,height()-75,w,25);
	h += 10;
	lab[0]->setGeometry(10,h,w,25);
	lab[1]->setGeometry(20+w,h,w,25);
	h += 25;
	Type->setGeometry(10,h,w,25);
	Width->setGeometry(20+w,h,w,25);
}
