/**********************************************************************

	--- Qt Architect generated file ---

	File: OptionsExtensions.cpp
	Last generated: Fri Feb 19 21:01:44 1999

	DO NOT EDIT!!!  This file will be automatically
	regenerated by qtarch.  All changes will be lost.

 *********************************************************************/

#include "OptionsExtensions.h"
#include "MimeDlg.h"
#include <iostream.h>
#include <kapp.h>

ExtListViewItem::ExtListViewItem(QListView* parent, KMimeExtension* ext, QPixmap* icon)
	: QListViewItem(parent,ext->Description.data()), Ext(ext)
{
	QString		str;
	QStrListIterator	it(Ext->Extensions);
	for (;it.current();++it) {str += it.current(); str += ";";}
	setText(1,str.data());
	setPixmap(0,*icon);
}

//--------------------------------------------------------------------------------------------------------

#define Inherited QWidget


OptionsExtensions::OptionsExtensions
(
	QWidget* parent,
	const char* name
)
	:
	Inherited( parent, name, 0 )
{
	NewButton = new QPushButton( i18n("New"), this, "NewButton" );
	connect(NewButton,SIGNAL(clicked()),SLOT(newClicked()));

	DeleteButton = new QPushButton( i18n("Delete"), this, "DeleteButton" );
	connect(DeleteButton,SIGNAL(clicked()),SLOT(deleteClicked()));

	EditButton = new QPushButton( i18n("Edit"), this, "EditButton" );
	connect(EditButton,SIGNAL(clicked()),SLOT(editClicked()));

	ListView = new QListView(this);
	ListView->addColumn(i18n("Name"),189);
	ListView->addColumn(i18n("Extensions"),114);
	ListView->setFrameStyle(QFrame::Panel | QFrame::Sunken);
	ListView->setLineWidth(2);
	ListView->setAllColumnsShowFocus(true);
	ExtList = 0;
	Loader = 0;
	Modified = FALSE;
}


OptionsExtensions::~OptionsExtensions()
{
}

void OptionsExtensions::setExtList(KMimeExtList *list, KPIconLoader *IL, bool UseKDEMimeTypes)
{
	ExtList = list;
	Loader = IL;
	CanModify = !UseKDEMimeTypes;
	ListView->clear();
	KMimeExtListIterator	it(*ExtList);
	for (;it.current();++it)
		new ExtListViewItem(ListView,it.current(),Loader->loadMiniIcon(it.current()->MimeIcon.data()));
	NewButton->setEnabled(CanModify);
	DeleteButton->setEnabled(CanModify);
}

void OptionsExtensions::newClicked()
{
	MimeDlg	*Dlg = new MimeDlg(0,FALSE,this);
	if (Dlg->exec()) {
		KMimeExtension	*ext = new KMimeExtension(Dlg->MimeName->text(),Dlg->Extensions->text(),(Dlg->Application->text() == 0 ? "None" : Dlg->Application->text()),Dlg->Description->text(),Dlg->Icon->text(),Dlg->InShell->isChecked());
		ExtList->append(ext);
		Modified = TRUE;
		emit needApplyOptions();
	}
}

void OptionsExtensions::deleteClicked()
{
	KMimeExtension	*ext = ((ExtListViewItem*)ListView->currentItem())->extension();
	if (ext == 0) return;
	ExtList->removeRef(ext);
	Modified = TRUE;
	emit needApplyOptions();
}

void OptionsExtensions::editClicked()
{
	KMimeExtension	*ext = ((ExtListViewItem*)ListView->currentItem())->extension();
	if (ext == 0) return;
	if (FALSE) {		// KDE mime types
		KProcess	*p = new KProcess;
		connect(p,SIGNAL(processExited(KProcess*)),SLOT(processExited(KProcess*)));
		(*p) << "kfmclient" << "openProperties" << ext->FileName.data();
		p->start();
		return;
	}
	MimeDlg	*Dlg = new MimeDlg(ext,!CanModify,this);
	if (Dlg->exec()) {
		if (Dlg->Application->text() != ext->Application) { Modified = TRUE; ext->Application = Dlg->Application->text();}
		if (Dlg->Description->text() != ext->Description) { Modified = TRUE; ext->Description = Dlg->Description->text();}
		if (Dlg->Icon->text() != ext->MimeIcon) { Modified = TRUE; ext->MimeIcon = Dlg->Icon->text();}
		if (Dlg->MimeName->text() != ext->MimeName) { Modified = TRUE; ext->MimeName = Dlg->MimeName->text();}
		if (Dlg->FileName->text() != ext->FileName) { Modified = TRUE; ext->FileName = Dlg->FileName->text();}
		if (Dlg->InShell->isChecked() != ext->inShell) { Modified = TRUE; ext->inShell = Dlg->InShell->isChecked();}
		QString		tmp;
		QStrListIterator	it(ext->Extensions);
		for (;it.current();++it) {tmp += it.current(); tmp += ";";}
		if (Dlg->Extensions->text() != tmp) {
			Modified = TRUE;
			tmp = Dlg->Extensions->text();
			ext->Extensions.clear();
			char	*c = strtok(tmp.data(),";");
			while (c) {
				ext->Extensions.append(c);
				c = strtok(0,";");
			}
		}
		if (Modified) emit needApplyOptions();
	}
	delete Dlg;
}

void OptionsExtensions::processExited(KProcess *p)
{
	if (p->normalExit()) emit needApplyOptions(), cout << p->exitStatus() << endl;
	delete p;
}

void OptionsExtensions::resizeEvent(QResizeEvent*)
{
	ListView->setGeometry(10,10,width()-20,height()-60);
	int	s = (width()-20-3*80)/2;
	NewButton->setGeometry(10,height()-40,80,30);
	DeleteButton->setGeometry(10+80+s,height()-40,80,30);
	EditButton->setGeometry(10+160+2*s,height()-40,80,30);
}
