#include <kapp.h>
#include "OptionsView.h"

OptionsView::OptionsView(QWidget *parent, const char *name)
	: QWidget(parent,name)
{
	group1 = new QGroupBox(i18n("Archive files"),this);

	ListView = new QListView(group1);
	ListView->setFrameStyle(QFrame::Panel | QFrame::Sunken);
	ListView->setLineWidth(2);
	ListView->addColumn(i18n("Pattern"));
	ListView->addColumn(i18n("Type"));
	ListView->setSorting(-1);
	ListView->setAllColumnsShowFocus(TRUE);

	lab[0] = new QLabel(i18n("Pattern"),group1);
	lab[1] = new QLabel(i18n("Type"),group1);

	Pattern = new QLineEdit(group1);
	ProtType = new QComboBox(group1);
	ProtType->insertItem("Tar");
	ProtType->insertItem("Zip");
	ProtType->insertItem("Rpm");
// DEB
//	ProtType->insertItem("Deb");
// DEB

	add = new QPushButton(i18n("Add"),group1);
	connect(add,SIGNAL(clicked()),SLOT(addClicked()));
	del = new QPushButton(i18n("Delete"),group1);
	connect(del,SIGNAL(clicked()),SLOT(deleteClicked()));

	group2 = new QGroupBox(i18n("Mini images"),this);

	lab[2] = new QLabel(i18n("Saving policy :"),group2);
	SavingPolicy = new QComboBox(group2);
	SavingPolicy->insertItem(i18n("Never"));
	SavingPolicy->insertItem(i18n("Use existing .xvpics/"));
	SavingPolicy->insertItem(i18n("Create .xvpics/"));
	connect(SavingPolicy,SIGNAL(activated(int)),SLOT(saveChanged(int)));
	ImageSaveIfSize = new QCheckBox(i18n("if size is greater than"),group2);
	ImageSize = new QLineEdit(group2);
	lab[3] = new QLabel("Kb",group2);

	Modified = FALSE;
}

OptionsView::~OptionsView()
{}

void OptionsView::addClicked()
{
	new QListViewItem(ListView,Pattern->text(),ProtType->currentText());
	Modified = TRUE;
}

void OptionsView::deleteClicked()
{
	if (ListView->currentItem()) { delete ListView->currentItem(); Modified = TRUE;}
}

void OptionsView::setProtList(SubProtList *list)
{
	SubProtListIterator	it(*list);
	for (;it.current();++it) {
		int	code = it.current()->type-Protocol::Tar;
		new QListViewItem(ListView,it.current()->extension.pattern(),ProtType->text(code));
	}
}

void OptionsView::getProtList(SubProtList *list)
{
	list->clear();
	QListViewItem	*item = ListView->firstChild();
	int	code;
	while (item) {
		if (strcmp(item->text(1),"Tar") == 0) code = 0;
		else if (strcmp(item->text(1),"Zip") == 0) code = 1;
		else if (strcmp(item->text(1),"Rpm") == 0) code = 2;
// DEB
//		else if (strcmp(item->text(1),"Deb") == 0) code = 3;
// DEB
		code += Protocol::Tar;
		list->append(new SubProtocol(code,item->text(0)));
		item = item->nextSibling();
	}
}

void OptionsView::saveChanged(int val)
{
	bool	enable = (val != 0);
	ImageSaveIfSize->setEnabled(enable);
	ImageSize->setEnabled(enable);
}

void OptionsView::resizeEvent(QResizeEvent*)
{
	int	h = ((height()-30)*2)/3, w = width()-20, h2, w2;
	group1->setGeometry(10,10,w,h);
	group2->setGeometry(10,20+h,w,h/2);
	h2 = h-70;
	w2 = (w-30)/2;
	int	s = (h2-90)/3;
	ListView->setGeometry(10,20,w2,h2);
	lab[0]->setGeometry(20+w2,20+s,w2,20);
	lab[1]->setGeometry(20+w2,2*s+65,w2,20);
	Pattern->setGeometry(20+w2,40+s,w2,25);
	ProtType->setGeometry(20+w2,2*s+85,w2,25);
	h2 += 30;
	add->setGeometry(10,h2,80,30);
	del->setGeometry(100,h2,80,30);
	h2 = (group2->height()-70)/2;
	w2 = (w-60)/3;
	lab[2]->setGeometry(10,20,w2,25);
	SavingPolicy->setGeometry(10+w2,20,w2*2,25);
	ImageSaveIfSize->setGeometry(10,45+h2,2*w2,25);
	ImageSize->setGeometry(10+2*w2,45+h2,w2,25);
	lab[3]->setGeometry(15+3*w2,45+h2,40,25);
	
}
