#include "filecompletion.h"

#include <config.h>
#include <stdlib.h>
#include <qregexp.h>
#include <qdir.h>
#include <kurl.h>
#include <sys/stat.h>
#include <unistd.h>
#include <iostream.h>

#ifdef HAVE_DIRENT_H
#include <dirent.h>
#elif HAVE_NDIR_H
#include <ndir.h>
#elif HAVE_SYS_NDIR_H
#include <sys/ndir.h>
#elif HAVE_SYS_DIR_H
#include <sys/dir.h>
#endif

int score(const char *s1, const char *s2)
{
	int	s(0);
	while (*s1 && *s2 && *s1 == *s2) s++,s1++,s2++;
	return s;
}

void FileCompletion::searchPossibilities()
{
	PossibilityList.clear();
	if (Text.isEmpty()) return;
	// First replace all occurrences of "~"
	Text.replace(QRegExp("~"),getenv("HOME"));
	// Then replace every environement variable
	int	pos(-1);
	while ((pos=Text.find('$')) != -1) {
		int	pos2 = Text.find('/',pos);
		if (pos2 == -1) pos2 = Text.length();
		Text.replace(pos,pos2-pos,getenv(Text.mid(pos+1,pos2-pos-1).data()));
	}
	if (strncmp(Text.data(),"file:",5) == 0) Text = Text.right(Text.length()-5);
	bool	lastIsSlash = (Text.right(1) == "/" && Text.length() > 1);
	Text = QDir::cleanDirPath(Text.data());
	if (lastIsSlash) Text.append("/");
	KURL::decodeURL(Text);

	int	lastSlash = Text.findRev('/');
	QString	Root = Text.left(lastSlash) + "/";
	QString	FileString;
	DIR	*dir = opendir(Root.data());
	if (!dir) return;
	struct dirent	*file;
	while ((file=readdir(dir)) != 0) {
		if (strcmp(file->d_name,".") == 0 || strcmp(file->d_name,"..") == 0) continue;
		FileString = Root + file->d_name;
		if (strncmp(FileString.data(),Text.data(),Text.length()) == 0) {
			struct stat	st;
			::stat(FileString.data(),&st);
			if (S_ISDIR(st.st_mode)) {
				FileString += "/";
				PossibilityList.append(FileString.data());
			}
		}
	}
}

void FileCompletion::make_completion(const char *text)
{
	Text = text;
	searchPossibilities();
	QString	Possible;
	if (PossibilityList.count() == 1) Possible = PossibilityList.first();
	else if (PossibilityList.count() > 1) {		// we have to find the greatest root string
		int	Score(QString(PossibilityList.first()).length());
		QStrListIterator	it(PossibilityList);
		for (++it;it.current();++it) Score = QMIN(Score,score(PossibilityList.first(),it.current()));
		Possible = QString(PossibilityList.first()).left(Score);
	}

	if (!Possible.isEmpty()) emit setText(Possible.data());
}

void FileCompletion::make_rotation(const char *text)
{
}
