#ifndef _HISTORY_H_
#define _HISTORY_H_

#include <qcombobox.h>
#include <qstrlist.h>
#include <qkeycode.h>

#include "filecompletion.h"

class HistoryCombo : public QComboBox
{
	Q_OBJECT;

public:
	HistoryCombo(QWidget *parent = 0, const char *name = 0);
	~HistoryCombo();

	void setHistory(QStrList *list) { History = list;}
	void refreshHistory();

signals:
	void completion(const char*);
	void rotation(const char*);
	void returnPressed();
	void escapePressed();
	void historySelected(int);

protected slots:
	void slotActivated(int);

protected:
	virtual void keyPressEvent(QKeyEvent*);
	virtual void focusInEvent(QFocusEvent *e);
	virtual void focusOutEvent(QFocusEvent*);

private:
	QStrList	*History;
	FileCompletion	*Completion;
};

#endif
