#ifndef _KPICONLOADER_H_
#define _KPICONLOADER_H_

#include <qpixmap.h>
#include <qdict.h>
#include <qstring.h>
#include <qlist.h>

class KPIconLoader
{
public:
	KPIconLoader(const QString& pathname, bool useKDE = FALSE);
	QPixmap* loadIcon(const QString& name, const QString& def = 0);
	QPixmap* loadMiniIcon(const QString& name, const QString& def = 0);
	QPixmap* loadToolBarIcon(const QString& name);
	QPixmap* loadKDEIcon(const QString& name);
	void reloadIcons(bool useKDE, const QString& str);
	QPixmap changeIcon(const char *name);

protected:
	void setupPath(bool useKDE, const QString& pathname);
	QString getIconPath(const QString& icon, int flag);
	QString getIconPathInternal(const QList<QString>& list, const QString& icon, const QString& prefix = "");
	QString getKey(const QString& icon, int flag);
	QPixmap* loadInternal(const QString& icon, const QString& def, int flag);

private:
	QDict<QPixmap>	Icons;
	QList<QString>	Path, KDEPath;
	bool		UseKDE;
};

#endif

