#ifndef _MOUNTPROT_H_
#define _MOUNTPROT_H_

#include "fileprot.h"
#include <qstring.h>

class MountProtocol : public FileProtocol
{
public:
	MountProtocol(const char *mpoint = 0, const char *device = 0, const char *fstype = 0);
	virtual ~MountProtocol();

	bool mount();
	bool umount();
	bool init();
	bool finish();
	bool shutDown();
	bool isMountable() { return Mountable;}
	bool isMounted();
	const char* mountp() { return MountPoint.data();}
	bool isAccesible();
	const char* menuEntry();
	bool check();

protected:
	bool getMountPoint();		// get default mount point

protected:
	QString		Device;
	QString		FSType;
	QString		MountPoint;
	bool		Mountable;	// False if error in configuration of device
	bool		Mounted;

};

inline MountProtocol::~MountProtocol()
{ shutDown();}

#endif
