#ifndef _PREVIEW_H_
#define _PREVIEW_H_

#include <qpushbutton.h>
#include <qlabel.h>
#include <qwidget.h>
#include "fileinfo.h"
#include "imageloader.h"

class PreviewArea : public QWidget
{
	Q_OBJECT;

public:
	PreviewArea(QWidget *parent = 0, const char *name = 0);
	~PreviewArea();

	void setFileInfo(FileInfo*, bool mult = false);
	FileInfo* getFileInfo() const { return PreviewFileInfo;}

signals:
	void previewClicked();

protected:
	virtual bool eventFilter(QObject*, QEvent*);

private:
	QPushButton	*PreviewContent;
	QLabel		*PreviewInfo;
	QLabel		*PreviewValues;
	FileInfo	*PreviewFileInfo;
	ImageLoader	*Loader;
};

#endif
