#include <qregexp.h>
#include <kurl.h>
#include <kapp.h>
#include "protocol.h"

SubProtocol* matchFileName(const char *str, SubProtList *list)
{
	SubProtListIterator	it(*list);
	for (;it.current();++it) if (it.current()->matchFileName(str)) break;
	return it.current();
}

KMimeExtension* Protocol::getMimeTypeFromNode(FileInfo *fi)
{
	if (fi->isDir()) {
		if (fi->isReadable()) return ExtDict->find("inode/directory");
		else return ExtDict->find("inode/directory-locked");
	}
	else if (fi->isBlock()) return ExtDict->find("inode/blockdevice");
	else if (fi->isChr()) return ExtDict->find("inode/chardevice");
	else if (fi->isFifo()) return ExtDict->find("inode/fifo");
	else if (fi->isSocket()) return ExtDict->find("inode/socket");
	else return 0;
}

KMimeExtension* Protocol::getMimeTypeFromExtension(FileInfo *fi)
{
	if (ExtDict == 0 || fi->lastExtension().isEmpty()) return 0;
	return ExtDict->find(fi->lastExtension().data());
}

KMimeExtension* Protocol::getMimeTypeFromName(FileInfo *fi)
{
	if (NameDict == 0) return 0;
	QListIterator<KMimeExtension>	it(*NameDict);
	bool	done = FALSE;
	while (it.current() && !done) {
		for (int i=0;!done && i<it.current()->nExtension();i++) {
			QRegExp		w(it.current()->extension(i),TRUE,TRUE);
			if (fi->fileName().find(w) >= 0) done = TRUE;
		}
		if (!done) ++it;
	}
	return it.current();
}

KMimeExtension* Protocol::getMimeTypeFromMagic(FileInfo *fi)
{
	if (ExtDict == 0 || Magic == 0) return 0;
	KURL	url(fi->absFilePath().data());
	const char	*c = Magic->getMimeType(url.path());
	return (c ? ExtDict->find(c) : (KMimeExtension*)0);
}

bool Protocol::shutDown()
{ return TRUE;}

bool Protocol::isAccesible()
{ return true;}

const char* Protocol::menuEntry()
{ return 0;}

const char* Protocol::getTempFile(KURL *url, ProgressDlg *dlg)
{ return url->path();}

void Protocol::sendMessage(const char *msg)
{
	if (Manager) {
		QMessageEvent	*e = new QMessageEvent(msg);
		QApplication::postEvent(Manager,e);
	}
}
