/*
 *   kscan - a scanning program
 *   Copyright (C) 1998 Ivan Shvedunov
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <qlayout.h>

#include "miscwidgets.h"

void ImageHistogram::count()
{
	QImage *img = s->image();
	bzero(hits,256*sizeof(int));
	for(int y = 0; y<img->height(); y++)
		for(int x = 0; x<img->width(); x++) {
			QColor c = img->pixel(x,y);
			int I;
			switch(color) {
			case 0:
				I = (c.red()+c.green()+c.blue())/3;
				break;
			case 1:
				I = c.red();
				break;
			case 2:
				I = c.green();
				break;
			default:
				I = c.blue();
			}
			hits[I]++;
		}
	maxhits = hits[1];
	for(int i = 2; i<255; i++)
		if(hits[i]>maxhits) maxhits = hits[i];
}

void ImageHistogram::drawContents(QPainter *p)
{
	if(!maxhits) return;
	for(int i = 0; i<width()-8; i++) {
		p->moveTo(i+4,height()-4);
		int a = (hits[(i*256)/(width()-8)]*(height()-8))/maxhits;
		p->lineTo(i+4,height()-4-a);
	}
}

CoolSlider::CoolSlider(char *title,int min,int max,int step,int v,int ndig,
		       QWidget *parent = NULL, const char *name = NULL):
	QWidget(parent,name)
{
	s = new QSlider(min,max,step,v,QSlider::Horizontal,this,"slider");
	n = new QLCDNumber(ndig,this,"lcd");
	lb = new QLabel(title,this,"label");
	QVBoxLayout *l = new QVBoxLayout(this);
	QHBoxLayout *l2 = new QHBoxLayout;
	l->addLayout(l2);
	l2->addWidget(lb,2);
	l2->addWidget(n,2);
	l->addWidget(s);
	lb->setMinimumHeight(13);
	n->setFixedHeight(35);
	s->setFixedHeight(15);
	l->activate();
	n->display(v);
	s->setFocusPolicy(QWidget::StrongFocus);
	s->setTracking(FALSE);
	connect(s,SIGNAL(valueChanged(int)),SLOT(chval(int)));
	connect(s,SIGNAL(valueChanged(int)),n,SLOT(display(int)));
}

#include "miscwidgets.moc"
