#ifndef _KFILTER_H
#define _KFILTER_H

#include <kapp.h>
#include <ktopwidget.h>
#include <kmenubar.h>
#include <kintegerline.h>
#include <drag.h>
#include <qdialog.h>
#include <qframe.h>
#include <qcheckbox.h>
#include <qlistview.h>
#include <qbuttongroup.h>
#include <qlineedit.h>
#include <termios.h>
#include <unistd.h>
#include <fcntl.h>
#include <signal.h>

#include "kifstats.h"
#include "kportstats.h"
#include "options.h"

#define PORTS_FILE QString(KApplication::localconfigdir() + "/ksnifferrc.ports")

class PortFilterModal : public QDialog
 {
   Q_OBJECT;

   private:
    struct porttab *ports;
    QPushButton *ok, *cancelButton, *addButton, *delButton;
    void loadaddports(struct porttab **table);
    void destroyporttab(struct porttab *table);
    void addports(struct porttab **table, unsigned int port_min, unsigned int port_max);
    void delport(struct porttab **table, struct porttab *ptmp);
    void saveportlist(struct porttab *table);
    int dup_portentry(struct porttab *table, unsigned int min, unsigned int max);

   public:
    QLabel *textLabel;
    QLabel *portLabel, *minLabel, *maxLabel;
    QLabel *nameLabel;
    KIntegerLine *minEdit, *maxEdit;
    QLineEdit	*nameEdit;
    QListView *mylistview;
    int hitcancel;
    PortFilterModal(QWidget *parent, const char *name);

   public slots:
    void accept();   //close modal and save list to disk
    void reject();   //close modal, don't save list to disk
    void add();      //add port to list (don't close modal)
    void del();	     //remove port from list (don't close modal)
};
#endif
