/***************************************************************************
                          knd_replay.cpp  -  description                              
                             -------------------                                         
    begin                : Thu Mar 25 14:26:46 GMT 1999
                                           
    copyright            : (C) 1999 by Mike Richardson                         
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include	"knd_replay.h"

/*  KNDReplay								*/
/*  KNDReplay	: Constructor for view object				*/
/*  parent	: QWidget *	: Parent widget				*/
/*  multi	: KNDMulti *	: Multiple graph object			*/
/*  slot	: int		: Slot in parent view list		*/
/*  (returns)	: KNDReplay	:					*/

KNDReplay::KNDReplay
	(	KNDApp		*parent,
		KNDMulti	*multi,
		int		slot
	)
	:
	KNDView	(parent, slot, "Replay", NULL)
{
	config  = new KNDConfRep (this, graphic,
					packets, multi, slot, name) ;

	addTab	(config,  "Configuration"  ) ;
	addTab	(graphic, "Graphic display") ;
	addTab	(packets, "Packet monitor" ) ;
}

/*  KNDReplay								*/
/*  ~KNDReplay	: Destructor for view object				*/
/*  (returns)	:		:					*/

KNDReplay::~KNDReplay ()
{
	delete	config  ;
}

/*  KNDReplay								*/
/*  timerTick	: Pass down a timer tick				*/
/*  second	: long		: Second				*/
/*  (returns)	: void		:					*/

void	KNDReplay::timerTick
	(	long	second
	)
{
	config->timerTick (second) ;
}

/*  KNDReplay								*/
/*  viewStart	: Start monitor						*/
/*  (returns)	: void		:					*/

void	KNDReplay::viewStart ()
{
	config->replayStart () ;
}

/*  KNDReplay								*/
/*  viewStop	: Stop monitor						*/
/*  (returns)	: void		:					*/

void	KNDReplay::viewStop ()
{
	config->replayStop () ;
}

/*  KNDReplay								*/
/*  viewFreeze	: Freeze monitor					*/
/*  (returns)	: void		:					*/

void	KNDReplay::viewFreeze ()
{
	config->replayFreeze () ;
}

/*  KNDReplay								*/
/*  viewResume	: Resume monitor					*/
/*  (returns)	: void		:					*/

void	KNDReplay::viewResume ()
{
	config->replayResume () ;
}

/*  KNDReplay								*/
/*  writeConfig	: Write monitor configuration				*/
/*  _config	: KConfig *	: Configuration object			*/
/*  (returns)	: void		:					*/

void	KNDReplay::writeConfig
	(	KConfig	*_config
	)
{
}

