#include <stdio.h>
#include <qstring.h>
#include <qregexp.h>
#include <kapp.h>
#include "mytext.h"
#include "mytext.moc"

void mybox :: setChild(QWidget *child)
{
	mychild=child;
}

void mybox :: removeChild()
{
	mychild=0;
}

void mybox :: resizeEvent( QResizeEvent *e)
{
	QWidget::resizeEvent(e);

	if (mychild) {
		mychild->resize(width(),height());
		mychild->show();
		}
}

mytext::mytext(QWidget *parent, const char *name)
	: QMultiLineEdit(parent,name)
{
	maxLines=MAX_LINES;
	lastLineComplete=true;
	re=0;
	excludePattern=false;
}

void mytext :: mousePressEvent(QMouseEvent *e)
{
#ifdef ALLOW_DECOR_CHANGE
	if (e->button()==RightButton && e->state()==ControlButton)
		emit altrightclicked();
	else
#endif
	if (e->button()==RightButton)
		emit rightclicked();
	else if (e->button()==MidButton)
		emit middleclicked();
	else QMultiLineEdit::mousePressEvent(e);
}

void mytext::setMaxLines(int n)
{
	maxLines=n;
}

void mytext::setFilter(const char *r,bool excl)
{
	if (*r) {
		re=new QRegExp(r);
		excludePattern=excl;
		}
	else if (re) { delete re; re=0; }
}

void mytext::editFilter()
{
	filterw=new filter(this,"Filter",true);
	if (re) filterw->setText(re->pattern());
	filterw->setExclude(excludePattern);
	filterw->exec();
	setFilter(filterw->text(),filterw->isExcludeSelected());
//	delete filterw;
}

const char *mytext::getFilter()
{
	if (re) return(re->pattern());
	else return("");
}

// add a line to the QMultiLineEdit, parameter may have trailing EOL

void mytext::insertLineAtEnd(const char *t)
{
char *p,*q;
int l;
bool flag;

	if (re) {
	
	// only do this if there is a filter
	char *buffer=new char[strlen(t)+1];
	strcpy(buffer,t);
	q=buffer;
	while(*q) {
		p=strchr(q,'\n');
		if (p) {
			*p=0;
			insertSingleLineAtEnd(q,true);
			q=p+1;
			} else {
			insertSingleLineAtEnd(q,false);
			break;
			}
		}
	delete buffer;

	} else {
	
	// else do not split the line for better performance
	if ((l=strlen(t))) {
		flag=(*(t+l-1)=='\n');
		} else flag=false;
	insertSingleLineAtEnd(t,flag);
	}
}

void mytext::insertSingleLineAtEnd(const char *t, bool complete)
{
// bool complete;
QString help;
bool matches;

	if (!t || !*t) return;
	
	help=t;
//	complete=(help.right(1)=="\n");

	/* delete only one EOL */
	if (help.right(1)=="\n") help.truncate(help.length()-1);
	if (help.right(1)=="\r") help.truncate(help.length()-1);
	
	int lastline=numLines()-1;
	if (!lastLineComplete) {
//		help=textLine(lastline)+help;
//		removeLine(lastline);
// better update performance with insertAt
		QMultiLineEdit::insertAt(help.data(),
			lastline,
			strlen(textLine(lastline)));
		}
	else	QMultiLineEdit::insertLine(help.data());

	// filter only complete lines
	lastline=numLines()-1;
	help=textLine(lastline);
	if (complete) {
		if (re) {
			matches=(re->match(help.data())>=0);
			if ((matches && excludePattern) ||
			(!matches && !excludePattern))
				removeLine(lastline);
			}
		}	
	lastLineComplete=complete;

	while(numLines()>maxLines) {
		removeLine(0);
		kapp->processEvents();
		}
	setCursorPosition(numLines(),0);
}

