#include <kprocess.h>
#include <qobject.h>
#include "kspeech.h"
#include "kspeech.moc"

KSpeech::KSpeech()
  : QObject()
{
  process = 0;
}

KSpeech::~KSpeech()
{
  if ( process ) {
    process->kill();
    delete process;
  }
}

KSpeech *KSpeech::getSynth()
{
  static KSpeech *synth = 0;

  if ( !synth )
    synth = new KSpeech();

  return synth;
}

bool KSpeech::say( const QString &text )
{
  if ( process )
    return true;

  process = new KProcess();
  CHECK_PTR( process );

  *process << "festival";
  *process << "--tts";
  process->start( KProcess::NotifyOnExit, KProcess::Stdin );

  connect( process, SIGNAL( processExited( KProcess * ) ),
	   this, SLOT( done() ) );

  speechText = text;

  warning( "Saying: %s", speechText.data() );

  process->writeStdin( speechText.data(), speechText.length() );
  process->closeStdin();

  return false;
}

void KSpeech::done()
{
  delete process;
  process = 0;
}

bool KSpeech::read( const QString &text,
		    const QString & )
{
  return say( text );
}

bool KSpeech::readFile( const QString & )
{
  if ( process )
    return true;

  return true;
}

void KSpeech::stop()
{
  if ( process ) {
    process->kill();
    delete process;
    process = 0;
  }
}




