    /*

    graphdisplay.C  for  KTsp-0.1.0

    Copyright (C) 1999 Uwe Thiem
                       uwe@kde.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */


#include <qlayout.h>
#include <qstring.h>
#include <qlabel.h>

#include "graphdisplay.h"



GraphDisplay::GraphDisplay( QString text1, QString text2,
                            QWidget *parent, const char *name )
      : QWidget( parent, name )
  {
  QVBoxLayout *layout = new QVBoxLayout( this );
  CHECK_PTR( layout );

  QLabel *label1 = new QLabel( text1, this );
  CHECK_PTR( label1 );
  label1->setMinimumSize( label1->sizeHint() );
  label1->setAlignment( AlignCenter );
  QLabel *label2 = new QLabel( text2, this );
  CHECK_PTR( label2 );
  label2->setMinimumSize( label2->sizeHint() );
  label2->setAlignment( AlignCenter );

  graph = new Graph( this );
  CHECK_PTR( graph );
  graph->setMinimumSize( graph->sizeHint() );

  layout->addWidget( label1, 0 );
  layout->addSpacing( 2 );
  layout->addWidget( graph, 1 );
  layout->addSpacing( 2 );
  layout->addWidget( label2, 0 );
  layout->activate();
  }


GraphDisplay::~GraphDisplay()
  {
  }


int GraphDisplay::numberOfValues()
  {
  return graph->numberOfValues();
  }


double GraphDisplay::firstValue()
  {
  return graph->firstValue();
  }


double GraphDisplay::nextValue()
  {
  return graph->nextValue();
  }


