    /*

    tspdialog.C  for  ktsp-0.1.0

    Copyright (C) 1999 Uwe Thiem
                       uwe@kde.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */


#include <qlayout.h>
#include <kapp.h>

#include "tspdialog.h"


TspDialog::TspDialog( int numberOfPoints,
                      int numberOfPointsDefault,
                      int numberOfRuns,
                      int numberOfRunsDefault,
                      int numberOfNeighbours,
                      int numberOfNeighboursDefault,
                      int rainspeedValue,
                      int rainspeedValueDefault,
                      QWidget *parent,
                      const char *name )
              : QDialog( parent, name, true )
  {
  points = numberOfPoints;
  // we don't accept less than 10 points
  if ( points < 10 ) points = 10;
  pointsDefault = numberOfPointsDefault;
  // some for the default value
  if ( pointsDefault < 10 ) pointsDefault = 10;
  runs = numberOfRuns;
  // we don't accept less than 1 run
  if ( runs < 1 ) runs = 1;
  runsDefault = numberOfRunsDefault;
  // same for the default value
  if ( runsDefault < 1 ) runsDefault = 1;
  neighbours = numberOfNeighbours;
  // we don't accept neighbours < 3 or > 20
  if ( neighbours < 3 ) neighbours = 3;
  if ( neighbours > 20 ) neighbours = 20;
  // and it must be less than points
  if ( neighbours >= points ) neighbours = points - 1;
  neighboursDefault = numberOfNeighboursDefault;
  // same for the default value
  if ( neighboursDefault < 3 ) neighboursDefault = 3;
  if ( neighboursDefault > 20 ) neighboursDefault = 20;
  if ( neighboursDefault >= pointsDefault )
           neighboursDefault = pointsDefault - 1;
  rainspeed = rainspeedValue;
  rainspeedDefault = rainspeedValueDefault;

  // a temporary QLabel for all the static text labels we don't need
  // to access after creation
  QLabel *tmpLabel;

  // the two QGroupBoxes
  QGroupBox *tspBox = new QGroupBox( i18n( "Generating TSPs" ),
                                     this, "TSP Group" );
  CHECK_PTR( tspBox );
  QGroupBox *optimBox = new QGroupBox( i18n( "Optimization" ),
                                       this, "Optim Group" );
  CHECK_PTR( optimBox );

  // our toplevel layout manager for the whole dialog
  QVBoxLayout *layout = new QVBoxLayout( this, 5 );
  CHECK_PTR( layout );

  // the horizontal layout for the buttons
  QHBoxLayout *buttons = new QHBoxLayout();
  CHECK_PTR( buttons );

  // the vertical layouts for the boxes
  QVBoxLayout *box1 = new QVBoxLayout( tspBox, 10 );
  CHECK_PTR( box1 );
  QVBoxLayout *box2 = new QVBoxLayout( optimBox, 10 );
  CHECK_PTR( box2 );

  // the horizontal layout temporarely used
  QHBoxLayout *hlayout;

  // now glue the whole layout hierarchy together
  layout->addWidget( tspBox, 1 );
  layout->addWidget( optimBox, 3 );
  layout->addSpacing( 10 );
  layout->addLayout( buttons );



  // Now for the first QGroupBox
  tmpLabel = new QLabel( i18n( "Number of points" ), tspBox, "Points Text" );
  CHECK_PTR( tmpLabel );
  tmpLabel->setMinimumSize( tmpLabel->sizeHint() );

  pointsSlider = new QSlider( 10, 1000, 1, points,
                              QSlider::Horizontal, tspBox, "Points Slider" );
  CHECK_PTR( pointsSlider );
  pointsSlider->setMinimumSize( pointsSlider->sizeHint() );
  pointsSlider->setMinimumWidth( 180 );
  connect( pointsSlider, SIGNAL( valueChanged( int ) ),
           this, SLOT( slotCheckPoints( int ) ) );

  pointsNum = new QLabel( "XXXXX", tspBox, "Points Numeric" );
  CHECK_PTR( pointsNum );
  pointsNum->setMinimumSize( pointsNum->sizeHint() );
  pointsNum->setFrameStyle( QFrame::Panel | QFrame::Sunken );
  pointsNum->setAlignment( AlignRight | AlignVCenter );
  pointsNum->setNum( points );

  // we need a new temporary horizontal layout
  hlayout = new QHBoxLayout();
  CHECK_PTR( hlayout );

  // now we put the layouts inside the group box together
  box1->addSpacing( 10 );
  box1->addWidget( tmpLabel );
  box1->addLayout( hlayout );
  hlayout->addWidget( pointsSlider, 1 );
  hlayout->addSpacing( 10 );
  hlayout->addWidget( pointsNum, 0 );



  // now for the second QGroupBox
  tmpLabel = new QLabel( i18n( "Number of runs" ), optimBox, "Runs Text" );
  CHECK_PTR( tmpLabel );
  tmpLabel->setMinimumSize( tmpLabel->sizeHint() );

  runsSlider = new QSlider( 1, 200, 1, runs,
                            QSlider::Horizontal, optimBox, "Runs Slider" );
  CHECK_PTR( runsSlider );
  runsSlider->setMinimumSize( runsSlider->sizeHint() );
  runsSlider->setMinimumWidth( 180 );
  connect( runsSlider, SIGNAL( valueChanged( int ) ),
           this, SLOT( slotCheckRuns( int ) ) );

  runsNum = new QLabel( "XXXXX", optimBox, "Runs Numeric" );
  CHECK_PTR( runsNum );
  runsNum->setMinimumSize( runsNum->sizeHint() );
  runsNum->setFrameStyle( QFrame::Panel | QFrame::Sunken );
  runsNum->setAlignment( AlignRight | AlignVCenter );
  runsNum->setNum( runs );

  // we need a new temporary horizontal layout
  hlayout = new QHBoxLayout();
  CHECK_PTR( hlayout );

  // we put the first part of the seconf box together
  box2->addSpacing( 10 );
  box2->addWidget( tmpLabel );
  box2->addLayout( hlayout );
  hlayout->addWidget( runsSlider, 1 );
  hlayout->addSpacing( 10 );
  hlayout->addWidget( runsNum, 0 );


  tmpLabel = new QLabel( i18n( "Number of neighbours" ),
                         optimBox, "Neighbours Text" );
  CHECK_PTR( tmpLabel );
  tmpLabel->setMinimumSize( tmpLabel->sizeHint() );

  neighboursSlider = new QSlider( 3, 20, 1, neighbours,
                            QSlider::Horizontal, optimBox, "Neighbours Slider" );
  CHECK_PTR( neighboursSlider );
  neighboursSlider->setMinimumSize( neighboursSlider->sizeHint() );
  neighboursSlider->setMinimumWidth( 180 );
  connect( neighboursSlider, SIGNAL( valueChanged( int ) ),
           this, SLOT( slotCheckNeighbours( int ) ) );

  neighboursNum = new QLabel( "XXXXX", optimBox, "Neighbours Numeric" );
  CHECK_PTR( neighboursNum );
  neighboursNum->setMinimumSize( neighboursNum->sizeHint() );
  neighboursNum->setFrameStyle( QFrame::Panel | QFrame::Sunken );
  neighboursNum->setAlignment( AlignRight | AlignVCenter );
  neighboursNum->setNum( neighbours );

  // we need a new temporary horizontal layout
  hlayout = new QHBoxLayout();
  CHECK_PTR( hlayout );

  // we put the second part of the second QGroupBox together
  box2->addSpacing( 5 );
  box2->addWidget( tmpLabel );
  box2->addLayout( hlayout );
  hlayout->addWidget( neighboursSlider, 1 );
  hlayout->addSpacing( 10 );
  hlayout->addWidget( neighboursNum, 0 );


  tmpLabel = new QLabel( i18n( "Rainspeed" ),
                         optimBox, "Rain Text" );
  CHECK_PTR( tmpLabel );
  tmpLabel->setMinimumSize( tmpLabel->sizeHint() );

  rainspeedSlider = new QSlider( 0, 100, 1, rainspeed,
                            QSlider::Horizontal, optimBox, "Rain Slider" );
  CHECK_PTR( rainspeedSlider );
  rainspeedSlider->setMinimumSize( rainspeedSlider->sizeHint() );
  rainspeedSlider->setMinimumWidth( 180 );
  connect( rainspeedSlider, SIGNAL( valueChanged( int ) ),
           this, SLOT( slotCheckRain( int ) ) );

  rainspeedNum = new QLabel( "XXXXX", optimBox, "Rain Numeric" );
  CHECK_PTR( rainspeedNum );
  rainspeedNum->setMinimumSize( rainspeedNum->sizeHint() );
  rainspeedNum->setFrameStyle( QFrame::Panel | QFrame::Sunken );
  rainspeedNum->setAlignment( AlignRight | AlignVCenter );
  rainspeedNum->setNum( rainspeed );

  // we need a new tomporary horizontal layout
  hlayout = new QHBoxLayout();
  CHECK_PTR( hlayout );

  // we put the third part of the second QGroupBox together
  box2->addSpacing( 5 );
  box2->addWidget( tmpLabel );
  box2->addLayout( hlayout );
  hlayout->addWidget( rainspeedSlider, 1 );
  hlayout->addSpacing( 10 );
  hlayout->addWidget( rainspeedNum, 0 );


  // now for the QPushButtons

  QPushButton *ok = new QPushButton( i18n( "OK" ), this, "TSP OK" );
  CHECK_PTR( ok );
  QSize s = ok->sizeHint();
  connect( ok, SIGNAL( clicked() ), this, SLOT( slotOK() ) );
  ok->setDefault( true );

  QPushButton *defaults = new QPushButton( i18n( "Defaults" ), this, "TSP Defaults" );
  CHECK_PTR( defaults );
  if ( defaults->sizeHint().width() > s.width() )
                  s.setWidth( defaults->sizeHint().width() );
  connect( defaults, SIGNAL( clicked() ), this, SLOT( slotDefaults() ) );

  QPushButton *cancel = new QPushButton( i18n( "Cancel" ), this, "TSP Cancel" );
  CHECK_PTR( cancel );
  if ( cancel->sizeHint().width() > s.width() )
                  s.setWidth( cancel->sizeHint().width() );
  s.setWidth( s.width() );
  connect( cancel, SIGNAL( clicked() ), this, SLOT( reject() ) );
  ok->setFixedSize( s );
  defaults->setFixedSize( s );
  cancel->setFixedSize( s );

  // the push buttons go into layouts
  buttons->addWidget( ok );
  buttons->addSpacing( 10 );
  buttons->addStretch();
  buttons->addWidget( defaults );
  buttons->addSpacing( 10 );
  buttons->addStretch();
  buttons->addWidget( cancel );


  // finally we activate layout management
  box1->activate();
  box2->activate();
  layout->activate();

  resize( 0, 0 );
  layout->freeze();

  setCaption( i18n( "TSP settings" ) );
  }


TspDialog::~TspDialog()
  {
  }


void TspDialog::slotOK()
  {
  emit pointsChanged( points );
  emit runsChanged( runs );
  emit neighboursChanged( neighbours );
  emit rainspeedChanged( rainspeed );
  accept();
  }


void TspDialog::slotDefaults()
  {
  points = pointsDefault;
  pointsSlider->setValue( points );

  runs = runsDefault;
  runsSlider->setValue( runs );

  neighbours = neighboursDefault;
  neighboursSlider->setValue( neighbours );

  rainspeed = rainspeedDefault;
  rainspeedSlider->setValue( rainspeed );
  }

void TspDialog::slotCheckNeighbours( int number )
  {
  if ( number >= points )
    {
    // neighbours must be smaller than points
    // we just reset QSlider to the old value and don't
    // do anything else
    neighboursSlider->setValue( neighbours );
    }
  else
    {
    neighbours = number;
    neighboursNum->setNum( neighbours );
    }
  }


void TspDialog::slotCheckPoints( int number )
  {
  if ( number <= neighbours )
    {
    // points must be greater than neighbours
    // we just reset QSlider to the old value and don't
    // do anything else
    pointsSlider->setValue( points );
    }
  else
    {
    points = number;
    pointsNum->setNum( points );
    }
  }


void TspDialog::slotCheckRuns( int number )
  {
  runs = number;
  runsNum->setNum( runs );
  }


void TspDialog::slotCheckRain( int number )
  {
  rainspeed = number;
  rainspeedNum->setNum( rainspeed );
  }


