#include <iostream.h>

#include <qpixmapcache.h>
#include <qprinter.h>
#include <qprintdialog.h>
#include <qpainter.h>
#include <qwmatrix.h>
#include <qlistview.h>
#include <qradiobutton.h>
#include <qkeycode.h>
#include <qstrlist.h>

#include <kmsgbox.h>

#include "print.h"
#include "movies.h"
#include "bstar.h"
#include "parseprintcap.h"

extern BStarTree *anchor;
QStrList printerConf;

printWindow::printWindow(KVideoDB *parent):QDialog(parent,0,TRUE)
{
  this->setFixedSize(455,530);

  printerChoice = new QButtonGroup(i18n("Print Destination"),this);
  printerChoice->setGeometry(10,10,435,200);
  connect(printerChoice,SIGNAL(clicked(int)),SLOT(slotPrinterClicked(int)));
  QRadioButton *prn = new QRadioButton(i18n("Printer"),printerChoice,"prn");
  prn->setGeometry(10,20,180,25);
  //  prn->setChecked(TRUE);
  QRadioButton *fil = new QRadioButton(i18n("File"),printerChoice,"fil");
  fil->setGeometry(10,130,180,25);
  
  printers = new QListView(this,"");
  printers->setGeometry(30,60,405,70);
  printers->setAllColumnsShowFocus( TRUE );
  printers->addColumn( i18n("Printer"), 125 );
  printers->addColumn( i18n("Host"), 125 );
  printers->addColumn( i18n("Comment"), 150 );
  printers->setFrameStyle( QFrame::WinPanel + QFrame::Sunken );
  parsePrintcap(printers);
  //  printers->setSelected(printers->firstChild(),TRUE);

  printFile = new QLineEdit(this,"");
  printFile->setGeometry(30,170,405,25);
  //  printFile->setEnabled(FALSE);
  
  paperSize = new QButtonGroup(i18n("Paper Size"),this);
  paperSize->setGeometry(235,215,210,160);
  QRadioButton *a4 = new QRadioButton("A4 (210 x 297 mm)",paperSize,"a4");
  a4->setGeometry(10,20,180,25);
  //  a4->setChecked(TRUE);
  QRadioButton *b5 = new QRadioButton("B5",paperSize,"b5");
  b5->setGeometry(10,45,180,25);
  QRadioButton *letter = new QRadioButton("Letter (8 x 11in)",paperSize,"let");
  letter->setGeometry(10,70,180,25);
  QRadioButton *legal = new QRadioButton("Legal",paperSize,"leg");
  legal->setGeometry(10,95,180,25);
  QRadioButton *executive = new QRadioButton("Executive",paperSize,"exe");
  executive->setGeometry(10,120,180,25);

  pageOrientation = new QButtonGroup(i18n("Paper Orientation"),this);
  pageOrientation->setGeometry(10,215,213,80);
  QRadioButton *portrait = new QRadioButton(i18n("Portrait"),pageOrientation,"por");
  portrait->setGeometry(10,20,180,25);
  //  portrait->setChecked(TRUE);
  QRadioButton *landscape = new QRadioButton(i18n("Landscape"),pageOrientation,"lan");
  landscape->setGeometry(10,45,180,25);
  
  printFormat = new QButtonGroup(i18n("Output Format"),this);
  printFormat->setGeometry(10,300,213,110);
  connect(printFormat,SIGNAL(clicked(int)),SLOT(slotFormatClicked(int)));
  QRadioButton *card = new QRadioButton(i18n("Cards"),printFormat,"car");
  card->setGeometry(10,20,180,25);
  //  card->setChecked(TRUE);
  QRadioButton *label = new QRadioButton(i18n("Labels"),printFormat,"lab");
  label->setGeometry(10,45,180,25);
  QRadioButton *list = new QRadioButton(i18n("List"),printFormat,"lis");
  list->setGeometry(10,70,180,25);
  
  printWhat = new QButtonGroup(i18n("Print Range"),this);
  printWhat->setGeometry(235,380,210,100);
  QRadioButton *all = new QRadioButton(i18n("All"),printWhat,"all");
  all->setGeometry(10,20,180,25);
  //  all->setChecked(TRUE);
  QRadioButton *current = new QRadioButton(i18n("Current"),printWhat,"cur");
  current->setGeometry(10,45,180,25);

  QGroupBox *copFrame = new QGroupBox(this,"");
  copFrame->setGeometry(10,415,213,65);
  copFrame->setTitle(i18n("Number of copies"));
  up = new QPushButton("",copFrame,"up");
  up->setGeometry(180,25,20,12);
  connect(up,SIGNAL(clicked()),SLOT(slotUp()));
  down = new QPushButton("",copFrame,"down");
  down->setGeometry(180,37,20,12);
  down->setEnabled(FALSE);
  connect(down,SIGNAL(clicked()),SLOT(slotDown()));
  copies = new QLineEdit(copFrame,"copies");
  copies->setGeometry(10,25,163,24);
  //  copies->setText("1");
  
  ok = new QPushButton(i18n("&OK"),this,"ok");
  ok->setGeometry(10,495,100,25);
  ok->setDefault(TRUE);
  connect(ok,SIGNAL(clicked()),SLOT(slotOK()));
  
  cancel = new QPushButton(i18n("Cancel"),this,"cancel");
  cancel->setGeometry(345,495,100,25);
  cancel->setAccel(Key_Escape);
  connect(cancel,SIGNAL(clicked()),SLOT(slotCancel()));

  if (printerConf.isEmpty()){
    prn->setChecked(TRUE);
    printers->setSelected(printers->firstChild(),TRUE);
    printFile->setEnabled(FALSE);
    a4->setChecked(TRUE);
    portrait->setChecked(TRUE);
    card->setChecked(TRUE);
    all->setChecked(TRUE);
    copies->setText("1");
  }else{
    if (!strcmp(printerConf.at(1),"Printer")){
      prn->setChecked(TRUE);
      printFile->setEnabled(FALSE);
      QListViewItem *prns = printers->firstChild();
      printers->setSelected(printers->firstChild(),TRUE);
      if (strcmp(printerConf.at(2),""))
	while(strcmp(prns->text(0),printerConf.at(2))){
	  prns=prns->nextSibling();
	  printers->setSelected(prns,TRUE);
	}
    } else {
      fil->setChecked(TRUE);
      printers->setSelected(printers->firstChild(),TRUE);
      printers->setEnabled(FALSE);
      printFile->setText(printerConf.at(2));
    }
    
    if (!strcmp(printerConf.at(3),"A4"))
      a4->setChecked(TRUE);
    else if (!strcmp(printerConf.at(3),"B5"))
      b5->setChecked(TRUE);
    else if (!strcmp(printerConf.at(3),"Legal"))
      legal->setChecked(TRUE);
    else if (!strcmp(printerConf.at(3),"Letter"))
      letter->setChecked(TRUE);
    else
      executive->setChecked(TRUE);

    if (!strcmp(printerConf.at(4),"Portrait"))
      portrait->setChecked(TRUE);
    else
      landscape->setChecked(TRUE);

    if (!strcmp(printerConf.at(5),"Cards"))
      card->setChecked(TRUE);
    else if (!strcmp(printerConf.at(5),"Labels"))
      label->setChecked(TRUE);
    else 
      list->setChecked(TRUE);

    if (!strcmp(printerConf.at(6),"All"))
      all->setChecked(TRUE);
    else
      current->setChecked(TRUE);
    
    copies->setText(printerConf.at(7));

  }
}

QPrinter *getPrinterConf(KVideoDB *parent)
{
  printWindow *printWin;
  QPrinter *printer = new QPrinter();
  printWin = new  printWindow(parent);
  if (!strcmp(printerConf.first(),"None"))
    return NULL;
  
  if (!strcmp(printerConf.at(1),"Printer")){
    printer->setOutputToFile(FALSE);
    printer->setPrinterName(printerConf.at(2));
  }
  else {
    printer->setOutputToFile(TRUE);
    printer->setOutputFileName(printerConf.at(2));
  }

  if (!strcmp(printerConf.at(3),"A4"))
    printer->setPageSize(QPrinter::A4);
  else if (!strcmp(printerConf.at(3),"B5"))
    printer->setPageSize(QPrinter::B5);
  else if (!strcmp(printerConf.at(3),"Legal"))
    printer->setPageSize(QPrinter::Legal);
  else if (!strcmp(printerConf.at(3),"Letter"))
    printer->setPageSize(QPrinter::Letter);
  else
    printer->setPageSize(QPrinter::Executive);
  
  if (!strcmp(printerConf.at(4),"Portrait"))
    printer->setOrientation(QPrinter::Portrait);
  else
    printer->setOrientation(QPrinter::Landscape);
  
  printer->setNumCopies(atoi(printerConf.at(7)));
      
  return printer;
}


void printWindow::slotOK()
{
  printerConf.insert(0,"OK");
  if (printerChoice->find(0)->isOn()){
    printerConf.insert(1,"Printer");
    printerConf.insert(2,printers->currentItem()->text(0));
  }
  else{
    if (!strcmp(printFile->text(),"")){
      KMsgBox::message(this,i18n("Error"),i18n("Specify a file first!"),0,"OK");
      return;
    }
    printerConf.insert(1,"File");
    printerConf.insert(2,printFile->text());
  }

  if (paperSize->find(0)->isOn())
    printerConf.insert(3,"A4");
  else if (paperSize->find(1)->isOn())
    printerConf.insert(3,"B5");
  else if (paperSize->find(2)->isOn())
    printerConf.insert(3,"Letter");
  else if (paperSize->find(3)->isOn())
    printerConf.insert(3,"Legal");
  else
    printerConf.insert(3,"Executive");
  
  if (pageOrientation->find(0)->isOn())
    printerConf.insert(4,"Portrait");
  else
    printerConf.insert(4,"Landscape");
  
  if (printFormat->find(0)->isOn())
    printerConf.insert(5,"Cards");
  else if (printFormat->find(1)->isOn())
    printerConf.insert(5,"Labels");
  else 
    printerConf.insert(5,"List");

  if (printWhat->find(0)->isOn())
    printerConf.insert(6,"All");
  else
    printerConf.insert(6,"Current");

  printerConf.insert(7,copies->text());

  KConfig *kconfig = KApplication::getKApplication()->getConfig();
  kconfig->setGroup("printer");
  kconfig->writeEntry("device",printerConf.at(1));
  kconfig->writeEntry("name",printerConf.at(2));
  kconfig->writeEntry("papersize",printerConf.at(3));
  kconfig->writeEntry("orientation",printerConf.at(4));
  kconfig->writeEntry("format",printerConf.at(5));
  kconfig->writeEntry("range",printerConf.at(6));
  kconfig->writeEntry("copies",printerConf.at(7));
  kconfig->sync();
  
  this->hide();
}

void printWindow::slotCancel()
{
  for (int i=0; i<7; i++)
    printerConf.insert(0,printerConf.at(7));
  printerConf.insert(0,"None");
  this->hide();
}

void printWindow::slotUp()
{
  int count = atoi(copies->text());
  char cntText[20];
  sprintf(cntText,"%d",count+1);
  copies->setText(cntText);
  down->setEnabled(TRUE);
}

void printWindow::slotDown()
{
  int count = atoi(copies->text());
  if (count > 2){
    char cntText[20];
    sprintf(cntText,"%d",count-1);
    copies->setText(cntText);
  }
  else if (count == 2){
    char cntText[20];
    sprintf(cntText,"%d",count-1);
    copies->setText(cntText);    
    down->setEnabled(FALSE);
  }
}

void printWindow::slotPrinterClicked(int index)
{
  if (index == 0){
    printers->setEnabled(TRUE);
    printFile->setEnabled(FALSE);
  }
  else{
    printers->setEnabled(FALSE);
    printFile->setEnabled(TRUE);
    printFile->setFocus();
  }
}

void printWindow::slotOrientationClicked(int index)
{
}


void printWindow::slotFormatClicked(int index)
{
  if (index == 2){
    if (paperSize->find(1)->isOn()){
      paperSize->find(1)->toggle();
      paperSize->find(0)->toggle();
    }
    if (paperSize->find(4)->isOn()){
      paperSize->find(4)->toggle();
      paperSize->find(0)->toggle();
    }
    if (printWhat->find(1)->isOn()){
        printWhat->find(1)->toggle();    
	printWhat->find(0)->toggle();
    }
    paperSize->find(1)->setEnabled(FALSE);
    paperSize->find(4)->setEnabled(FALSE);
    printWhat->find(1)->setEnabled(FALSE);
  }
  else {
    paperSize->find(1)->setEnabled(TRUE);
    paperSize->find(4)->setEnabled(TRUE);
    printWhat->find(1)->setEnabled(TRUE);
  }
}

void printWindow::slotSizeClicked(int index)
{
}

///////////////////////////////////////////////////////////////////////////////////////////

pXPM::pXPM()
{
}


PrintPixmaps::PrintPixmaps()
{
  maxIndex = -1;
}

bool PrintPixmaps::insert(QString key, QPixmap xPM)
{
  if (maxIndex < 49){
    maxIndex++;
    pxpm[maxIndex].key = key;
    pxpm[maxIndex].pxpm = xPM;
    return TRUE;
  } else 
    return FALSE;
}

int PrintPixmaps::find(QString key)
{
  int i=0;
  
  while (i <= maxIndex){
    if (pxpm[i].key == key)
      return i;
    else
      i++;
  }
  return i;
}

void kvdbPrint(KVideoDB *kvdb)
{
  QPrinter *printer = new QPrinter();
  PrintPixmaps pPix;
  QColor back = QColor(255,255,255);
  QString printString;
  QString xpmDummy;
  char  dummy[80];
  int X=50;
  int Y=30;
  int W=305;
  int H=160;
  QFont fnt("Times",9,QFont::Normal,QFont::Latin1);
  QString line="";

  // was the printer-setup succesful?
  
  if ((printer=getPrinterConf(kvdb))){
    
    if (printer->pageSize() == QPrinter::B5)
      Y-=20;
    QPainter paint(printer);
    QWMatrix m;                        // transformation matrix    
    m.scale( .8,.8 );                  // scale coordinate system
                                       // used to scale the icons

    QPixmap omu = QPixmap(picPath("omu.xpm"));
    QPixmap noomu = QPixmap(picPath("noomu.xpm"));
    QPixmap caption = QPixmap(picPath("caption.xpm"));
    QPixmap nocaption = QPixmap(picPath("nocaption.xpm"));
    QPixmap bw = QPixmap(picPath("bw.xpm"));
    QPixmap color = QPixmap(picPath("color.xpm"));
    QPixmap commercial = QPixmap(picPath("commercial.xpm"));
    QPixmap nocommercial = QPixmap(picPath("nocommercial.xpm"));
    QPixmap widescreen = QPixmap(picPath("widescreen.xpm"));
    QPixmap smallscreen = QPixmap(picPath("smallscreen.xpm"));

    for (int count = 0; count < printer->numCopies(); count ++){
      if (!strcmp(printerConf.at(5),"Cards")){
	if (!strcmp(printerConf.at(6),"All")){
	  Movie *current = anchor->firstMovie();
	  while (current){
	    // print each movie in a card,
	    // size and form just like the one of Windows 3.1
	    paint.setFont(fnt);
	    paint.setBackgroundColor(back);
	    paint.setBackgroundMode(TransparentMode);
	    paint.drawRect(X,Y,W,H);
	    paint.drawText(X+5,Y+11,current->title.left(40));
	    line = "(";
	    line += current->category.first();
	    if (strcmp(current->category.last(),"<?>")){
	      line += "/";
	      line += current->category.last();
	    }
	    line += ") (";
	    line += current->cassette + "/";
	    sprintf(dummy,"%d",current->index);
	    line += dummy;
	    line += ")  ";
	    paint.drawText(X,Y+2,W-5,12,AlignRight,line,line.length());
	    paint.drawLine(X,Y+15,X+305,Y+15);
	    paint.drawText(X+5,Y+30,i18n("Original"));
	    paint.drawText(X+70,Y+30,": " + current->original,100);
	    paint.drawText(X+5,Y+45,i18n("Cast"));
	    line = ": ";
	    paint.drawText(X+70,Y+45,line + current->cast.first(),100);
	    paint.drawText(X+70,Y+57,line + current->cast.next(),100);
	    paint.drawText(X+70,Y+69,line + current->cast.next(),100);
	    paint.drawText(X+70,Y+81,line + current->cast.next(),100);
	    paint.drawText(X+5,Y+96,i18n("Director"));
	    paint.drawText(X+70,Y+96,": " + current->director,100);
	    paint.drawText(X+5,Y+108,i18n("Producer"));
	    paint.drawText(X+70,Y+108,": " + current->producer,100);
	    paint.drawText(X+5,Y+123,i18n("Length"));
	    sprintf(dummy,"%d/%d",current->length[0],current->length[1]);
	    line = ": ";
	    line += dummy;
	    line += " min.";
	    paint.drawText(X+70,Y+123,line);
	    paint.drawText(X+5,Y+135,i18n("Year"));
	    line = ": " + current->country + " ";
	    sprintf(dummy,"%d",current->year);
	    line += dummy;
	    paint.drawText(X+70,Y+135,line);
	    QPixmap qp;
	    
	    qp = QPixmap();
	    xpmDummy = picPath(strcat(lowerString(current->sound.data()),".xpm"));
	    int index = pPix.find("kvdb."+xpmDummy);
	    if (index > pPix.maxIndex){
	      qp.load(picPath(strcat(lowerString(current->sound.data()),".xpm")));
	      pPix.insert("kvdb."+xpmDummy,qp);
	      paint.drawPixmap(X+200,Y+25,qp);
	    } else 
	      paint.drawPixmap(X+200,Y+25,pPix.pxpm[index].pxpm);
	    
	    if (current->flags & 1)
	      paint.drawPixmap(X+200,Y+50,bw);
	    else
	      paint.drawPixmap(X+200,Y+50,color);
	    
	    qp = QPixmap();
	    xpmDummy = picPath(strcat(lowerString(current->speed.data()),".xpm"));
	    index = pPix.find("kvdb."+xpmDummy);
	    if (index > pPix.maxIndex){
	      qp.load(picPath(strcat(lowerString(current->speed.data()),".xpm")));
	      pPix.insert("kvdb."+xpmDummy,qp);
	      paint.drawPixmap(X+200,Y+75,qp);
	    } else 
	      paint.drawPixmap(X+200,Y+75,pPix.pxpm[index].pxpm);
	    
	    if (current->flags & 2)
	      paint.drawPixmap(X+200,Y+100,commercial);
	    else
	      paint.drawPixmap(X+200,Y+100,nocommercial);
	    
	    qp = QPixmap();
	    xpmDummy = picPath(strcat(lowerString(current->source.data()),".xpm"));
	    index = pPix.find("kvdb."+xpmDummy);
	    if (index > pPix.maxIndex){
	      qp.load(picPath(strcat(lowerString(current->source.data()),".xpm")));
	      pPix.insert("kvdb."+xpmDummy,qp);
	      paint.drawPixmap(X+200,Y+125,qp);
	    } else
	      paint.drawPixmap(X+200,Y+125,pPix.pxpm[index].pxpm);
	    
	    if (current->flags & 4)
	      paint.drawPixmap(X+230,Y+25,widescreen);
	    else
	      paint.drawPixmap(X+230,Y+25,smallscreen);
	    
	    if (current->flags & 8)
	      paint.drawPixmap(X+230,Y+50,omu);
	    else
	      paint.drawPixmap(X+230,Y+50,noomu);
	    
	    qp = QPixmap();
	    xpmDummy = picPath(strcat(lowerString(current->fsk.data()),".xpm"));
	    index = pPix.find("kvdb."+xpmDummy);
	    if (index > pPix.maxIndex){
	      qp.load(picPath(strcat(lowerString(current->fsk.data()),".xpm")));
	      pPix.insert("kvdb."+xpmDummy,qp);
	      paint.drawPixmap(X+230,Y+75,qp);
	    } else
	      paint.drawPixmap(X+230,Y+75,pPix.pxpm[index].pxpm);
	    
	    if (current->flags & 16)
	      paint.drawPixmap(X+230,Y+100,caption);
	    else
	      paint.drawPixmap(X+230,Y+100,nocaption);
	    
	    qp = QPixmap();
	    xpmDummy = picPath(strcat(lowerString(current->videonorm.data()),".xpm"));
	    index = pPix.find("kvdb."+xpmDummy);
	    if (index > pPix.maxIndex){
	      qp.load(picPath(strcat(lowerString(current->videonorm.data()),".xpm")));
	      pPix.insert("kvdb."+xpmDummy,qp);
	      paint.drawPixmap(X+230,Y+125,qp);
	    } else 
	      paint.drawPixmap(X+230,Y+125,pPix.pxpm[index].pxpm);
	    
	    // move to next card 
	    if ((printer->pageSize() == QPrinter::A4) || (printer->pageSize() == QPrinter::Legal) ||
		(printer->pageSize() == QPrinter::Letter) || (printer->pageSize() == QPrinter::Executive)){
	      if (printer->orientation() == QPrinter::Portrait){
		Y+=170;
		// if last card on page already printed, goto the beginning of the next page
		if (Y>550){
		  printer->newPage();
		  Y=30;
		}
	      } else if (printer->orientation() == QPrinter::Landscape){
		Y += 170;
		if (Y>380){
		  Y=30;
		  if (X > 50){
		    printer->newPage();
		    X=50;
		  } else
		    X += 320;
		}
	      }
	    } else {
	      if (printer->orientation() == QPrinter::Portrait){
		Y+=170;
		if (Y>350){
		  printer->newPage();
		  Y=10;
		}
	      } else if (printer->orientation() == QPrinter::Landscape){
		Y+=170;
		if (Y>350){
		  Y=10;
		  if (X>50){
		    printer->newPage();
		    X=50;
		  } else
		    X+=320;
		}
	      }
	    }
	    current = anchor->nextMovie();
	  }
	} else {   // only print the current movie
	  QString key = kvdb->movies->text(kvdb->movies->currentItem());
	  Movie *current = anchor->currentMovie(key);
	  
	  paint.setFont(fnt);
	  paint.setBackgroundColor(back);
	  paint.setBackgroundMode(TransparentMode);
	  paint.drawRect(X,Y,W,H);
	  paint.drawText(X+5,Y+11,current->title.left(40));
	  line = "(";
	  line += current->category.first();
	  if (strcmp(current->category.last(),"<?>")){
	    line += "/";
	    line += current->category.last();
	  }
	  line += ") (";
	  line += current->cassette + "/";
	  sprintf(dummy,"%d",current->index);
	  line += dummy;
	  line += ")  ";
	  paint.drawText(X,Y+2,W-5,12,AlignRight,line,line.length());
	  paint.drawLine(X,Y+15,X+305,Y+15);
	  paint.drawText(X+5,Y+30,i18n("Original"));
	  paint.drawText(X+70,Y+30,": " + current->original,100);
	  paint.drawText(X+5,Y+45,i18n("Cast"));
	  line = ": ";
	  paint.drawText(X+70,Y+45,line + current->cast.first(),100);
	  paint.drawText(X+70,Y+57,line + current->cast.next(),100);
	  paint.drawText(X+70,Y+69,line + current->cast.next(),100);
	  paint.drawText(X+70,Y+81,line + current->cast.next(),100);
	  paint.drawText(X+5,Y+96,i18n("Director"));
	  paint.drawText(X+70,Y+96,": " + current->director,100);
	  paint.drawText(X+5,Y+108,i18n("Producer"));
	  paint.drawText(X+70,Y+108,": " + current->producer,100);
	  paint.drawText(X+5,Y+123,i18n("Length"));
	  sprintf(dummy,"%d/%d",current->length[0],current->length[1]);
	  line = ": ";
	  line += dummy;
	  line += " min.";
	  paint.drawText(X+70,Y+123,line);
	  paint.drawText(X+5,Y+135,i18n("Year"));
	  line = ": " + current->country + " ";
	  sprintf(dummy,"%d",current->year);
	  line += dummy;
	  paint.drawText(X+70,Y+135,line);
	  QPixmap qp;
	  
	  qp = QPixmap();
	  xpmDummy = picPath(strcat(lowerString(current->sound.data()),".xpm"));
	  int index = pPix.find("kvdb."+xpmDummy);
	  if (index > pPix.maxIndex){
	    qp.load(picPath(strcat(lowerString(current->sound.data()),".xpm")));
	    pPix.insert("kvdb."+xpmDummy,qp);
	    paint.drawPixmap(X+200,Y+25,qp);
	  } else 
	    paint.drawPixmap(X+200,Y+25,pPix.pxpm[index].pxpm);
	  
	  if (current->flags & 1)
	    paint.drawPixmap(X+200,Y+50,bw);
	  else
	    paint.drawPixmap(X+200,Y+50,color);
	  
	  qp = QPixmap();
	  xpmDummy = picPath(strcat(lowerString(current->speed.data()),".xpm"));
	  index = pPix.find("kvdb."+xpmDummy);
	  if (index > pPix.maxIndex){
	    qp.load(picPath(strcat(lowerString(current->speed.data()),".xpm")));
	    pPix.insert("kvdb."+xpmDummy,qp);
	    paint.drawPixmap(X+200,Y+75,qp);
	  } else 
	    paint.drawPixmap(X+200,Y+75,pPix.pxpm[index].pxpm);
	  
	  if (current->flags & 2)
	    paint.drawPixmap(X+200,Y+100,commercial);
	  else
	    paint.drawPixmap(X+200,Y+100,nocommercial);
	  
	  qp = QPixmap();
	  xpmDummy = picPath(strcat(lowerString(current->source.data()),".xpm"));
	  index = pPix.find("kvdb."+xpmDummy);
	  if (index > pPix.maxIndex){
	    qp.load(picPath(strcat(lowerString(current->source.data()),".xpm")));
	    pPix.insert("kvdb."+xpmDummy,qp);
	    paint.drawPixmap(X+200,Y+125,qp);
	  } else
	    paint.drawPixmap(X+200,Y+125,pPix.pxpm[index].pxpm);
	  
	  if (current->flags & 4)
	    paint.drawPixmap(X+230,Y+25,widescreen);
	  else
	    paint.drawPixmap(X+230,Y+25,smallscreen);
	  
	  if (current->flags & 8)
	    paint.drawPixmap(X+230,Y+50,omu);
	  else
	    paint.drawPixmap(X+230,Y+50,noomu);
	  
	  qp = QPixmap();
	  xpmDummy = picPath(strcat(lowerString(current->fsk.data()),".xpm"));
	  index = pPix.find("kvdb."+xpmDummy);
	  if (index > pPix.maxIndex){
	    qp.load(picPath(strcat(lowerString(current->fsk.data()),".xpm")));
	    pPix.insert("kvdb."+xpmDummy,qp);
	    paint.drawPixmap(X+230,Y+75,qp);
	  } else
	    paint.drawPixmap(X+230,Y+75,pPix.pxpm[index].pxpm);
	  
	  if (current->flags & 16)
	    paint.drawPixmap(X+230,Y+100,caption);
	  else
	    paint.drawPixmap(X+230,Y+100,nocaption);
	  
	  qp = QPixmap();
	  xpmDummy = picPath(strcat(lowerString(current->videonorm.data()),".xpm"));
	  index = pPix.find("kvdb."+xpmDummy);
	  if (index > pPix.maxIndex){
	    qp.load(picPath(strcat(lowerString(current->videonorm.data()),".xpm")));
	    pPix.insert("kvdb."+xpmDummy,qp);
	    paint.drawPixmap(X+230,Y+125,qp);
	  } else 
	    paint.drawPixmap(X+230,Y+125,pPix.pxpm[index].pxpm);
	  
	}
      } else if (!strcmp(printerConf.at(5),"Labels")){
	 KMsgBox::message(kvdb,i18n("Error"),i18n("The printing of labels is not implemented, yet!"),0,"OK");
      } else {  // List
	X=10;
	int titleWidth;
	int propWidth;
	int height=15;
	QFont fnt2("Courier",7,QFont::Normal,QFont::Latin1);
	paint.setFont(fnt2);
	
	if (!strcmp(printerConf.at(4),"Portrait")){
	  X-=5;
	  titleWidth=73;
	  propWidth=40;
	  paint.drawLine(X,Y+height,590,Y+height);
	  paint.drawLine(X+5+propWidth,Y+height/4,X+5+propWidth,735);
	  paint.drawLine(X+7+titleWidth+propWidth,Y+height/4,X+7+titleWidth+propWidth,735);
	  paint.drawLine(X+9+titleWidth+2*propWidth,Y+height/4,X+9+titleWidth+2*propWidth,735);
	  paint.drawLine(X+11+titleWidth+3*propWidth,Y+height/4,X+11+titleWidth+3*propWidth,735);
	  paint.drawLine(X+13+2*titleWidth+3*propWidth,Y+height/4,X+13+2*titleWidth+3*propWidth,735);
	  paint.drawLine(X+15+3*titleWidth+3*propWidth,Y+height/4,X+15+3*titleWidth+3*propWidth,735);
	  paint.drawLine(X+17+4*titleWidth+3*propWidth,Y+height/4,X+17+4*titleWidth+3*propWidth,735);
	} else {
	  X+=20;
	  titleWidth=110;
	  propWidth=40;
	  paint.drawLine(X,Y+height,750,Y+height);
	  paint.drawLine(X+5+propWidth,Y+height/4,X+5+propWidth,555);
	  paint.drawLine(X+7+titleWidth+propWidth,Y+height/4,X+7+titleWidth+propWidth,555);
	  paint.drawLine(X+9+titleWidth+2*propWidth,Y+height/4,X+9+titleWidth+2*propWidth,555);
	  paint.drawLine(X+11+titleWidth+3*propWidth,Y+height/4,X+11+titleWidth+3*propWidth,555);
	  paint.drawLine(X+13+2*titleWidth+3*propWidth,Y+height/4,X+13+2*titleWidth+3*propWidth,555);
	  paint.drawLine(X+15+3*titleWidth+3*propWidth,Y+height/4,X+15+3*titleWidth+3*propWidth,555);
	  paint.drawLine(X+17+4*titleWidth+3*propWidth,Y+height/4,X+17+4*titleWidth+3*propWidth,555);
	} 
	
	paint.drawText(X+5,Y,propWidth,height,AlignHCenter|AlignBottom,i18n("Cassette:"));
	paint.drawText(X+7+propWidth,Y,titleWidth,height,AlignHCenter|AlignBottom,i18n("Title:"));
	paint.drawText(X+9+titleWidth+propWidth,Y,propWidth,height,AlignHCenter|AlignBottom,i18n("Release:"));
	paint.drawText(X+11+titleWidth+2*propWidth,Y,propWidth,height,AlignHCenter|AlignBottom,i18n("Length:"));
	paint.drawText(X+11+titleWidth+3*propWidth,Y,titleWidth,height,AlignHCenter|AlignBottom,i18n("Director:"));
	paint.drawText(X+13+2*titleWidth+3*propWidth,Y,titleWidth,height,AlignHCenter|AlignBottom,i18n("Cast:"));
	paint.drawText(X+15+3*titleWidth+3*propWidth,Y,titleWidth,height,AlignHCenter|AlignBottom,i18n("Category:"));
	paint.drawText(X+17+4*titleWidth+3*propWidth,Y,titleWidth,height,AlignHCenter|AlignBottom,i18n("Properties:"));
	
	
	Y+=15;
	X+=5;
	if (!strcmp(printerConf.at(6),"All")) {
	  Movie *current = anchor->firstMovie();
	  while (current){
	    QString listDummy = current->cassette;
	    listDummy += " / ";
	    char ld2[6];
	    sprintf(ld2,"%d",current->index);
	    listDummy+=ld2;
	    paint.drawText(X,Y,propWidth,height,AlignLeft|AlignVCenter,listDummy);
	    paint.drawText(X+propWidth+2,Y,titleWidth,height,AlignLeft|AlignVCenter,current->title);
	    if (strcmp(current->original,"")){
	      listDummy = "(" + current->original + ")";
	      paint.drawText(X+propWidth+2,Y+height,titleWidth,height,AlignLeft|AlignVCenter,listDummy);
	    } 
 	    paint.drawText(X+propWidth+titleWidth+4,Y,propWidth,height,AlignLeft|AlignVCenter,current->country);
	    if (current->year > 0){
	      sprintf(ld2,"%d",current->year);
	      paint.drawText(X+propWidth+titleWidth+4,Y+height,propWidth,height,AlignLeft|AlignVCenter,ld2);
	    }
	    if (current->length[0] > -1){
	      sprintf(ld2,"%d",current->length[0]);
	      paint.drawText(X+titleWidth+2*propWidth+6,Y,propWidth,height,AlignLeft|AlignVCenter,ld2);
	    }
	    if (current->length[1] > -1){
	      sprintf(ld2,"(%d)",current->length[1]);
	      paint.drawText(X+titleWidth+2*propWidth+6,Y+height,propWidth,height,AlignLeft|AlignVCenter,ld2);
	    }
	    paint.drawText(X+titleWidth+3*propWidth+8,Y,titleWidth,height,AlignLeft|AlignVCenter,current->director);
 	    paint.drawText(X+2*titleWidth+3*propWidth+10,Y,titleWidth,height,AlignLeft|AlignVCenter,current->cast.first());
 	    paint.drawText(X+2*titleWidth+3*propWidth+10,Y+height,titleWidth,height,AlignLeft|AlignVCenter,current->cast.next());
	    if (strcmp(current->category.first(),"<?>"))
	      paint.drawText(X+3*titleWidth+3*propWidth+12,Y,titleWidth,height,AlignLeft|AlignVCenter,current->category.first());
	    if (strcmp(current->category.at(1),"<?>"))
	      paint.drawText(X+3*titleWidth+3*propWidth+12,Y+height,titleWidth,height,AlignLeft|AlignVCenter,current->category.at(1));
	    
	    QPixmap qp = QPixmap();
	    xpmDummy = picPath(strcat(lowerString(current->sound.data()),".xpm"));
	    int index = pPix.find("kvdb."+xpmDummy);
	    if (index > pPix.maxIndex){
	      qp.load(picPath(strcat(lowerString(current->sound.data()),".xpm")));
	      pPix.insert("kvdb."+xpmDummy,qp);
	      paint.drawPixmap(X+4*titleWidth+3*propWidth+14,Y+3,qp);
	    } else
	      paint.drawPixmap(X+4*titleWidth+3*propWidth+14,Y+3,pPix.pxpm[index].pxpm);

	    qp = QPixmap();
	    xpmDummy = picPath(strcat(lowerString(current->speed.data()),".xpm"));
	    index = pPix.find("kvdb."+xpmDummy);
	    if (index > pPix.maxIndex){
	      qp.load(picPath(strcat(lowerString(current->speed.data()),".xpm")));
	      pPix.insert("kvdb."+xpmDummy,qp);
	      paint.drawPixmap(X+4*titleWidth+3*propWidth+39,Y+3,qp);
	    } else
	      paint.drawPixmap(X+4*titleWidth+3*propWidth+39,Y+3,pPix.pxpm[index].pxpm);

	    qp = QPixmap();
	    xpmDummy = picPath(strcat(lowerString(current->source.data()),".xpm"));
	    index = pPix.find("kvdb."+xpmDummy);
	    if (index > pPix.maxIndex){
	      qp.load(picPath(strcat(lowerString(current->source.data()),".xpm")));
	      pPix.insert("kvdb."+xpmDummy,qp);
	      paint.drawPixmap(X+4*titleWidth+3*propWidth+64,Y+3,qp);
	    } else
	      paint.drawPixmap(X+4*titleWidth+3*propWidth+64,Y+3,pPix.pxpm[index].pxpm);

	    qp = QPixmap();
	    xpmDummy = picPath(strcat(lowerString(current->fsk.data()),".xpm"));
	    index = pPix.find("kvdb."+xpmDummy);
	    if (index > pPix.maxIndex){
	      qp.load(picPath(strcat(lowerString(current->fsk.data()),".xpm")));
	      pPix.insert("kvdb."+xpmDummy,qp);
	      paint.drawPixmap(X+4*titleWidth+3*propWidth+89,Y+3,qp);
	    } else
	      paint.drawPixmap(X+4*titleWidth+3*propWidth+89,Y+3,pPix.pxpm[index].pxpm);

	    qp = QPixmap();
	    xpmDummy = picPath(strcat(lowerString(current->videonorm.data()),".xpm"));
	    index = pPix.find("kvdb."+xpmDummy);
	    if (index > pPix.maxIndex){
	      qp.load(picPath(strcat(lowerString(current->videonorm.data()),".xpm")));
	      pPix.insert("kvdb."+xpmDummy,qp);
	      paint.drawPixmap(X+4*titleWidth+3*propWidth+114,Y+3,qp);
	    } else
	      paint.drawPixmap(X+4*titleWidth+3*propWidth+114,Y+3,pPix.pxpm[index].pxpm);

	    if (!strcmp(printerConf.at(4),"Portrait"))
	      paint.drawLine(X-5,Y+2*height,590,Y+2*height);
	    else
	      paint.drawLine(X-5,Y+2*height,750,Y+2*height);

	    current = anchor->nextMovie();
	    Y+=30;
	    if (!strcmp(printerConf.at(4),"Portrait")){
	      if (Y > 720){
		printer->newPage();
		Y=30;
		X-=5;
		paint.drawLine(X,Y+height,590,Y+height);
		paint.drawLine(X+5+propWidth,Y+height/4,X+5+propWidth,735);
		paint.drawLine(X+7+titleWidth+propWidth,Y+height/4,X+7+titleWidth+propWidth,735);
		paint.drawLine(X+9+titleWidth+2*propWidth,Y+height/4,X+9+titleWidth+2*propWidth,735);
		paint.drawLine(X+11+titleWidth+3*propWidth,Y+height/4,X+11+titleWidth+3*propWidth,735);
		paint.drawLine(X+13+2*titleWidth+3*propWidth,Y+height/4,X+13+2*titleWidth+3*propWidth,735);
		paint.drawLine(X+15+3*titleWidth+3*propWidth,Y+height/4,X+15+3*titleWidth+3*propWidth,735);
		paint.drawLine(X+17+4*titleWidth+3*propWidth,Y+height/4,X+17+4*titleWidth+3*propWidth,735);
		paint.drawText(X+5,Y,propWidth,height,AlignHCenter|AlignBottom,i18n("Cassette:"));
		paint.drawText(X+7+propWidth,Y,titleWidth,height,AlignHCenter|AlignBottom,i18n("Title:"));
		paint.drawText(X+9+titleWidth+propWidth,Y,propWidth,height,AlignHCenter|AlignBottom,i18n("Release:"));
		paint.drawText(X+11+titleWidth+2*propWidth,Y,propWidth,height,AlignHCenter|AlignBottom,i18n("Length:"));
		paint.drawText(X+11+titleWidth+3*propWidth,Y,titleWidth,height,AlignHCenter|AlignBottom,i18n("Director:"));
		paint.drawText(X+13+2*titleWidth+3*propWidth,Y,titleWidth,height,AlignHCenter|AlignBottom,i18n("Cast:"));
		paint.drawText(X+15+3*titleWidth+3*propWidth,Y,titleWidth,height,AlignHCenter|AlignBottom,i18n("Category:"));
		paint.drawText(X+17+4*titleWidth+3*propWidth,Y,titleWidth,height,AlignHCenter|AlignBottom,i18n("Properties:"));
		Y+=15;
		X+=5;
	      }
	    }
	    else{
	      if (Y>530){
		printer->newPage();
		Y=30;
		X-=5;
		paint.drawLine(X,Y+height,750,Y+height);
		paint.drawLine(X+5+propWidth,Y+height/4,X+5+propWidth,555);
		paint.drawLine(X+7+titleWidth+propWidth,Y+height/4,X+7+titleWidth+propWidth,555);
		paint.drawLine(X+9+titleWidth+2*propWidth,Y+height/4,X+9+titleWidth+2*propWidth,555);
		paint.drawLine(X+11+titleWidth+3*propWidth,Y+height/4,X+11+titleWidth+3*propWidth,555);
		paint.drawLine(X+13+2*titleWidth+3*propWidth,Y+height/4,X+13+2*titleWidth+3*propWidth,555);
		paint.drawLine(X+15+3*titleWidth+3*propWidth,Y+height/4,X+15+3*titleWidth+3*propWidth,555);
		paint.drawLine(X+17+4*titleWidth+3*propWidth,Y+height/4,X+17+4*titleWidth+3*propWidth,555);
		paint.drawText(X+5,Y,propWidth,height,AlignHCenter|AlignBottom,i18n("Cassette:"));
		paint.drawText(X+7+propWidth,Y,titleWidth,height,AlignHCenter|AlignBottom,i18n("Title:"));
		paint.drawText(X+9+titleWidth+propWidth,Y,propWidth,height,AlignHCenter|AlignBottom,i18n("Release:"));
		paint.drawText(X+11+titleWidth+2*propWidth,Y,propWidth,height,AlignHCenter|AlignBottom,i18n("Length:"));
		paint.drawText(X+11+titleWidth+3*propWidth,Y,titleWidth,height,AlignHCenter|AlignBottom,i18n("Director:"));
		paint.drawText(X+13+2*titleWidth+3*propWidth,Y,titleWidth,height,AlignHCenter|AlignBottom,i18n("Cast:"));
		paint.drawText(X+15+3*titleWidth+3*propWidth,Y,titleWidth,height,AlignHCenter|AlignBottom,i18n("Category:"));
		paint.drawText(X+17+4*titleWidth+3*propWidth,Y,titleWidth,height,AlignHCenter|AlignBottom,i18n("Properties:"));
		Y+=15;
		X+=5;
	      }
	    }
	  }
	} else {
	}
      }
      if (count < printer->numCopies()-1){
	X=50;
	Y=30;
	W=305;
	H=160;
	printer->newPage();
      }
      
    }
    
  }
  return;
}
