/*
 *   kvideolist - a database for home-movie collections
 *   Copyright (C) 1998  Holger Hetterich
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or           
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <kfm.h>                                       
#include <stdio.h>
#include <qfiledlg.h>
#include <qcolor.h>
#include <qtooltip.h>
#include "mlist.h"
#include "printlist.moc"
#include "preview.h"


// BE WARNED! This is *ugly* code! KVideolist is still my project to learn something.




PrintList::PrintList(QWidget *parent, const char *name):QDialog(parent,name,TRUE) {
	this->setCaption(klocale->translate("Print movie-lists..."));
	this->resize(800,400);
	PREVIEWFLAG=FALSE;
	QLabel *StandartL = new QLabel(klocale->translate("Templates:"),this);
	StandartL->move(400,0);

	LineWidth= new QScrollBar(15,90,1,10,15,QScrollBar::Vertical,this,"test");
	LineWidth->move(0,300);
	LineWidth->resize(20,85);
		
	connect(LineWidth,SIGNAL(valueChanged( int)),SLOT(slotWidth()));




	Standarts=new QComboBox(FALSE,this,"choose");
	Standarts->insertItem(klocale->translate("Simple list"),0);
	Standarts->insertItem(klocale->translate("Advanced list"),1);
	Standarts->insertItem(klocale->translate("Complex list"),2);
	Standarts->insertItem(klocale->translate("None"),3);
	Standarts->setCurrentItem(3);
	Standarts->move(400,25);Standarts->adjustSize();
	VerticalLine = new QCheckBox(klocale->translate("Vertical lines"),this);
	VerticalLine->move(400,60);VerticalLine->adjustSize();
	HorizontalLines = new QCheckBox(klocale->translate("Horizontal lines"),this);
	HorizontalLines->adjustSize();
	HorizontalLines->move(550,60);
	
QToolTip::add(HorizontalLines,klocale->translate("Should a horizontal line included after every entry?"));



QToolTip::add(VerticalLine,klocale->translate("Decide wether vertical lines should be printed or not."));
	
	QLabel *Docu1 = new QLabel(klocale->translate("The list will be printed as You have sorted it."),this);
	Docu1->resize(267,30);Docu1->move(65,2);
	QLabel *Docu2 = new QLabel(klocale->translate("(1) Select the\n items which \n should be \n included in \n the list..."),this);
	Docu2->resize(75,110);Docu2->move(0,30);
	QLabel *Docu3 = new QLabel(klocale->translate("(2)... and \n define the \n fonts in \n the list."),this);
	Docu3->resize(75,55);Docu3->move(0,165);
	QLabel *Docu4 = new QLabel(klocale->translate("(3)Below You see a preview of one example entry in Your list. \n Change the layout to fit Your needs."),this);
	Docu4->resize(382,30);Docu4->move(10,257);


	Docu1->setFont(QFont("helvecita",12));
	Docu2->setFont(QFont("helvecita",12));
	Docu3->setFont(QFont("helvecita",12));
	Docu4->setFont(QFont("helvecita",12));

	Stereo = new QCheckBox(klocale->translate("Stereo"),this);
	Stereo->move(80,30);Stereo->resize(100,30);
	connect(Stereo,SIGNAL(clicked()),SLOT(slotSetupPos()));
QToolTip::add(Stereo,klocale->translate("Should the list include a 'Stereo' entry?"));

	Surround = new QCheckBox(klocale->translate("Surround"),this);
	Surround->move(180,30);Surround->resize(100,30);
	connect(Surround,SIGNAL(clicked()),SLOT(slotSetupPos()));
QToolTip::add(Surround,klocale->translate("Should the list include a 'Surround' entry?"));

	MovieText= new QCheckBox(klocale->translate("MovieText"),this);
	MovieText->move(280,30);MovieText->resize(100,30);
	connect(MovieText,SIGNAL(clicked()),SLOT(slotSetupPos()));
QToolTip::add(MovieText,klocale->translate("Should the list include a 'MovieText' entry?"));

	Genres= new QCheckBox(klocale->translate("Genres"),this);
	Genres->move(80,60);Genres->resize(100,30);
	connect(Genres,SIGNAL(clicked()),SLOT(slotSetupPos()));
QToolTip::add(Genres,klocale->translate("Should the list include the two 'Genre' entrys?"));

	LongPlay= new QCheckBox(klocale->translate("LongPlay"),this);
	LongPlay->move(180,60);LongPlay->resize(100,30);
	connect(LongPlay,SIGNAL(clicked()),SLOT(slotSetupPos()));
QToolTip::add(LongPlay,klocale->translate("Should the list include a 'LongPlay' entry?"));

	Color= new QCheckBox(klocale->translate("Color"),this);
	Color->move(281,59);Color->resize(100,30);
	connect(Color,SIGNAL(clicked()),SLOT(slotSetupPos()));
QToolTip::add(Color,klocale->translate("Should the list include a 'Color' entry?"));

	StartTime= new QCheckBox(klocale->translate("Start-time (if available)"),this);
	StartTime->move(80,90);StartTime->resize(160,30);
	StartTime->setFont(QFont("helvecita",12));
	connect(StartTime,SIGNAL(clicked()),SLOT(slotSetupPos()));
QToolTip::add(StartTime,klocale->translate("Should the list include a 'Start-time' entry?"));
	

	PlayTime= new QCheckBox(klocale->translate("Play-time (if available)"),this);
	PlayTime->setFont(QFont("helvecita",12));
	connect(PlayTime,SIGNAL(clicked()),SLOT(slotSetupPos()));
QToolTip::add(PlayTime,klocale->translate("Should the list include a 'Play-time' entry?"));

	PlayTime->move(80,120);PlayTime->resize(160,30);
	QLabel *L1 = new QLabel(klocale->translate("Entry height:"),this);
	L1->move(80,150);L1->resize(90,30);
L1->setFont(QFont("helvecita",12));
	L1->hide();
	QPushButton *L2 = new QPushButton(klocale->translate("Global Font"),this);
	L2->move(80,175);L2->adjustSize();
	QToolTip::add(L2,klocale->translate("Select the font used for the list."));

	QLabel *L3 = new QLabel(klocale->translate("Lines per page:"),this);
	L3->move(80,210);L3->resize(100,30);
L3->setFont(QFont("helvecita",12));
	
	LineSpacing= new QLineEdit(this,"linespacing");
	LineSpacing->move(175,154);LineSpacing->resize(50,20);
	LineSpacing->hide();L3->hide();	

	LinesPage= new QLineEdit(this,"linesperpage");
	LinesPage->move(175,216);LinesPage->resize(50,20);
	LinesPage->hide();

	QPushButton *Print = new QPushButton(klocale->translate("Print"),this);
	Print->move(255,95);Print->resize(121,30);
	QToolTip::add(Print,klocale->translate("Print the list."));

	QPushButton *FontSelect = new QPushButton(klocale->translate("Select Item-Font"),this);
	connect(FontSelect,SIGNAL(clicked()),SLOT(FontSelectOn()));
	QToolTip::add(FontSelect,klocale->translate("Select Font for a specific item. Click first here, then on the item\n to change."));
	FontSelect->move(80,215);FontSelect->adjustSize();
	
	QPushButton *SaveConfig = new QPushButton(klocale->translate("Save Layout"),this);
	SaveConfig->move(620,215+50);SaveConfig->adjustSize();
	QPushButton *Preview = new QPushButton(klocale->translate("Preview"),this);
	Preview->move(255,175);
	Preview->resize(121,30);
	QPushButton *Cancel = new QPushButton(klocale->translate("Cancel"),this);
	Cancel->move(255,215);Cancel->resize(121,30);
	QToolTip::add(Cancel,klocale->translate("Forget all changes \n and switch back to main window."));

	connect(Print,SIGNAL(clicked()),SLOT(slotPrint()));
	connect(L2,SIGNAL(clicked()),SLOT(slotFont()));
	connect(SaveConfig,SIGNAL(clicked()),SLOT(slotConfig()));
	connect(Cancel,SIGNAL(clicked()),SLOT(reject()));
	connect(Standarts,SIGNAL(activated(int)),SLOT(slotStandarts()));
	connect(Preview,SIGNAL(clicked()),SLOT(slotPreview()));
	
	// Drag and Drop List Configuration ! 

	PosMovieNrMove=FALSE;
	PosTapeMove=FALSE;
	PosLPMove=FALSE;
	PosNameMove=FALSE;
	PosSurroundMove=FALSE;
	PosStereoMove=FALSE;
	PosPlayTimeMove=FALSE;
	PosStartTimeMove=FALSE;
	PosColorMove=FALSE;
	PosMovieTextMove=FALSE;
	PosGenre1Move=FALSE;
	PosGenre2Move=FALSE;
	
	CONFIGME=FALSE;
	PosMovieNr = new QPushButton(klocale->translate("Movie Nr"),this);
	PosName = new QPushButton(klocale->translate("Title"),this);
	PosLongPlay = new QPushButton(klocale->translate("LP"),this);
	PosTapeNr = new QPushButton(klocale->translate("Tape"),this);
	PosSurround= new QPushButton(klocale->translate("Surround"),this);
	PosStereo= new QPushButton(klocale->translate("Stereo"),this);
	PosColor= new QPushButton(klocale->translate("Color"),this);
	PosMovieText= new QPushButton(klocale->translate("MovieText"),this);
	PosStartTime= new QPushButton(klocale->translate("StartTime"),this);
	PosPlayTime= new QPushButton(klocale->translate("PlayTime"),this);
	PosGenre1= new QPushButton(klocale->translate("Genre(1)"),this);
	PosGenre2= new QPushButton(klocale->translate("Genre(2)"),this);
	Beispiel= new QPushButton(klocale->translate("Hide Descriptions"),this);
	Beispiel->adjustSize();
	Beispiel->move(400,215+50);
	BEISPIEL=FALSE;
	Grid = new QPushButton(klocale->translate("Show Grid"),this);
	Grid->adjustSize();
	Grid->move(530,215+50);
	GRID=FALSE;



	connect(PosMovieNr,SIGNAL(clicked()),SLOT(MoveMovieNr()));

	connect(PosTapeNr,SIGNAL(clicked()),SLOT(MoveTapeNr()));
	connect(PosLongPlay,SIGNAL(clicked()),SLOT(MoveLongPlay()));
	connect(PosName,SIGNAL(clicked()),SLOT(MoveName()));
	connect(PosSurround,SIGNAL(clicked()),SLOT(MoveSurround()));
	connect(PosStereo,SIGNAL(clicked()),SLOT(MoveStereo()));
	connect(PosColor,SIGNAL(clicked()),SLOT(MoveColor()));
	connect(PosMovieText,SIGNAL(clicked()),SLOT(MoveMovieText()));
	connect(PosStartTime,SIGNAL(clicked()),SLOT(MoveStartTime()));
	connect(PosPlayTime,SIGNAL(clicked()),SLOT(MovePlayTime()));
	connect(PosGenre1,SIGNAL(clicked()),SLOT(MoveGenre1()));
	connect(PosGenre2,SIGNAL(clicked()),SLOT(MoveGenre2()));
	connect(Beispiel,SIGNAL(clicked()),SLOT(slotBeispiel()));
	connect(Grid,SIGNAL(clicked()),SLOT(slotGrid()));
	QToolTip::add(PosName,klocale->translate("Move this button to where\n the 'Name' entry should be."));
	QToolTip::add(PosLongPlay,klocale->translate("Move this button to where\n the 'LongPlay' entry should be."));
	QToolTip::add(PosStereo,klocale->translate("Move this button to where\n the 'Stereo' entry should be."));
	QToolTip::add(PosSurround,klocale->translate("Move this button to where\n the 'Surround' entry should be."));
	QToolTip::add(PosMovieText,klocale->translate("Move this button to where\n the 'MovieText' entry should be."));
	QToolTip::add(PosGenre1,klocale->translate("Move this button to where\n the first genre entry should be."));
	QToolTip::add(PosGenre2,klocale->translate("Move this button to where\n the second genre entry should be."));
	QToolTip::add(PosStartTime,klocale->translate("Move this button to where\n the 'Start-Time' entry should be."));
	QToolTip::add(PosPlayTime,klocale->translate("Move this button to where the 'Play-Time' entry should be."));
	QToolTip::add(PosTapeNr,klocale->translate("Move this button to where the 'Tape-Number' entry should be."));
	QToolTip::add(PosMovieNr,klocale->translate("Move this button to where the 'Movie-position' entry should be."));
	QToolTip::add(Beispiel,klocale->translate("Toggle the view between an\n example entry and the\n descriptions of the buttons."));
	QToolTip::add(Grid,klocale->translate("Switch the grid on or off."));
	QToolTip::add(Standarts,klocale->translate("Choose on of the predefined\n layouts."));
	QToolTip::add(SaveConfig,klocale->translate("Save Your layout."));
	QToolTip::add(LineWidth,klocale->translate("Set the height of \n one entry in the list here."));

 
	PosTapeNr->adjustSize();
	PosLongPlay->adjustSize();
	PosName->adjustSize();
	PosSurround->adjustSize();
	PosStereo->adjustSize();
	PosColor->adjustSize();
	PosMovieText->adjustSize();
	PosStartTime->adjustSize();
	PosPlayTime->adjustSize();
	PosGenre1->adjustSize();
	PosGenre2->adjustSize();
	PosMovieText->adjustSize();
	PosMovieNr->adjustSize();


	PosTapeNr->move(400,95);
	PosLongPlay->move(500,95);
	PosName->move(600,95);
	PosSurround->move(700,95);
	PosStereo->move(400,145);
	PosColor->move(500,145);
	PosMovieText->move(600,145);
	PosStartTime->move(700,145);
	PosPlayTime->move(400,195);
	PosGenre1->move(500,195);
	PosGenre2->move(600,195);
	PosMovieNr->move(700,195);
	BREITE=25;

	FONTSELECT=FALSE;
	setGlobalFont();
	




	slotSetupPos();
	
	this->setMouseTracking(TRUE);	
};


void PrintList::setGlobalFont() {         // Sets all Fonts to the Global Font (f)

	NameFont=f;
	TapeNrFont=f;
	MovieNrFont=f;
	StereoFont=f;
	ColorFont=f;
	MovieTextFont=f;
	SurroundFont=f;
	StartTimeFont=f;	
	PlayTimeFont=f;
	Genre1Font=f;
	Genre2Font=f;
};
	



void PrintList::FontSelectOn() {
	FONTSELECT=TRUE;
	
	// Change the Cursor here!
	QApplication::setOverrideCursor( crossCursor);   
	
	};



void PrintList::slotWidth() {
BREITE=LineWidth->value()+5;
this->repaint();

};


	



void PrintList::paintEvent( QPaintEvent *)
{
QPainter Liste;
Liste.begin(this);
Liste.setBrush(QColor(255,255,255));
Liste.drawRect(22,300,600,BREITE);
Liste.drawRect(400,95,98,50);
Liste.drawRect(500,95,98,50);
Liste.drawRect(600,95,98,50);
Liste.drawRect(700,95,98,50);

Liste.drawRect(400,145,98,50);
Liste.drawRect(500,145,98,50);
Liste.drawRect(600,145,98,50);
Liste.drawRect(700,145,98,50);

Liste.drawRect(400,195,98,50);
Liste.drawRect(500,195,98,50);
Liste.drawRect(600,195,98,50);
Liste.drawRect(700,195,98,50);


if (GRID==TRUE) { Liste.setPen(DashLine); 
		int x=22;int y=300;
		while (x<780) { x=x+15; Liste.drawLine(x,300,x,300+BREITE);};
		while (y<300+BREITE) { y=y+15;Liste.drawLine(22,y,790,y);};
		Liste.setPen(SolidLine);
		};



Liste.end();


        QPainter Paint;

        Paint.begin(this);
        Paint.setFont(f);
	Paint.setFont(StereoFont);
        if (Stereo->isChecked()==TRUE) { Paint.drawText(PosStereo->x(),PosStereo->y()+(PosStereo->height()/2),"*"); };
        Paint.setFont(SurroundFont);
	if (Surround->isChecked()==TRUE) { Paint.drawText(PosSurround->x(),PosSurround->y()+(PosSurround->height()/2),"*"); };
        Paint.setFont(MovieTextFont);
	if (MovieText->isChecked()==TRUE) {Paint.drawText(PosMovieText->x(),PosMovieText->y()+(PosMovieText->height()/2),"*");};
        Paint.setFont(ColorFont);
	if (Color->isChecked()==TRUE) { Paint.drawText(PosColor->x(),PosColor->y()+(PosColor->height()/2),"*");};
        Paint.setFont(LongPlayFont);
	if (LongPlay->isChecked()==TRUE) {Paint.drawText(PosLongPlay->x(),PosLongPlay->y()+(PosLongPlay->height()/2),"*");};
	Paint.setFont(NameFont);
        Paint.drawText(PosName->x(),PosName->y()+(PosName->height()/2),"Alien (1)");
	Paint.setFont(MovieNrFont);

	Paint.drawText(PosMovieNr->x(),PosMovieNr->y()+(PosMovieNr->height()/2),"1");
	Paint.setFont(TapeNrFont);

        Paint.drawText(PosTapeNr->x(),PosTapeNr->y()+(PosTapeNr->height()/2),"143");
Paint.setFont(Genre1Font);
if (Genres->isChecked()==TRUE) {	Paint.drawText(PosGenre1->x(),PosGenre1->y()+(PosGenre1->height()/2),"Horror");
					Paint.setFont(Genre2Font);
	Paint.drawText(PosGenre2->x(),PosGenre2->y()+(PosGenre2->height()/2),"SciFi"); };


Paint.setFont(PlayTimeFont);

if (PlayTime->isChecked()==TRUE) {	Paint.drawText(PosPlayTime->x(),PosPlayTime->y()+(PosPlayTime->height()/2),"1:45");};

Paint.setFont(StartTimeFont);
if (StartTime->isChecked()==TRUE) {	Paint.drawText(PosStartTime->x(),PosStartTime->y()+(PosStartTime->height()/2),"1:30");};




	Paint.end();

        
                                       
};

void PrintList::slotSetupPos() {
PosColor->show();PosStereo->show();PosSurround->show();PosGenre1->show();PosGenre2->show();PosPlayTime->show();PosStartTime->show();PosLongPlay->show();PosMovieText->show();
	
	if (Color->isChecked()==FALSE) PosColor->hide();
	if (Stereo->isChecked()==FALSE) PosStereo->hide();
	if (Surround->isChecked()==FALSE) PosSurround->hide();
	if (Genres->isChecked()==FALSE) {PosGenre1->hide();PosGenre2->hide();};
	if (PlayTime->isChecked()==FALSE) PosPlayTime->hide();
	if (StartTime->isChecked()==FALSE) PosStartTime->hide();
	if (LongPlay->isChecked()==FALSE) PosLongPlay->hide();
	if (MovieText->isChecked()==FALSE) PosMovieText->hide();
	
	this->update();this->repaint();
};



void PrintList::slotGrid() {
	if (GRID==TRUE) { GRID=FALSE; Grid->setText(klocale->translate("Show Grid"));} else { GRID=TRUE; Grid->setText(klocale->translate("Hide Grid"));};
this->repaint();

};


void PrintList::slotBeispiel() {
	
	if (BEISPIEL==TRUE) { BEISPIEL=FALSE;Beispiel->setText(klocale->translate("Hide descriptions"));} else { BEISPIEL=TRUE;Beispiel->setText(klocale->translate("Show descriptions"));};

if (BEISPIEL==TRUE) {
		
		slotAdjustSize();
		PosLongPlay->hide();
		PosName->hide();
		PosSurround->hide();
		PosStereo->hide();
		PosColor->hide();
		PosMovieText->hide();
		PosStartTime->hide();
		PosPlayTime->hide();
		PosGenre1->hide();
		PosGenre2->hide();
		PosTapeNr->hide();
		PosMovieNr->hide();
		this->update();
		};

if (BEISPIEL==FALSE) {
		PosLongPlay->show();
		PosName->show();
		PosSurround->show();
		PosStereo->show();
		PosColor->show();
		PosMovieText->show();
		PosGenre1->show();
		PosGenre2->show();
		PosTapeNr->show();
		PosStartTime->show();
		PosPlayTime->show();
		PosMovieNr->show();
		slotAdjustSize();
		slotSetupPos();
		this->update();
		};



};


void PrintList::slotAdjustSize() {

     PosTapeNr->adjustSize();
        PosLongPlay->adjustSize();
        PosName->adjustSize();
        PosSurround->adjustSize();
        PosStereo->adjustSize();
        PosColor->adjustSize();
        PosMovieText->adjustSize();
        PosStartTime->adjustSize();
        PosPlayTime->adjustSize();
        PosGenre1->adjustSize();
        PosGenre2->adjustSize();
        PosMovieText->adjustSize();
	PosMovieNr->adjustSize();
         };


void PrintList::mouseReleaseEvent(QMouseEvent *e) {
		PosTapeMove=FALSE;
		PosLPMove=FALSE;
		PosNameMove=FALSE;
		PosColorMove=FALSE;
		PosStartTimeMove=FALSE;
		PosPlayTimeMove=FALSE;
		PosStereoMove=FALSE;
		PosSurroundMove=FALSE;
		PosGenre1Move=FALSE;
		PosGenre2Move=FALSE;
		PosMovieNrMove=FALSE;
		this->update();		
	};

void PrintList::mouseMoveEvent(QMouseEvent *e) {


	if (PosMovieNrMove==TRUE) { PosMovieNr->move(e->x(),e->y());PosMovieNr->update();};

	if (PosTapeMove==TRUE) { PosTapeNr->move(e->x(),e->y());PosTapeNr->update();};
	if (PosNameMove==TRUE) { PosName->move(e->x(),e->y()); PosName->update();};
	if (PosLPMove==TRUE) { PosLongPlay->move(e->x(),e->y());PosLongPlay->update();};
	if (PosStartTimeMove==TRUE) { PosStartTime->move(e->x(),e->y());PosStartTime->update();};
	if (PosPlayTimeMove==TRUE) { PosPlayTime->move(e->x(),e->y());PosPlayTime->update();};
	if (PosStereoMove==TRUE) { PosStereo->move(e->x(),e->y());PosStereo->update();};
	if (PosSurroundMove==TRUE) {PosSurround->move(e->x(),e->y());PosSurround->update();};
	if (PosMovieTextMove==TRUE) {PosMovieText->move(e->x(),e->y());PosMovieText->update();};
	if (PosColorMove==TRUE) {PosColor->move(e->x(),e->y());PosColor->update();};
	if (PosGenre1Move==TRUE) { PosGenre1->move(e->x(),e->y());PosGenre1->update();};
	if (PosGenre2Move==TRUE) { PosGenre2->move(e->x(),e->y());PosGenre2->update();};



			};

void PrintList::MoveMovieNr() {
if (FONTSELECT==TRUE) {	QApplication::restoreOverrideCursor();
 			 KFontDialog *Selection = new KFontDialog(this,"selection");
        		Selection->getFont(MovieNrFont);  
			slotSetupPos();
          		FONTSELECT=FALSE;
			return; };





if (PosMovieNrMove==TRUE) { PosMovieNrMove=FALSE;this->update();} else { PosMovieNrMove=TRUE;}; 
};


void PrintList::MoveTapeNr() {

if (FONTSELECT==TRUE) { QApplication::restoreOverrideCursor();
                         KFontDialog *Selection = new KFontDialog(this,"selection");
                        Selection->getFont(TapeNrFont);                                                                                                                             slotSetupPos();
                        FONTSELECT=FALSE;
                        return; };                    

	
if     (PosTapeMove==TRUE) { PosTapeMove=FALSE;this->update();} else { PosTapeMove=TRUE; }; 
	
	};

void PrintList::MoveLongPlay() {

if (FONTSELECT==TRUE) {QApplication::restoreOverrideCursor();
                         KFontDialog *Selection = new KFontDialog(this,"selection");
                        Selection->getFont(LongPlayFont);                                                                                                                             slotSetupPos();
                        FONTSELECT=FALSE;
                        return; };                    


if   	(PosLPMove==TRUE) { PosLPMove=FALSE;this->update();} else { PosLPMove=TRUE;};
};

void PrintList::MoveName() {

if (FONTSELECT==TRUE) {QApplication::restoreOverrideCursor();
                         KFontDialog *Selection = new KFontDialog(this,"selection");
                        Selection->getFont(NameFont);                                                                                                                             slotSetupPos();
                        FONTSELECT=FALSE;
                        return; };                    

if 	(PosNameMove==TRUE) { PosNameMove=FALSE;this->update();} else { PosNameMove=TRUE;};
};

void PrintList::MoveSurround() {

if (FONTSELECT==TRUE) {QApplication::restoreOverrideCursor();
                         KFontDialog *Selection = new KFontDialog(this,"selection");
                        Selection->getFont(SurroundFont);                                                                                                                             slotSetupPos();
                        FONTSELECT=FALSE;
                        return; };                    


if (PosSurroundMove==TRUE) { PosSurroundMove=FALSE;this->update();} else { PosSurroundMove=TRUE;};
};

void PrintList::MoveStereo() {

if (FONTSELECT==TRUE) {QApplication::restoreOverrideCursor();
                         KFontDialog *Selection = new KFontDialog(this,"selection");
                        Selection->getFont(StereoFont);                                                                                                                             slotSetupPos();
                        FONTSELECT=FALSE;
                        return; };                    


if (PosStereoMove==TRUE) { PosStereoMove=FALSE;this->update();} else { PosStereoMove=TRUE;};

};

void PrintList::MoveColor() {

if (FONTSELECT==TRUE) {QApplication::restoreOverrideCursor();
                         KFontDialog *Selection = new KFontDialog(this,"selection");
                        Selection->getFont(ColorFont);                                                                                                                             slotSetupPos();
                        FONTSELECT=FALSE;
                        return; };                    

if (PosColorMove==TRUE) { PosColorMove=FALSE;this->update();} else { PosColorMove=TRUE;};
};

void PrintList::MoveMovieText() {

if (FONTSELECT==TRUE) {QApplication::restoreOverrideCursor();
                         KFontDialog *Selection = new KFontDialog(this,"selection");
                        Selection->getFont(MovieTextFont);                                                                                                                             slotSetupPos();
                        FONTSELECT=FALSE;
                        return; };                    


if (PosMovieTextMove==TRUE) { PosMovieTextMove=FALSE;this->update();} else { PosMovieTextMove=TRUE;};
};

void PrintList::MovePlayTime() {

if (FONTSELECT==TRUE) {QApplication::restoreOverrideCursor();
                         KFontDialog *Selection = new KFontDialog(this,"selection");
                        Selection->getFont(PlayTimeFont);                                                                                                                             slotSetupPos();
                        FONTSELECT=FALSE;
                        return; };                    


if (PosPlayTimeMove==TRUE) { PosPlayTimeMove=FALSE;this->update();} else { PosPlayTimeMove=TRUE;};
};

void PrintList::MoveStartTime() {

if (FONTSELECT==TRUE) {QApplication::restoreOverrideCursor();
                         KFontDialog *Selection = new KFontDialog(this,"selection");
                        Selection->getFont(StartTimeFont);                                                                                                                             slotSetupPos();
                        FONTSELECT=FALSE;
                        return; };                    


if (PosStartTimeMove==TRUE) { PosStartTimeMove=FALSE;this->update();} else { PosStartTimeMove=TRUE;};

};


void PrintList::MoveGenre1() {


if (FONTSELECT==TRUE) {QApplication::restoreOverrideCursor();
                         KFontDialog *Selection = new KFontDialog(this,"selection");
                        Selection->getFont(Genre1Font);                                                                                                                             slotSetupPos();
                        FONTSELECT=FALSE;
                        return; };                    

if (PosGenre1Move==TRUE) { PosGenre1Move=FALSE;this->update();} else { PosGenre1Move=TRUE;};
};

void PrintList::MoveGenre2() {

if (FONTSELECT==TRUE) {QApplication::restoreOverrideCursor();
                         KFontDialog *Selection = new KFontDialog(this,"selection");
                        Selection->getFont(Genre2Font);                                                                                                                             slotSetupPos();
                        FONTSELECT=FALSE;
                        return; };                    


if (PosGenre2Move==TRUE) { PosGenre2Move=FALSE;this->update();} else { PosGenre2Move=TRUE;};
};


void PrintList::slotStandarts() {
	if (Standarts->currentItem()==0) { setSimpleDefault(); };
	if (Standarts->currentItem()==1) { setNormalDefault(); };
	if (Standarts->currentItem()==2) { setComplexDefault(); };
};


void PrintList::slotPreview() {

PLpreview *Preview= new PLpreview(this,klocale->translate("Preview"));
QPainter List;


List.drawText(10,10,"Hallo");

Preview->show();


	};

void PrintList::slotConfig() {
	int fehler;
	fehler=check();
	if (fehler==-1) { QMessageBox::information(this,klocale->translate("Mistake..."),klocale->translate("The value You entered for Linespacing is invalid. \n Choose another. "));return;};
	if (fehler==-2) { QMessageBox::information(this,klocale->translate("Mistake..."),klocale->translate("The value You entered for 'Lines per Page' is invalid. \n Choose another."));return;};

	CONFIGME = TRUE;
	QMessageBox::information(this,klocale->translate("Configuration..."),klocale->translate("The configuration has been saved."));
	accept();

};
						
			
	
void PrintList::slotFont() {
	KFontDialog *Selection = new KFontDialog(this,"selection");
	Selection->getFont(f);
	setGlobalFont();
	ChangeFont();

	};
int PrintList::check() {



	return 0;
	};

	
void PrintList::slotPrint()
{
	char Numbers[12][10];
	char TimeString[15];
	strcpy(Numbers[0],"1");
	strcpy(Numbers[1],"2");
	strcpy(Numbers[2],"3");
	strcpy(Numbers[3],"4");
	strcpy(Numbers[4],"5");
	strcpy(Numbers[5],"6");
	strcpy(Numbers[6],"7");
	strcpy(Numbers[7],"8");
	strcpy(Numbers[8],"9");
	strcpy(Numbers[9],"10");
	char GenreString[23][20];
	strcpy(GenreString[0],klocale->translate("Horror"));
	strcpy(GenreString[1],klocale->translate("Comedy"));
	strcpy(GenreString[2],klocale->translate("SciFi"));
	strcpy(GenreString[3],klocale->translate("Thriller"));
	strcpy(GenreString[4],klocale->translate("Action"));
	strcpy(GenreString[5],klocale->translate("Crimi"));
	strcpy(GenreString[6],klocale->translate("Documentation"));
	strcpy(GenreString[7],klocale->translate("Cartoon"));
	strcpy(GenreString[8],klocale->translate("Drama"));
	strcpy(GenreString[9],klocale->translate("Monumental"));
	strcpy(GenreString[10],klocale->translate("Western"));
	strcpy(GenreString[11],klocale->translate("Erotic"));
	strcpy(GenreString[12],klocale->translate("Adventure"));
	strcpy(GenreString[13],klocale->translate("Musical"));
	strcpy(GenreString[14],klocale->translate("War"));
	strcpy(GenreString[15],klocale->translate("Catastrophe"));
	strcpy(GenreString[16],klocale->translate("Psycho"));
	strcpy(GenreString[17],klocale->translate("Satire"));
	strcpy(GenreString[18],klocale->translate("Fantasy"));
	strcpy(GenreString[19],klocale->translate("Traditional"));
	strcpy(GenreString[20],klocale->translate("Theatre"));
	strcpy(GenreString[21],klocale->translate("Other"));
	strcpy(GenreString[22],"     ");

// 	QFont f("courier",atoi(FontSize->text()),QFont::Normal);
	
	QPrinter Druck;
	char Dummy[80];
	FILE *Liste;
	FILE *Daten;
	Element Data;
	Namen Names;
	int LineCount = 1;
	char Listenname[255];
	char PreviewName[255];
	strcpy(Listenname,Filename);
	strcat(Listenname,"x");
	strcpy(PreviewName,Filename);
	strcat(PreviewName,".txt");

	Liste=fopen(Listenname,"rb");
	Daten=fopen(Filename,"rb");
 	int y=0;	
	LineCount=1;

	QPainter Paint;
		
	int vonoben=20;	



if (Druck.setup(0)) {

	


	 Paint.begin(&Druck);

	

	Paint.setFont(f);
				

	while (!feof(Liste)) { 
		
		fread(&Names,sizeof(Namen),1,Liste); 


		
		while (strcmp(Data.Name,Names.Name)!=0) {
			fread(&Data,sizeof(Element),1,Daten);
			};
		rewind(Daten);

		// Now we have the data of the current movie

		// Add LineSpacing to y
		strcpy(Dummy,LineSpacing->text());
if (HorizontalLines->isChecked()) { Paint.drawLine(0,y+BREITE,700,y+BREITE); };

		y=y+BREITE;
		
		LineCount++;

     

  
	Paint.setFont(StereoFont);


        if (Stereo->isChecked()==TRUE) { if (Data.Stereo==TRUE) Paint.drawText(PosStereo->x(),y+PosStereo->y()+(PosStereo->height()/2)-300,"*"); };

	Paint.setFont(SurroundFont);
        if (Surround->isChecked()==TRUE) { if (Data.Surround==TRUE) Paint.drawText(PosSurround->x(),y+PosSurround->y()+(PosSurround->height()/2)-300,"*"); };
	Paint.setFont(MovieTextFont);

        if (MovieText->isChecked()==TRUE) {if (Data.MovieText==TRUE) Paint.drawText(PosMovieText->x(),y+PosMovieText->y()+(PosMovieText->height()/2)-300,"*");};
	Paint.setFont(ColorFont);
        if (Color->isChecked()==TRUE) { if (Data.Color==TRUE) Paint.drawText(PosColor->x(),y+PosColor->y()+(PosColor->height()/2)-300,"*");};
	Paint.setFont(LongPlayFont);
        if (LongPlay->isChecked()==TRUE) { if (Data.LP==TRUE) Paint.drawText(PosLongPlay->x(),y+PosLongPlay->y()+(PosLongPlay->height()/2)-300,"*");};
	Paint.setFont(NameFont);

QString *Name= new QString(Data.Name);


        Paint.drawText(PosName->x(),y+PosName->y()+(PosName->height()/2)-300,Data.Name);
	QString *t=new QString();
	t->setNum(Data.Number);




	Paint.setFont(MovieNrFont);
        Paint.drawText(PosMovieNr->x(),y+PosMovieNr->y()+(PosMovieNr->height()/2)-300,t->data());
	Paint.setFont(TapeNrFont);

        Paint.drawText(PosTapeNr->x(),y+PosTapeNr->y()+(PosTapeNr->height()/2-300),Data.Nr);
	Paint.setFont(Genre1Font);
if (Genres->isChecked()==TRUE) {        Paint.drawText(PosGenre1->x(),y+PosGenre1->y()+(PosGenre1->height()/2-300),GenreString[Data.Genre1]);
        Paint.setFont(Genre2Font);
	if (Data.Genre2<22) Paint.drawText(PosGenre2->x(),y+PosGenre2->y()+(PosGenre2->height()/2-300),GenreString[Data.Genre2]); };
Paint.setFont(PlayTimeFont);
if (PlayTime->isChecked()==TRUE) {      Paint.drawText(PosPlayTime->x(),y+PosPlayTime->y()+(PosPlayTime->height()/2)-300,"1:45");};
Paint.setFont(StartTimeFont);
if (StartTime->isChecked()==TRUE) {     Paint.drawText(PosStartTime->x(),y+PosStartTime->y()+(PosStartTime->height()/2)-300,"1:30");};



	
		if (y> 700 )  {Druck.newPage(); LineCount=1;y=0;
				
			

				// Print Header
				

                                };                                

				};



         

		
		
		
	Paint.end();
	
		};





close(Liste);

remove(Listenname);
if (PREVIEWFLAG==TRUE) { KFM *url = new KFM;
			 url->allowKFMRestart(TRUE);
			url->openURL(PreviewName); };
remove(PreviewName);

};
				
void PrintList::setSimpleDefault() {
	LineWidth->setValue(35);

	Color->setChecked(FALSE);
	Stereo->setChecked(FALSE);
	Surround->setChecked(FALSE);
	MovieText->setChecked(FALSE);
	Genres->setChecked(FALSE);
	PlayTime->setChecked(FALSE);
	StartTime->setChecked(TRUE);
	LongPlay->setChecked(FALSE);
	f=QFont("helvecita",14,QFont::Normal,FALSE);
	LineSpacing->setText("30");
	LinesPage->setText("25");
	slotAdjustSize();
	ChangeFont();
	PosName->move(80,310);
	PosTapeNr->move(300-20,310);
	PosMovieNr->move(350-20,310);
	PosStartTime->move(550,310);
	slotSetupPos();







};

void PrintList::setNormalDefault() {

       LineWidth->setValue(35);

        Color->setChecked(FALSE);
        Stereo->setChecked(FALSE);
        Surround->setChecked(FALSE);
        MovieText->setChecked(FALSE);
        Genres->setChecked(TRUE);
        PlayTime->setChecked(TRUE);
        StartTime->setChecked(TRUE);
        LongPlay->setChecked(TRUE);
        f=QFont("helvecita",14,QFont::Normal,FALSE);
        LineSpacing->setText("30");
        LinesPage->setText("25");
        slotAdjustSize();
        ChangeFont();
        PosName->move(80,310);
        PosTapeNr->move(300-20,310);
        PosMovieNr->move(350-20,310);
        PosStartTime->move(550,317);
	PosGenre1->move(500-20,302);
	PosGenre2->move(500-20,317);
     	PosPlayTime->move(550,302);
	PosLongPlay->move(400-20,310);
 
	  slotSetupPos();

                                         	


};

void PrintList::setComplexDefault() {			
	

 LineWidth->setValue(35);

        Color->setChecked(TRUE);
        Stereo->setChecked(TRUE);
        Surround->setChecked(TRUE);
        MovieText->setChecked(TRUE);
        Genres->setChecked(TRUE);
        PlayTime->setChecked(TRUE);
        StartTime->setChecked(TRUE);
        LongPlay->setChecked(TRUE);
        f=QFont("helvecita",14,QFont::Normal,FALSE);
        LineSpacing->setText("30");
        LinesPage->setText("25");
        slotAdjustSize();
        ChangeFont();
        PosName->move(80,310);
        PosTapeNr->move(300-20,310);
        PosMovieNr->move(350-20,310);
        PosStartTime->move(550,317);
        PosGenre1->move(500-20,302);
        PosGenre2->move(500-20,317);
        PosPlayTime->move(550,302);
        PosLongPlay->move(380-20,310);
	PosStereo->move(400-20,310);
	PosSurround->move(420-20,310);
	PosMovieText->move(440-20,310);
	PosColor->move(460-20,310);
	
          slotSetupPos();

                                                         


	};

void PrintList::ChangeFont() {

PosMovieNr->setFont(f);
PosTapeNr->setFont(f);
PosName->setFont(f);
PosLongPlay->setFont(f);
PosSurround->setFont(f);
PosStereo->setFont(f);
PosColor->setFont(f);
PosStartTime->setFont(f);
PosPlayTime->setFont(f);
PosGenre1->setFont(f);
PosGenre2->setFont(f);
PosMovieText->setFont(f);  
slotAdjustSize();     	
 };







	
		

 







	
