// kviewer.h
// Author: Markus Wuebben <markus.wuebben@kde.org>
// This code is published under the GPL.
// March 1998

#ifndef KVIEWER_H
#define KVIEWER_H

#include <X11/Xlib.h> // XBell
#include <X11/keysym.h>
#undef TrueColor

#include <qpopmenu.h>
#include <qpushbt.h>
#include <qlined.h>
#include <qlabel.h>
#include <qdialog.h>
#include <qscrbar.h>
#include <qimage.h>
#include <qpixmap.h>
#include <qbitmap.h>
#include <qcursor.h>
#include <qevent.h>
#include <qkeycode.h>
#include <qtimer.h>
#include <kapp.h>
#include <ktopwidget.h>
#include <ktoolbar.h>
#include <kstatusbar.h>
#include <kmenubar.h>
#include <kmsgbox.h>
#include <iostream.h>
#include "QwViewport.h"
#include "krfbproto.h"

class kRfbProto;
class KVNCAuthWdg;

struct rfbServerInitMsg;


#define LeftButtonBits  0x01
#define MidButtonBits   0x02
#define RightButtonBits 0x04

class KVNCCanvas : public QWidget {

Q_OBJECT

 public:
  KVNCCanvas(QWidget *parent = 0, const char *name = 0);
  ~KVNCCanvas(); 

 public slots:
  
  /** Draws the data that comes  rfbProto::rfbEncodingRaw encoded. **/
  void drawRawRect(CARD8*,int,int,int,int);

  /** Draws the data that comes rfbProto::rfbEncodingCopyRect encoded.
      Actually just to the coordinates come in. **/
  void copyRect(int srcX, int srcY, int destX, int destY, int w, int h);

  void fillRect(int x,int y, int w, int h, unsigned long value);

  /** Opens connection to server **/
  bool openConnection();

  /** Closes connection to server **/
  void closeConnection();
  
  /** Refreshes screen with incremental = false. Is called from menuBar. **/
  void refreshDisplay();

  /** Sets hosts **/
  void setHost(const char *h)  { _host = h;}

  /** Returns host **/
  const char * host() { return _host;}

  /** Sets server display **/
  void setDisplay(int d) { _dis = d;}

  /** Returns display **/
  int display() { return _dis;}

  /** Returns port **/
  int port() { return (_dis + 5900);}
  
  /** sets VNC password **/
  void setPassword(const char *p) { _password = p;}

  /** gets VNC password **/
  const char * password() {return _password;}

  /** gets Server initialization **/
  rfbServerInitMsg * getServerInformation();

  /** Returns desktop name **/
  const char * desktop() { return rfb->desktop();}


 private slots:
  void initCanvas(); 
  void createCursor();
  bool initConnection();
  int authenticate();
  void setConnected(bool c);
  bool connected() { return _connected;}
  void bell();
  void displayData();
  void fatal();
  void handleTimeout();
  void setRefresh(bool);
  KeySym determineKey(QKeyEvent *);


 private:
  QScrollBar *horzBar;
  QScrollBar *vertBar;
  int frameHeight,frameWidth, depth;
  kRfbProto *rfb;
  CARD8 mask; // global buttonMask
  bool leftButtonDown;
  bool midButtonDown;
  bool rightButtonDown;
  bool _connected;
  const char * _host;
  int _dis;
  QString _password;

  QImage screenImage;
  QPixmap screenPixmap;
  QPixmap tempPixmap;
  int offX, offY, offW, offH;
  uint bpp;

  QTimer *timer;
  bool refreshing;

 signals:
  
  /** Tells parent to update statusbar. **/
  void updateStatusBar(const char* ,int);

  /** something fatal has occured. Closes down connection. **/
  void sigFatal();

  /** Widgets size changed **/
  void sizeChanged();

protected:
 virtual void keyPressEvent(QKeyEvent *);
 virtual void keyReleaseEvent(QKeyEvent*);
 virtual void mousePressEvent(QMouseEvent*);
 virtual void mouseReleaseEvent(QMouseEvent*);
 virtual void mouseMoveEvent(QMouseEvent*);
 virtual void paintEvent(QPaintEvent *);

};



class KVNCViewer : public KTopLevelWidget {
Q_OBJECT
public: 
 KVNCViewer(QWidget *parent = 0 , const char *name = 0);
 ~KVNCViewer(); 



public slots:

  bool openConnection(); 

  bool connected() { return _connected;}
  void setConnected(bool c);

  void updateStatusBar(const char *, int);
  void fatal();

private slots:
  void setupMenuBar();
  void setupToolBar(); 
  void setupStatusBar();
  void closeConnection();
  void close();
  void serverInformation();
  void initConfig();

		 
 private:
  QwViewport *viewport;
  KVNCCanvas *canvas;
  KMenuBar *menuBar; 
  KToolBar *toolBar;
  KStatusBar *statusBar;
  bool _connected;



};



#endif 






















