/***************************************************************************
                          chart.h  -  description
                             -------------------
    begin                : Fri Jun 2 2000
    copyright            : (C) 2000 by CFJH
    email                : hochwald@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
    kweather - a program for recording weather events
    Copyright (C) 1999 Jrgen Hochwald <hochwald@kde.org>
	
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
			
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
					
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/    
#ifndef _CHART_H_
#define _CHART_H_

#include <stdio.h>
#include <qwindow.h>
#include <qpainter.h> 
#include <qpixmap.h>
#include <qdatetime.h>
#include <qfile.h>
#include <qimage.h>
#include <qmessagebox.h>
#include <kiconloader.h>
#include <ktopwidget.h>
#include "globals.h"
#include "data.h"

#define DISP_TAG 0
#define DISP_MONAT 1
#define DISP_JAHR 2


int sign(double x);
QPixmap CalcWetterImage(int Code);
QPixmap CalcSmallWetterImage(int Code);

class TChart : public QWindow
{
   Q_OBJECT
public:
   TChart(QWidget* parent=0, const char* name=0, WFlags f=0);
   ~TChart();
   char *GetFileName(void) {return dateiName;};
   //int MonTage(int Monat, int Jahr); // Tage eines Monats berechnen
   int MTage(void);          // Tage des aktuellen Monats berechnen
   int FPos(void) { return fCurrent;};   // Dateiposition
   int FSize(void) { return fMonate;};   // Dateistze insgesamt
   void PrevDay(void);
   void NextDay(void);
   void FirstDay(void);
   void LastDay(void);
   void UpdateTag(int Tag);  // Tageswerte aktualisieren

   DataFile* DF;             // Datendateiobjekt
   //struct MonTyp monat;
   int FileActive;
   int DispTag;              // Tag, fr den die Tagesdaten gezeigt werden sollen
   //int GridY;                // Gridteilungen Y-Richtung
   //int GridN;                // Nulllinie im Grid
   //struct GridSettingsType GridDefaults;  // Voreinstellungen fr die Gridanzeige

protected:
   void paintEvent( QPaintEvent * );
   void resizeEvent( QResizeEvent * );  
   void mousePressEvent( QMouseEvent * );  

public slots:
   void NewFile();
   void OpenFile();
   void CloseFile();
   void MoveFirst();
   void MoveLast();
   void MovePrev();
   void MoveNext();
   void MovePrevF();
   void MoveNextF();

   void EditNew();
   void EditModify();
   void GridSettings();
   
private:
   QPainter* Paint;
   char dateiName[256];
   //FILE* F;
   int DispMode;             // Anzeigemodus
   int CurMon, CurJahr;      // aktueller Monat/Jahr
   double dx,dy;             // Skalierungsfaktoren
   int fMonate, fCurrent;    // Dateieintrge insgesamt, aktueller
   QPixmap WdIco[16];         // Iconzeile Windrichtung
   int NoIconUpdate;         // Iconzeile NICHT updaten
   int BR,BL,BO,BU;          // Rnder des Grid

   int CalcX(int Tag, int Zeit); // x-Position berechnen
   void LoadMon(void);       // Eintrag aus der Datei lesen (abh. von fMonat und fJahr)
   void SaveMon(void);       // Eintrach speichern
   void PaintGrid(void);     // Grid mit Skalen und Nulllinie zeichnen
   void PaintScales(void);   // Skalen links und rechts zeichnen
   void ShowDetails(void);   // detalliertere Informationen zeigen
   void SetButtons(void);    // Toolbar-Buttons freigeben oder sperren (->toplevel.setbuttons)
   void Clear(void);         // Datenarray mit Defaultwerten belegen
   void LoadConfig();        // Konfiguration einlesen
   void SaveConfig();        // Konfiguration speichern
   void UpdateSelection(int);// Selektion (akt. Tag) ndern
   void* tp;
   KConfig *Config;         // Konfigurationsobjekt
};

#endif