/***************************************************************************
                          dlgconvert.cpp  -  description
                             -------------------
    begin                : Fri Jun 2 2000
    copyright            : (C) 2000 by CFJH
    email                : hochwald@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
    kweather - a program for recording weather events
    Copyright (C) 1999 Jrgen Hochwald <hochwald@kde.org>
	
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
			
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
					
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include <stdlib.h>
#include <qlabel.h>
#include <qmessagebox.h>
#include <kfiledialog.h>
#include "dlgconvert.h"
#include "data.h"


ConvertDlg::ConvertDlg(QWidget* parent=0, const char* name=0):
     QDialog (parent, name, WStyle_DialogBorder)
{

   setFixedSize(450,200);
   setCaption(i18n("Convert V0.2 File to new Structure"));
   
   QLabel *OldFileLab = new QLabel(i18n("Old file"), this, "OldFileLab");
   OldFileLab->setGeometry(10,10,80,20);
   OldFileEdit = new QLineEdit(this,"OldFileEdit");
   OldFileEdit->setGeometry(100,10,310,22);
   OldFileBtn = new QPushButton("...", this, "OldFileBtn");
   OldFileBtn->setGeometry(415,10,25,25);
   connect(OldFileBtn, SIGNAL(clicked()), this, SLOT(OldFileBtnClick()));
   QLabel *NewFileLab = new QLabel(i18n("New file"), this, "NewFileLab");
   NewFileLab->setGeometry(10,40,80,20);
   NewFileEdit = new QLineEdit(this,"NewFileEdit");
   NewFileEdit->setGeometry(100,40,310,22);
   NewFileBtn = new QPushButton("...", this, "NewFileBtn");
   NewFileBtn->setGeometry(415,40,25,25);
   connect(NewFileBtn, SIGNAL(clicked()), this, SLOT(NewFileBtnClick()));


   QLabel *GroupLab=new QLabel(i18n("Description"),this);
   GroupLab->setGeometry(10,80,80,20);
   GroupEdit=new QLineEdit(this);
   GroupEdit->setGeometry(100,80,300,22);
   GroupEdit->setMaxLength(29);


   ConvertBtn = new QPushButton(i18n("Convert"), this, "ConvertBtn");
   ConvertBtn->setGeometry(220,160,100,30);
   ConvertBtn->setDefault(TRUE);
   connect(ConvertBtn, SIGNAL(clicked()), SLOT(ConvertBtnClick()));

   CloseBtn = new QPushButton(i18n("Close"), this, "CloseBtn");
   CloseBtn->setGeometry(340,160,100,30);
   connect(CloseBtn, SIGNAL(clicked()), SLOT(reject()));
}

void ConvertDlg::OldFileBtnClick() {
debug("Oldfile");

   QString f = KFileDialog::getOpenFileName(OldFileEdit->text(), "*.fik", this);
   if (!f.isEmpty()) {
      OldFileEdit->setText(f);
   }

}

void ConvertDlg::NewFileBtnClick() {
debug("Newfile");
   QString f = KFileDialog::getOpenFileName(NewFileEdit->text(), "*.kwd", this);
   if (!f.isEmpty()) {
      NewFileEdit->setText(f);
   }
}

void ConvertDlg::ConvertBtnClick() {
DataFile *DF;
FILE* F;
struct MonType M;
int Res,Lauf;
DataArrType DA;
ShortDataType *W;
FloatDataType *MO, *AB, *LD, *P;
LongDataType *WD;
struct GridSettingsType GS;

debug("convert");

   // Orginaldatei nicht vorhanden
   if (!QFile::exists(OldFileEdit->text())) {
      QMessageBox::warning(this,OldFileEdit->text(),i18n("OldFile does not exist"));
      return;
   }
   
   // Orginaldatei nicht lesbar
   F=fopen(OldFileEdit->text(),"rb");
   if (!F) {
      QMessageBox::warning(this,OldFileEdit->text(),i18n("OldFile cannot open"));
      return;
   }

   if (strlen(NewFileEdit->text())==0) {
      QMessageBox::warning(this,i18n("Filename Missing"),i18n("A filename for the new file bust be given."));
      return;
   }

   // GridSettings initialisieren
   memset(&GS, 0, sizeof(GS));
   GS.Grid=12;
   GS.ZeroLine=5;
   GS.ColorFlags=0;

   strcpy(GS.LineUnits,"C");
   GS.LineGrids=5.0;
   GS.LineZero=0.0;
   GS.LineDspLeft=1;  GS.LineDspRight=0;

   strcpy(GS.PrsUnits,"mB");
   GS.PrsGrids=10.0;
   GS.PrsZero=1000.0;
   GS.PrsDspLeft=0;  GS.PrsDspRight=1;

   strcpy(GS.LevelUnits,"cm");
   GS.LevelGrids=100.0;
   GS.LevelZero=0.0;
   GS.LevelDspLeft=0;  GS.LevelDspRight=1;

   strcpy(GS.WindDirUnits,"WR");
   strcpy(GS.WindStrengthUnits,"Bft");

   // ersten Datensatz lesen, um das Anfangsdatum zu erhalten
   Res=fread(&M, sizeof(M),1, F);
   if (Res==0) {  // Fehler bein Lesen des ersten DS
      fclose(F);
      QMessageBox::critical(this,OldFileEdit->text(),i18n("OldFile cannot be read"));
      return;
   }
   fseek(F, 0, SEEK_SET); // wieder an den Dateianfang

   for (Lauf=0; Lauf<MAXDATA; Lauf++)
      DA[Lauf] = NULL;

   // Dataset
   DA[0]=(DataDef*)malloc(sizeof(struct DataDef));
   memset(DA[0], 0, sizeof(struct DataDef));
   strcpy(DA[0]->Name, GroupEdit->text());
   DA[0]->Type=TYP_GROUP;
   strcpy(DA[0]->Einheit, "");
   strcpy(DA[0]->Einheit2, "");
   DA[0]->Farbe=0;
   DA[0]->Scale=0;
   DA[0]->Zero=0;
   DA[0]->Count=1;
   DA[0]->Times[0]=0;
   DA[0]->CalcAvg=FALSE;
   DA[0]->Flags1=0;
   DA[0]->Flags2=0;
   DA[0]->Flags3=0;
   DA[0]->Flags4=0;
   
   // Morgens
   DA[1]=(DataDef*)malloc(sizeof(struct DataDef));
   memset(DA[1], 0, sizeof(struct DataDef));
   strcpy(DA[1]->Name, i18n("Morning"));
   DA[1]->Type=TYP_LINE;
   strcpy(DA[1]->Einheit, "C");
   strcpy(DA[1]->Einheit2, "");
   DA[1]->Farbe=qRgb(255,0,0);
   DA[1]->Scale=5.0;
   DA[1]->Zero=0.0;
   DA[1]->Count=1;
   DA[1]->Times[0]=7*60;
   DA[1]->CalcAvg=TRUE;
   DA[1]->Flags1=0;
   DA[1]->Flags2=0;
   DA[1]->Flags3=0;
   DA[1]->Flags4=0;
   
   // Abends
   DA[2]=(DataDef*)malloc(sizeof(struct DataDef));
   memset(DA[2], 0, sizeof(struct DataDef));
   strcpy(DA[2]->Name, i18n("Evening"));
   DA[2]->Type=TYP_LINE;
   strcpy(DA[2]->Einheit, "C");
   strcpy(DA[2]->Einheit2, "");
   DA[2]->Farbe=qRgb(0,0,255);
   DA[2]->Scale=5.0;
   DA[2]->Zero=0.0;
   DA[2]->Count=1;
   DA[2]->Times[0]=19*60;
   DA[2]->CalcAvg=FALSE;
   DA[2]->Flags1=0;
   DA[2]->Flags2=0;
   DA[2]->Flags3=0;
   DA[2]->Flags4=0;
   
   // Luftdruck
   DA[3]=(DataDef*)malloc(sizeof(struct DataDef));
   memset(DA[3], 0, sizeof(struct DataDef));
   strcpy(DA[3]->Name, i18n("Air Pressure"));
   DA[3]->Type=TYP_PRESSURE;
   strcpy(DA[3]->Einheit, "mB");
   strcpy(DA[3]->Einheit2, "");
   DA[3]->Farbe=qRgb(0,128,0);
   DA[3]->Scale=10.0;
   DA[3]->Zero=1000.0;
   DA[3]->Count=1;
   DA[3]->Times[0]=19*60;
   DA[3]->CalcAvg=FALSE;
   DA[3]->Flags1=0;
   DA[3]->Flags2=0;
   DA[3]->Flags3=0;
   DA[3]->Flags4=0;
   
   // Wetter
   DA[4]=(DataDef*)malloc(sizeof(struct DataDef));
   memset(DA[4], 0, sizeof(struct DataDef));
   strcpy(DA[4]->Name, i18n("Weather"));
   DA[4]->Type=TYP_WEATHER;
   strcpy(DA[4]->Einheit, "");
   strcpy(DA[4]->Einheit2, "");
   DA[4]->Farbe=0;
   DA[4]->Scale=0.0;
   DA[4]->Zero=0.0;
   DA[4]->Count=1;
   DA[4]->Times[0]=19*60;
   DA[4]->CalcAvg=FALSE;
   DA[4]->Flags1=0;
   DA[4]->Flags2=0;
   DA[4]->Flags3=0;
   DA[4]->Flags4=0;
   
   // Pegel
   DA[5]=(DataDef*)malloc(sizeof(struct DataDef));
   memset(DA[5], 0, sizeof(struct DataDef));
   strcpy(DA[5]->Name, i18n("Level"));
   DA[5]->Type=TYP_LEVEL;
   strcpy(DA[5]->Einheit, "cm");
   strcpy(DA[5]->Einheit2, "");
   DA[5]->Farbe=qRgb(0,160,160);
   DA[5]->Scale=50.0;
   DA[5]->Zero=0.0;
   DA[5]->Count=1;
   DA[5]->Times[0]=19*60;
   DA[5]->CalcAvg=FALSE;
   DA[5]->Flags1=0;
   DA[5]->Flags2=0;
   DA[5]->Flags3=0;
   DA[5]->Flags4=0;
   
   // Wind
   DA[6]=(DataDef*)malloc(sizeof(struct DataDef));
   memset(DA[6], 0, sizeof(struct DataDef));
   strcpy(DA[6]->Name, i18n("Wind"));
   DA[6]->Type=TYP_WIND;
   strcpy(DA[6]->Einheit, "WR");
   strcpy(DA[6]->Einheit2, "Bft");
   DA[6]->Farbe=0;
   DA[6]->Scale=0.0;
   DA[6]->Zero=0.0;
   DA[6]->Count=1;
   DA[6]->Times[0]=19*60;
   DA[6]->CalcAvg=FALSE;
   DA[6]->Flags1=0;
   DA[6]->Flags2=0;
   DA[6]->Flags3=0;
   DA[6]->Flags4=0;
   
   
   DF = new DataFile(NewFileEdit->text());
   Res=DF->CreateNewFile(&DA,M.MonName,M.Jahr,&GS);
   Res=DF->Open(&GS);
   debug("Open-Res=%d",Res);

   if (Res==DTA_OK) {  //Datei wurde erfolgreich anjelecht
      do {
         Res=fread(&M, sizeof(M),1, F);
         if (Res>0) {
            for (Lauf=0; Lauf<31; Lauf++) {
               MO=(FloatDataType*)(DF->DPTR[0][1]);
               (*MO)[Lauf] = 0.1*M.Werte[Lauf].M;

       /*        SD=(ShortDataType*)(DF->DPTR[1][1]);
               (*SD)[Lauf] = M.Werte[Lauf].M+10;
               SD=(ShortDataType*)(DF->DPTR[2][1]);
               (*SD)[Lauf] = M.Werte[Lauf].M-10;
               SD=(ShortDataType*)(DF->DPTR[3][1]);
               (*SD)[Lauf] = M.Werte[Lauf].M+20;
        */
               AB=(FloatDataType*)(DF->DPTR[0][2]);
               (*AB)[Lauf] = 0.1*M.Werte[Lauf].A;

               LD=(FloatDataType*)(DF->DPTR[0][3]);
               (*LD)[Lauf] = 1.0*M.Werte[Lauf].L;
//debug("LD=%d",(*LD)[Lauf]);
               W=(ShortDataType*)(DF->DPTR[0][4]);
               (*W)[Lauf] = M.Werte[Lauf].W;

               P=(FloatDataType*)(DF->DPTR[0][5]);
               (*P)[Lauf] = 1.0*M.Werte[Lauf].P;
               
               {
               short int WR,WS;

                  WD=(LongDataType*)(DF->DPTR[0][6]);
                  WR=M.Werte[Lauf].WD & 0x000F;       // Richtung (1..8)
                  if (WR>0) WR--;
                  WR=8-WR;
//debug("WR=%d",WR);
                  WR=(int)(4.0*11.25*10.0*WR);   // Winkel in Grad mit einer NK
                  WS=(M.Werte[Lauf].WD >> 8); // &0x00FF; // Strke (0..12)
                  WS*=10;                             // eine Nachkommastelle
                  // Unteres Word : Richtung, Oberes Wort: Strke
                  (*WD)[Lauf] = WR+(WS<<16);
//debug("Raw=%4X  WR=%d  WS=%0.1f",M.Werte[Lauf].WD,WR,0.1*WS);
               }
            }
//            debug("Res=%2d   Monat %2d   Jahr %d",Res,M.MonName,M.Jahr);

            DF->VDTA[0][1][0]=0xFFFFFFFF; DF->VDTA[0][1][1]=0; DF->VDTA[0][1][2]=0; DF->VDTA[0][1][3]=0; 
            DF->VDTA[0][2][0]=0xFFFFFFFF; DF->VDTA[0][2][1]=0; DF->VDTA[0][2][2]=0; DF->VDTA[0][2][3]=0;
            DF->VDTA[0][3][0]=0xFFFFFFFF; DF->VDTA[0][3][1]=0; DF->VDTA[0][3][2]=0; DF->VDTA[0][3][3]=0;
            DF->VDTA[0][4][0]=0xFFFFFFFF; DF->VDTA[0][4][1]=0; DF->VDTA[0][4][2]=0; DF->VDTA[0][4][3]=0;
            DF->VDTA[0][5][0]=0xFFFFFFFF; DF->VDTA[0][5][1]=0; DF->VDTA[0][5][2]=0; DF->VDTA[0][5][3]=0;
            DF->VDTA[0][6][0]=0xFFFFFFFF; DF->VDTA[0][6][1]=0xFFFFFFFF; DF->VDTA[0][6][2]=0; DF->VDTA[0][6][3]=0;

            DF->Seek(M.MonName,M.Jahr);
            DF->Write();
            debug("LD=%d",M.Werte[0].L);
         }
      } while (!feof(F));
   }
   fclose(F);
   //DF->Seek(M.MonName,M.Jahr);
   //DF->Seek(5,1980);
   /*DF->Seek(0);
   DF->Read();
   MO=(FloatDataType*)(DF->DPTR[0][1]);
   for (Lauf=20; Lauf<31; Lauf++) {
      debug("M%d = %0.1f",Lauf, (*MO)[Lauf]);
   }
   
   // Test
debug("Createnewfile: M=%d  J=%d",M.MonName,M.Jahr);
*/
   DF->Close();
   delete DF;
   accept();
}

