/***************************************************************************
                          dlgdata.h  -  description
                             -------------------
    begin                : Fri Jun 2 2000
    copyright            : (C) 2000 by CFJH
    email                : hochwald@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
    kweather - a program for recording weather events
    Copyright (C) 1999 Jrgen Hochwald <hochwald@kde.org>
	
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
			
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
					
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/    
#ifndef _DLGDATA_H_
#define _DLGDATA_H_


#include <qlabel.h>
#include <ktmainwindow.h>
#include <qpushbutton.h>
#include <qsignalmapper.h>
#include <qgroupbox.h>
#include <qwindow.h>
#include <kapp.h>
#include <kiconloader.h>
#include <ktoolbar.h>
#include <qscrollview.h>
#include "chart.h"
#include "data.h"
#include <qframe.h>

class MyLabel : public QLabel
{
Q_OBJECT
public:
   MyLabel ( const char * text, QWidget * parent=0, const char * name=0, WFlags f=0 );
   //MyLabel(QWidget* parent=0, const char* name=0, WFlags f=0, bool allowLines=TRUE);
  //int MPosX,MPosY;

signals:
  void clicked();

protected:
  virtual void mousePressEvent ( QMouseEvent * );

};

class MyFrame : public QFrame
{
Q_OBJECT
public:
  MyFrame(QWidget* parent=0, const char* name=0, WFlags f=0, bool allowLines=TRUE);
  void setText(char* NewText);
  //int MPosX,MPosY;

signals:
  void clicked();

private slots:
  void LabelClicked();

protected:
  virtual void mousePressEvent ( QMouseEvent * );

private:
  MyLabel* Caption;
};

class DataItem : public QFrame
{
Q_OBJECT
public:
   DataItem(DataFile* DFile, int Nummer, int ILfdNr, void* vDLG, QWidget* parent=0, const char* name=0, WFlags f=0, bool allowLines=TRUE);
   void SetColor(int ColNr);
   int AddItem(void* DLG, int Nr);
   void UpdateData(int Tag);
   int Minimized;     // Minimizedstatus

protected:
   virtual void resizeEvent ( QResizeEvent * );

private:
   MyLabel *NameLab, *DescLab;
   DataFile *DF;
   int Nr;            // Position innerhalb von DF
   int LfdNr;         // Laudende Nummer der Dataitems
   int ItemCount;     // Anzahl der Items in dieser Liste
   QPalette *Pal;     // Farbschema
   MyFrame *HeaderFrame;
   QPushButton* MinimizeBtn;  // Schalter zum Minimieren dieser Zeile
};

class DataDlg : public KTMainWindow
{
Q_OBJECT
public:
   DataDlg(DataFile* DFile, TChart* TC, const char* name=0);
   ~DataDlg(void);
   void Aktualisieren(int Tag);

protected:
   virtual void resizeEvent ( QResizeEvent *e);

private slots:
   void HideDlg();
   void EditModify();
   void MoveFirst();
   void MovePrev();
   void MoveNext();
   void MoveLast();
   void MinimizeBtnPressed(int);
   void DisplayBtnPressed(int Nr);
   void MenueBtnPressed(int Nr);
   void MenuShowAll();
   void MenuHideAll();
   void MenuShowAllExcept();
   void closeEvent ( QCloseEvent * e );
   void MenuLoadDisplayBits();
   void MenuSaveDisplayBits();

public:
  TChart* Chart;
  QSignalMapper* MinimizeMapper;  // Ereigniszuordnung fr die Darst. einer Datenzeile
  QSignalMapper* DisplayMapper;   // Ereigniszuordnung fr die Anzeige im Grid
  QSignalMapper* MenueMapper;     // Ereigniszuordnung fr das Men

private:
   void SetupToolBar();
   void SetVisible(int Nr, int Vis);   // Visible-Status fr Item 'Nr' setzen

   KToolBar *ToolBar;
   QScrollView* ScrollView;
   int DataCount;     // Anzahl der sichtbaren Datenfelder
   DataFile *DF;
   DataItem *(DI[MAXDATA]);  
   int OffsetY;       // Position des ersten Items (Hhe Toolbar)
   int MaxX;          // Lngster Eintrag in X-Richtung
   QPopupMenu *Popup;
   int MnuItemNr;     // Itemnummer, bergabeparameter fr Popup-Menaufruf->Auswertung
};

#endif
