/***************************************************************************
                          dlgnew.h  -  description
                             -------------------
    begin                : Fri Jun 2 2000
    copyright            : (C) 2000 by CFJH
    email                : hochwald@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
    kweather - a program for recording weather events
    Copyright (C) 1999 Jrgen Hochwald <hochwald@kde.org>
	
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
			
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
					
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/    
#ifndef _DLGNEW_H_
#define _DLGNEW_H_

#include <stdlib.h>
#include <qlineedit.h>
#include <qcombobox.h>
#include <qgroupbox.h>
#include <qcombobox.h>
#include <qcheckbox.h>
#include <qsignalmapper.h>
#include <kspinbox.h>
#include <kapp.h>
#include <kfiledialog.h>
#include <kiconloader.h>
#include <ktreelist.h>
#include <kiconloader.h>
#include <kspinbox.h>
#include <kslider.h>
#include <krestrictedline.h>
#include <ktabctl.h>
#include <qlistview.h>
#include "data.h"
#include "chart.h"

class NewDlg : public QDialog
{
Q_OBJECT
public:
   NewDlg(QWidget* parent=0, const char* name=0);
   QLineEdit *DateiEdit;
   QComboBox *MonatCombo;
   KNumericSpinBox *JahrSpin;
   
signals:

private slots:
   void SuchenBtnClick();
   void AddGrpBtnClick();
   void AddItemBtnClick();
   void DeleteBtnClick();
   void ApplyBtnClick();
   void ReadStructureBtnClick();
   void ListSelectionChanged(QListViewItem *);
   void ColorBtnClick();
   void OkBtnClick();
   void CancelBtnClick();
   void TimeBtnClick(int);
   void CountSpinChange();
   void TypComboChange(int);
   void EinheitComboChange(const char *c);

private:
   void Initialisize(DataPtr DP, int Type, int FullInit=TRUE);// Eintrag initialisieren, abhng. vom Typ
   void Refresh(DataPtr DP);     // Werte aus dem Eintrag Pos anzeigen (Eingabefelder)
   void ShowFields(int Type);    // Eingabefelder anhngig von Typ sichtar setzen
   void Update(DataPtr DP);      // Werte aus den Eingabefeldern ins Array bernehmen
   void ShowTimeButtons(int Cnt);// Timebuttons aktualisieren
   void DeleteEntry(QListViewItem *QL); // Eintrag + Datenblock lschen
   void SetUnits(int Type);       // Einheiten in der Einheitencombo abh. vom Typ setzen
   DataPtr AddGrp(char* Caption);
   DataPtr AddItem(char* Caption, int Type = TYP_LINE);

   QWidget *DataGrp, *FileGrp;
   KTabCtl *TabCtl;
   QPushButton *OkBtn, *CancelBtn;
   QPushButton *AddGrpBtn, *AddItemBtn, *DeleteBtn, *ApplyBtn, *ColorBtn, *ReadStructureBtn;
   QListView *Lst;
   QLineEdit *NameEdit, *DescEdit;
   KRestrictedLine *XEdit, *YEdit, *ScaleEdit, *ZeroEdit;
   QComboBox *TypCombo, *EinheitCombo, *Einheit2Combo;
   QLabel *TypLab, *EinheitLab, *ColorLab, *XLab, *YLab, *ScaleLab, *ZeroLab,
          *StrLenLab, *Einheit2Lab;
   QWidget *ColorRect;
   QLabel* CountLab, *TimeLab;
   KNumericSpinBox *CountSpin, *StrLenSpin;
   QPushButton* ZeitenBtn[MAXCOUNT];
   QCheckBox *AvgCheck, *OwnScaleChk;
   DataPtr CurrItem;
   
   short Zeiten[MAXCOUNT];
   
   QPixmap IconArr[TYP_DIV+1];
   QSignalMapper *SigMap;
   TChart* Chart;
};

class TimeSetDlg : public QDialog
{
Q_OBJECT
public:
   TimeSetDlg(QWidget* parent=0, const char* name=0);
   void SetTime(int T);
   int GetTime(void);
   
signals:

private slots:
   void TimeSliderValueChange(int);
   void HIncBtnClick();
   void MIncBtnClick();
   void HDecBtnClick();
   void MDecBtnClick();

private:
   void ShowTime(void);

   short CurrTime;
   QPushButton *OkBtn, *CancelBtn;
   QPushButton *HIncBtn, *HDecBtn, *MIncBtn, *MDecBtn;
   KSlider* TimeSlider;
   QLabel* TimeLab;
   int SliderBypass;   // Ignorieren des Slider.valueChanged(), 
                       // wenn nderung ber Slider.setValue()
};


#endif
