/***************************************************************************
                          dlgpredefined.cpp  -  description
                             -------------------
    begin                : Thu Jun 15 2000
    copyright            : (C) 2000 by CFJH
    email                : hochwald@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <stdlib.h>
#include <kapp.h>
#include <qdatetime.h>
#include "dlgpredefined.h"
#include "data.h"
#include "globals.h"
#include "dlgnew.h"

// extern TChart * Chart;
extern char* MonName[];
extern struct GridSettingsType GridDefaults;

char T[10];

PredefinedDlg::PredefinedDlg(QWidget *parent, const char *name) : QDialog(parent,name,true){
int Lauf;
QDate date;

  setCaption(i18n("Create new File from Template"));
  Chart = (TChart*)parent;
	initDialog();
  TabCtl = new KTabCtl(this, "TabCtl");
  TabCtl->setGeometry(0,0, 450,200);
  TabCtl->addTab(TempGrp,i18n("Temp"));
  TabCtl->addTab(PrsGrp,i18n("Prs"));
  TabCtl->addTab(WeatherGrp,i18n("Weather"));
  TabCtl->addTab(LevelGrp,i18n("Level"));
  TabCtl->addTab(WindGrp,i18n("Wind"));

  SigMap = new QSignalMapper(this,"SigMap");
  connect(SigMap, SIGNAL(mapped(int)), this, SLOT(CBtnPressed(int)));
  SigMap->setMapping(T1Btn, 1);  // Temp 1
  SigMap->setMapping(T2Btn, 2);  // Temp 2
  SigMap->setMapping(T3Btn, 3);  // Pressure 1
  SigMap->setMapping(T4Btn, 4);  // Pressure 2
  SigMap->setMapping(T5Btn, 5);  // Weather 1
  SigMap->setMapping(T6Btn, 6);  // Weather 2
  SigMap->setMapping(T7Btn, 7);  // Level 1
  SigMap->setMapping(T8Btn, 8);  // Level 2
  SigMap->setMapping(T9Btn, 9);  // Wind 1
  SigMap->setMapping(T10Btn,10); // Wind 2

  for (Lauf=0; Lauf<12; Lauf++)
    MonatCmb->insertItem(i18n(MonName[Lauf]));

  // Colorbuttons initialisieren
  C1Btn->setColor(QColor(255,0,0));  // Temp1
  C2Btn->setColor(QColor(0,0,255));  // Temp2
  C3Btn->setColor(QColor(0,255,0));  // Prs1
  C4Btn->setColor(QColor(0,128,0));  // Prs2
  C7Btn->setColor(QColor(0,255,255));  // Level1
  C8Btn->setColor(QColor(0,128,128));  // Level2

  // ZeitenArray initialisieren
  for (Lauf=0; Lauf<10; Lauf++) {
    if (Lauf%2)
      TimesArr[Lauf]=1080;
    else
      TimesArr[Lauf]=360;
  }

  // Einheitencombos initialisieren
  for(Lauf=0; Lauf<CNT_TEMPUNITS; Lauf++) {
    U1Cmb->insertItem(TempUnits[Lauf]);
    U2Cmb->insertItem(TempUnits[Lauf]);
  }
  for(Lauf=0; Lauf<CNT_PRSUNITS; Lauf++) {
    U3Cmb->insertItem(PrsUnits[Lauf]);
    U4Cmb->insertItem(PrsUnits[Lauf]);
  }
  for(Lauf=0; Lauf<CNT_LEVELUNITS; Lauf++) {
    U7Cmb->insertItem(LevelUnits[Lauf]);
    U8Cmb->insertItem(LevelUnits[Lauf]);
  }
  for(Lauf=0; Lauf<CNT_WINDDIRUNITS; Lauf++) {
    U91Cmb->insertItem(WindDirUnits[Lauf]);
    U101Cmb->insertItem(WindDirUnits[Lauf]);
  }
  for(Lauf=0; Lauf<CNT_WINDSTRENGTHUNITS; Lauf++) {
    U92Cmb->insertItem(WindStrengthUnits[Lauf]);
    U102Cmb->insertItem(WindStrengthUnits[Lauf]);
  }

  // aktuelles Datum setzen
  date = QDate::currentDate();
  MonatCmb->setCurrentItem(date.month()-1);
  JahrSpin->setValue(date.year());

  connect(CloseBtn,SIGNAL(clicked()),SLOT(reject()));
  connect(CreateBtn,SIGNAL(clicked()),SLOT(CreateBtnClick()));
  connect(T1Btn, SIGNAL(clicked()), SigMap, SLOT(map()));
  connect(T2Btn, SIGNAL(clicked()), SigMap, SLOT(map()));
  connect(T3Btn, SIGNAL(clicked()), SigMap, SLOT(map()));
  connect(T4Btn, SIGNAL(clicked()), SigMap, SLOT(map()));
  connect(T5Btn, SIGNAL(clicked()), SigMap, SLOT(map()));
  connect(T6Btn, SIGNAL(clicked()), SigMap, SLOT(map()));
  connect(T7Btn, SIGNAL(clicked()), SigMap, SLOT(map()));
  connect(T8Btn, SIGNAL(clicked()), SigMap, SLOT(map()));
  connect(T9Btn, SIGNAL(clicked()), SigMap, SLOT(map()));
  connect(T10Btn,SIGNAL(clicked()), SigMap, SLOT(map()));
}

PredefinedDlg::~PredefinedDlg(){
}

void PredefinedDlg::CreateBtnClick() {
DataFile *DF;
DataArrType DA;
int Res, Lauf, Nr;
QColor C;

debug("CreateBtnClick");
  if (strlen(FileNameEdit->text())==0) {
    QMessageBox::warning ( NULL,   i18n("Missing Data"), i18n("Filename must be given"),
             i18n("Yes"), 0, 0,
             0, -1 );
    return;
  }
  for (Lauf=0; Lauf<MAXDATA; Lauf++)
    DA[Lauf] = NULL;

  // Kopfdatensatz
  DA[0]=(DataDef*)malloc(sizeof(struct DataDef));
  memset(DA[0], 0, sizeof(struct DataDef));

  strcpy(DA[0]->Name, StationNameEdit->text());
  DA[0]->Type=TYP_GROUP;
  strcpy(DA[0]->Einheit, "");
  strcpy(DA[0]->Einheit2, "");
  DA[0]->Farbe=0;
  DA[0]->Scale=0;
  DA[0]->Zero=0;
  DA[0]->Count=1;
  DA[0]->Times[0]=0;
  DA[0]->CalcAvg=FALSE;
  DA[0]->Flags1=0;
  DA[0]->Flags2=0;
  DA[0]->Flags3=0;
  DA[0]->Flags4=0;

  Nr=1;
  if (Temp1Chk->isChecked()) {
    debug("Temp1");
    DA[Nr]=(DataDef*)malloc(sizeof(struct DataDef));
    memset(DA[Nr], 0, sizeof(struct DataDef));

    strcpy(DA[Nr]->Name, N1Edit->text());
    DA[Nr]->Type=TYP_LINE;
    strcpy(DA[Nr]->Einheit, U1Cmb->currentText());
    strcpy(DA[Nr]->Einheit2, "");
    C = C1Btn->color();
    DA[Nr]->Farbe=qRgb(C.red(), C.green(), C.blue());
    DA[Nr]->Scale=GridDefaults.LineGrids;
    DA[Nr]->Zero=GridDefaults.LineZero;
    DA[Nr]->Count=1;
    DA[Nr]->Times[0]=TimesArr[0];
    DA[Nr]->CalcAvg=FALSE;
    DA[Nr]->Flags1=0;
    DA[Nr]->Flags2=0;
    DA[Nr]->Flags3=0;
    DA[Nr]->Flags4=0;
    Nr++;
  }
  if (Temp2Chk->isChecked()) {
    debug("Temp2");
    DA[Nr]=(DataDef*)malloc(sizeof(struct DataDef));
    memset(DA[Nr], 0, sizeof(struct DataDef));

    strcpy(DA[Nr]->Name, N2Edit->text());
    DA[Nr]->Type=TYP_LINE;
    strcpy(DA[Nr]->Einheit, U2Cmb->currentText());
    strcpy(DA[Nr]->Einheit2, "");
    C = C2Btn->color();
    DA[Nr]->Farbe=qRgb(C.red(), C.green(), C.blue());
    DA[Nr]->Scale=GridDefaults.LineGrids;
    DA[Nr]->Zero=GridDefaults.LineZero;
    DA[Nr]->Count=1;
    DA[Nr]->Times[0]=TimesArr[1];
    DA[Nr]->CalcAvg=FALSE;
    DA[Nr]->Flags1=0;
    DA[Nr]->Flags2=0;
    DA[Nr]->Flags3=0;
    DA[Nr]->Flags4=0;
    Nr++;
  }
  if (Prs1Chk->isChecked()) {
    debug("Pressure1");
    DA[Nr]=(DataDef*)malloc(sizeof(struct DataDef));
    memset(DA[Nr], 0, sizeof(struct DataDef));

    strcpy(DA[Nr]->Name, N3Edit->text());
    DA[Nr]->Type=TYP_PRESSURE;
    strcpy(DA[Nr]->Einheit, U3Cmb->currentText());
    strcpy(DA[Nr]->Einheit2, "");
    C = C3Btn->color();
    DA[Nr]->Farbe=qRgb(C.red(), C.green(), C.blue());
    DA[Nr]->Scale=GridDefaults.PrsGrids;
    DA[Nr]->Zero=GridDefaults.PrsZero;
    DA[Nr]->Count=1;
    DA[Nr]->Times[0]=TimesArr[2];
    DA[Nr]->CalcAvg=FALSE;
    DA[Nr]->Flags1=0;
    DA[Nr]->Flags2=0;
    DA[Nr]->Flags3=0;
    DA[Nr]->Flags4=0;
    Nr++;
  }
  if (Prs2Chk->isChecked()) {
    debug("Pressure2");
    DA[Nr]=(DataDef*)malloc(sizeof(struct DataDef));
    memset(DA[Nr], 0, sizeof(struct DataDef));

    strcpy(DA[Nr]->Name, N4Edit->text());
    DA[Nr]->Type=TYP_PRESSURE;
    strcpy(DA[Nr]->Einheit, U4Cmb->currentText());
    strcpy(DA[Nr]->Einheit2, "");
    C = C4Btn->color();
    DA[Nr]->Farbe=qRgb(C.red(), C.green(), C.blue());
    DA[Nr]->Scale=GridDefaults.PrsGrids;
    DA[Nr]->Zero=GridDefaults.PrsZero;
    DA[Nr]->Count=1;
    DA[Nr]->Times[0]=TimesArr[3];
    DA[Nr]->CalcAvg=FALSE;
    DA[Nr]->Flags1=0;
    DA[Nr]->Flags2=0;
    DA[Nr]->Flags3=0;
    DA[Nr]->Flags4=0;
    Nr++;
  }
  if (Weather1Chk->isChecked()) {
    debug("Weather1");
    DA[Nr]=(DataDef*)malloc(sizeof(struct DataDef));
    memset(DA[Nr], 0, sizeof(struct DataDef));

    strcpy(DA[Nr]->Name, N5Edit->text());
    DA[Nr]->Type=TYP_WEATHER;
    strcpy(DA[Nr]->Einheit, "");
    strcpy(DA[Nr]->Einheit2, "");
    DA[Nr]->Farbe=0;
    DA[Nr]->Scale=1;
    DA[Nr]->Zero=0;
    DA[Nr]->Count=1;
    DA[Nr]->Times[0]=TimesArr[4];
    DA[Nr]->CalcAvg=FALSE;
    DA[Nr]->Flags1=0;
    DA[Nr]->Flags2=0;
    DA[Nr]->Flags3=0;
    DA[Nr]->Flags4=0;
    Nr++;
  }
  if (Weather2Chk->isChecked()) {
    debug("Weather2");
    DA[Nr]=(DataDef*)malloc(sizeof(struct DataDef));
    memset(DA[Nr], 0, sizeof(struct DataDef));

    strcpy(DA[Nr]->Name, N6Edit->text());
    DA[Nr]->Type=TYP_WEATHER;
    strcpy(DA[Nr]->Einheit, "");
    strcpy(DA[Nr]->Einheit2, "");
    DA[Nr]->Farbe=0;
    DA[Nr]->Scale=1;
    DA[Nr]->Zero=0;
    DA[Nr]->Count=1;
    DA[Nr]->Times[0]=TimesArr[5];
    DA[Nr]->CalcAvg=FALSE;
    DA[Nr]->Flags1=0;
    DA[Nr]->Flags2=0;
    DA[Nr]->Flags3=0;
    DA[Nr]->Flags4=0;
    Nr++;
  }
  if (Level1Chk->isChecked()) {
    debug("Level1");
    DA[Nr]=(DataDef*)malloc(sizeof(struct DataDef));
    memset(DA[Nr], 0, sizeof(struct DataDef));

    strcpy(DA[Nr]->Name, N7Edit->text());
    DA[Nr]->Type=TYP_LEVEL;
    strcpy(DA[Nr]->Einheit, U7Cmb->currentText());
    strcpy(DA[Nr]->Einheit2, "");
    C = C7Btn->color();
    DA[Nr]->Farbe=qRgb(C.red(), C.green(), C.blue());
    DA[Nr]->Scale=GridDefaults.LevelGrids;
    DA[Nr]->Zero=GridDefaults.LevelZero;
    DA[Nr]->Count=1;
    DA[Nr]->Times[0]=TimesArr[6];
    DA[Nr]->CalcAvg=FALSE;
    DA[Nr]->Flags1=0;
    DA[Nr]->Flags2=0;
    DA[Nr]->Flags3=0;
    DA[Nr]->Flags4=0;
    Nr++;
  }
  if (Level2Chk->isChecked()) {
    debug("Level2");
    DA[Nr]=(DataDef*)malloc(sizeof(struct DataDef));
    memset(DA[Nr], 0, sizeof(struct DataDef));

    strcpy(DA[Nr]->Name, N8Edit->text());
    DA[Nr]->Type=TYP_LEVEL;
    strcpy(DA[Nr]->Einheit, U8Cmb->currentText());
    strcpy(DA[Nr]->Einheit2, "");
    C = C8Btn->color();
    DA[Nr]->Farbe=qRgb(C.red(), C.green(), C.blue());
    DA[Nr]->Scale=GridDefaults.LevelGrids;
    DA[Nr]->Zero=GridDefaults.LevelZero;
    DA[Nr]->Count=1;
    DA[Nr]->Times[0]=TimesArr[7];
    DA[Nr]->CalcAvg=FALSE;
    DA[Nr]->Flags1=0;
    DA[Nr]->Flags2=0;
    DA[Nr]->Flags3=0;
    DA[Nr]->Flags4=0;
    Nr++;
  }
  if (Wind1Chk->isChecked()) {
    debug("Wind1");
    DA[Nr]=(DataDef*)malloc(sizeof(struct DataDef));
    memset(DA[Nr], 0, sizeof(struct DataDef));

    strcpy(DA[Nr]->Name, N9Edit->text());
    DA[Nr]->Type=TYP_WIND;
    strcpy(DA[Nr]->Einheit, U91Cmb->currentText());
    strcpy(DA[Nr]->Einheit2, U92Cmb->currentText());
    DA[Nr]->Farbe=0;
    DA[Nr]->Scale=1;
    DA[Nr]->Zero=0;
    DA[Nr]->Count=1;
    DA[Nr]->Times[0]=TimesArr[8];
    DA[Nr]->CalcAvg=FALSE;
    DA[Nr]->Flags1=0;
    DA[Nr]->Flags2=0;
    DA[Nr]->Flags3=0;
    DA[Nr]->Flags4=0;
    Nr++;
  }
  if (Wind2Chk->isChecked()) {
    debug("Wind2");
    DA[Nr]=(DataDef*)malloc(sizeof(struct DataDef));
    memset(DA[Nr], 0, sizeof(struct DataDef));

    strcpy(DA[Nr]->Name, N10Edit->text());
    DA[Nr]->Type=TYP_WIND;
    strcpy(DA[Nr]->Einheit, U101Cmb->currentText());
    strcpy(DA[Nr]->Einheit2, U102Cmb->currentText());
    DA[Nr]->Farbe=0;
    DA[Nr]->Scale=1;
    DA[Nr]->Zero=0;
    DA[Nr]->Count=1;
    DA[Nr]->Times[0]=TimesArr[9];
    DA[Nr]->CalcAvg=FALSE;
    DA[Nr]->Flags1=0;
    DA[Nr]->Flags2=0;
    DA[Nr]->Flags3=0;
    DA[Nr]->Flags4=0;
    Nr++;
  }

/*  // Morgens
  DA[1]=(DataDef*)malloc(sizeof(struct DataDef));
  strcpy(DA[1]->Name, i18n("Morning"));
  DA[1]->Type=TYP_LINE;
  strcpy(DA[1]->Einheit, "C");
  strcpy(DA[1]->Einheit2, "");
  DA[1]->Farbe=qRgb(255,0,0);
  DA[1]->Scale=50;
  DA[1]->Zero=0;
  DA[1]->Count=1;
  DA[1]->Times[0]=7*60;
  DA[1]->CalcAvg=TRUE;
  DA[1]->Flags1=0;
  DA[1]->Flags2=0;
  DA[1]->Flags3=0;
  DA[1]->Flags4=0;
*/

  DF = new DataFile(FileNameEdit->text());
  Res=DF->CreateNewFile(&DA,MonatCmb->currentItem()+1,JahrSpin->value(), &GridDefaults);
  debug("Open-Res=%d",Res);
  if (Res)
    this->accept();  // Dialog schlieen, wenn Datei angelegt
  delete DF;
}

void PredefinedDlg::CBtnPressed(int Btn) {
TimeSetDlg * tdlg;
QPushButton * B;

  switch (Btn) {
    case 1:  B=T1Btn;break;
    case 2:  B=T2Btn;break;
    case 3:  B=T3Btn;break;
    case 4:  B=T4Btn;break;
    case 5:  B=T5Btn;break;
    case 6:  B=T6Btn;break;
    case 7:  B=T7Btn;break;
    case 8:  B=T8Btn;break;
    case 9:  B=T9Btn;break;
    case 10: B=T10Btn;break;
    default: B=NULL;
  }

  if (B==NULL) return;

  tdlg = new TimeSetDlg(this, i18n("Enter Time"));
  debug("Btn=%d",Btn);
  tdlg->SetTime(TimesArr[Btn-1]);
  if (tdlg->exec()) {
    TimesArr[Btn-1]=tdlg->GetTime();
    UpdateTimeButtons();
  }
  delete tdlg;
  tdlg=NULL;

}

char* PredefinedDlg::TimeToStr(int Time) {
  sprintf(T, "%02d:%02d", Time/60, Time%60);
  return T;
}

void PredefinedDlg::UpdateTimeButtons() {
  debug("T=%s",TimeToStr(1440));
  T1Btn->setText(TimeToStr(TimesArr[0]));
  T2Btn->setText(TimeToStr(TimesArr[1]));
  T3Btn->setText(TimeToStr(TimesArr[2]));
  T4Btn->setText(TimeToStr(TimesArr[3]));
  T5Btn->setText(TimeToStr(TimesArr[4]));
  T6Btn->setText(TimeToStr(TimesArr[5]));
  T7Btn->setText(TimeToStr(TimesArr[6]));
  T8Btn->setText(TimeToStr(TimesArr[7]));
  T9Btn->setText(TimeToStr(TimesArr[8]));
  T10Btn->setText(TimeToStr(TimesArr[9]));
}
