/***************************************************************************
                          dlgw.cpp  -  description
                             -------------------
    begin                : Fri Jun 2 2000
    copyright            : (C) 2000 by CFJH
    email                : hochwald@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
    kweather - a program for recording weather events
    Copyright (C) 1999 Jrgen Hochwald <hochwald@kde.org>
	
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
			
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
					
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/    
#include "dlgw.h"

WeatherDlg::WeatherDlg(int Wt, QWidget* parent=0, const char* name=0):
     QDialog (parent, name, WStyle_DialogBorder)
{
int x,y;
char Name[10];
int MapArr[ArrY][ArrX] =
{ {  1,   4,   3,   5},
  { 68,  69,  66,  67},
  { 20,  28,  21,  29},
  { 19,  27,  83,  91},
  { 84,  92,  85,  93},
  { 52,  60,  53,  61},
  {129, 131, 179,  12}
};


   setFixedSize(430,400);
   setCaption(i18n("Select Icon"));
//   W = Chart->monat.Werte[Chart->DispTag].W;
W=Wt;
   SigMap = new QSignalMapper(this,"SigMap");
   connect(SigMap, SIGNAL(mapped(int)), this, SLOT(BtnPressed(int)));
   
   WetterLab = new QLabel("", this, "WetterLab");
   WetterLab->setGeometry(10,10,32,32);
   WetterLab->setPixmap(CalcWetterImage(W));
   ValLab=new QLabel("", this, "ValLab");
   ValLab->setGeometry(10,50,32,12);
   ValLab->setAlignment(AlignHCenter);
   sprintf(Name,"%d",W);
   ValLab->setText(Name);

   CreateGrp = new QGroupBox(i18n("Create Icon"), this, "CreateGrp");
   CreateGrp->setGeometry(80,20,160,265);
   SelGrp = new QGroupBox(i18n("Select Icon"), this, "SelGrp");
   SelGrp->setGeometry(250,20,160,35*ArrY+40);
   // Sonne
   S1Btn = new QPushButton(CreateGrp, "S1Btn");
   S1Btn->setGeometry(10,20,35,35);
   S1Btn->setPixmap(CalcWetterImage(0));
   connect(S1Btn, SIGNAL(clicked()), SigMap, SLOT(map()));
   S2Btn = new QPushButton(CreateGrp, "S2Btn");
   S2Btn->setGeometry(45,20,35,35);
   S2Btn->setPixmap(CalcWetterImage(1));
   connect(S2Btn, SIGNAL(clicked()), SigMap, SLOT(map()));
   
   // Wolken
   W1Btn = new QPushButton(CreateGrp, "W1Btn");
   W1Btn->setGeometry(10,60,35,35);
   W1Btn->setPixmap(CalcWetterImage(0));
   connect(W1Btn, SIGNAL(clicked()), SigMap, SLOT(map()));
   W2Btn = new QPushButton(CreateGrp, "W1Btn");
   W2Btn->setGeometry(45,60,35,35);
   W2Btn->setPixmap(CalcWetterImage(2));
   connect(W2Btn, SIGNAL(clicked()), SigMap, SLOT(map()));
   W3Btn = new QPushButton(CreateGrp, "W1Btn");
   W3Btn->setGeometry(80,60,35,35);
   W3Btn->setPixmap(CalcWetterImage(4));
   connect(W3Btn, SIGNAL(clicked()), SigMap, SLOT(map()));

   // Gewitter
   G1Btn = new QPushButton(CreateGrp, "G1Btn");
   G1Btn->setGeometry(10,100,35,35);
   G1Btn->setPixmap(CalcWetterImage(4));
   connect(G1Btn, SIGNAL(clicked()), SigMap, SLOT(map()));
   G2Btn = new QPushButton(CreateGrp, "G2Btn");
   G2Btn->setGeometry(45,100,35,35);
   G2Btn->setPixmap(CalcWetterImage(68));
   connect(G2Btn, SIGNAL(clicked()), SigMap, SLOT(map()));

   // Regen
   R1Btn = new QPushButton(CreateGrp, "R1Btn");
   R1Btn->setGeometry(10,140,35,35);
   R1Btn->setPixmap(CalcWetterImage(0));
   connect(R1Btn, SIGNAL(clicked()), SigMap, SLOT(map()));
   R2Btn = new QPushButton(CreateGrp, "R2Btn");
   R2Btn->setGeometry(45,140,35,35);
   R2Btn->setPixmap(CalcWetterImage(8));
   connect(R2Btn, SIGNAL(clicked()), SigMap, SLOT(map()));
   R3Btn = new QPushButton(CreateGrp, "R3Btn");
   R3Btn->setGeometry(80,140,35,35);
   R3Btn->setPixmap(CalcWetterImage(16));
   connect(R3Btn, SIGNAL(clicked()), SigMap, SLOT(map()));
   R4Btn = new QPushButton(CreateGrp, "R4Btn");
   R4Btn->setGeometry(115,140,35,35);
   R4Btn->setPixmap(CalcWetterImage(24));
   connect(R4Btn, SIGNAL(clicked()), SigMap, SLOT(map()));

   // Schnee
   Sn1Btn = new QPushButton(CreateGrp, "Sn1Btn");
   Sn1Btn->setGeometry(10,180,35,35);
   Sn1Btn->setPixmap(CalcWetterImage(24));
   connect(Sn1Btn, SIGNAL(clicked()), SigMap, SLOT(map()));
   Sn2Btn = new QPushButton(CreateGrp, "Sn2Btn");
   Sn2Btn->setGeometry(45,180,35,35);
   Sn2Btn->setPixmap(CalcWetterImage(56));
   connect(Sn2Btn, SIGNAL(clicked()), SigMap, SLOT(map()));

   // Nebel
   N1Btn = new QPushButton(CreateGrp, "N1Btn");
   N1Btn->setGeometry(10,220,35,35);
   N1Btn->setPixmap(CalcWetterImage(0));
   connect(N1Btn, SIGNAL(clicked()), SigMap, SLOT(map()));
   N2Btn = new QPushButton(CreateGrp, "N2Btn");
   N2Btn->setGeometry(45,220,35,35);
   N2Btn->setPixmap(CalcWetterImage(128));
   connect(N2Btn, SIGNAL(clicked()), SigMap, SLOT(map()));

   // Vordefinierte Buttons
   for (x=0; x<ArrX; x++)
   for (y=0; y<ArrY; y++) {
      sprintf(Name,"A%02d%02d",x,y);
      //debug(Name);
      A[x][y] = new QPushButton(SelGrp, Name);
      A[x][y]->setGeometry(35*x+10, 35*y+20, 35, 35);
      A[x][y]->setPixmap(CalcWetterImage(MapArr[y][x]));
      connect(A[x][y], SIGNAL(clicked()), SigMap, SLOT(map()));
      SigMap->setMapping(A[x][y], MapArr[y][x]|0x4000);
   }
   
   SigMap->setMapping(S1Btn, 0x8001);  // keine Sonne
   SigMap->setMapping(S2Btn, 0x0001);  // Sonne
   SigMap->setMapping(W1Btn, 0x8002);  // keine Wolken
   SigMap->setMapping(W2Btn, 0x0002);  // kleine Wolken
   SigMap->setMapping(W3Btn, 0x0004);  // groe Wolken
   SigMap->setMapping(G1Btn, 0x8040);  // kein Gewitter
   SigMap->setMapping(G2Btn, 0x0040);  // Gewitter
   SigMap->setMapping(R1Btn, 0x8008);  // kein Regen
   SigMap->setMapping(R2Btn, 0x0008);  // Sprhregen
   SigMap->setMapping(R3Btn, 0x0010);  // wenig Regen
   SigMap->setMapping(R4Btn, 0x0018);  // viel Regen
   SigMap->setMapping(Sn1Btn,0x8020);  // Regen
   SigMap->setMapping(Sn2Btn,0x0020);  // Schnee
   SigMap->setMapping(N1Btn, 0x8080);  // kein Nebel
   SigMap->setMapping(N2Btn, 0x0080);  // Nebel

   OkBtn = new QPushButton(i18n("Ok"), this, "OkBtn");
   OkBtn->setGeometry(20,height()-50,80,30);
   OkBtn->setDefault(TRUE);
   connect(OkBtn, SIGNAL(clicked()), SLOT(accept()));

   CancelBtn = new QPushButton(i18n("Cancel"), this, "CancelBtn");
   CancelBtn->setGeometry(200,height()-50,80,30);
   connect(CancelBtn, SIGNAL(clicked()), SLOT(reject()));
}

void WeatherDlg::BtnPressed(int Mask) {
char Val[10];
//debug("ButtonPressed, Mask=%X",Mask);
   if (Mask & 0x4000) {  // Icon direkt setzen
      W = Mask & 0x00FF;
   } else
   if (Mask & 0x8000) {  // ausblenden
      if (Mask & 0x0001)
         W &= 0xFFFE;   else
      if (Mask & 0x0002)
         W &= 0xFFF9;   else
      if (Mask & 0x0040)
         W &= 0xFFBF;   else
      if (Mask & 0x0008)
         W &= 0xFFE7;   else
      if (Mask & 0x0020)
         W &= 0xFFDF;   else
      if (Mask & 0x0080)
         W &= 0xFF7F;
  } else {  // einblenden
      if (Mask & 0x0001)
         W |= 0x0001;   else
      if (Mask & 0x0006) {
         W &= 0xFFF9;
         W |= Mask;
      }  else
      if (Mask & 0x0040)
         W |= 0x0040;   else
      if (Mask & 0x0018) {
         W &= 0xFFE7;
         W |= Mask;
      } else
      if (Mask & 0x0020)
         W |= 0x0020;   else
      if (Mask & 0x0080)
         W |= 0x0080;
   }
   WetterLab->setPixmap(CalcWetterImage(W));
   sprintf(Val,"%d",W);
   ValLab->setText(Val);
}
