//
//
//	Modified for Kwebcam by Troy Ogden <badger@bookshelves.net> NOV 5, 1999
//	
//
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <fcntl.h>
#include <sys/time.h>
#include <sys/mman.h>
#include <sys/ioctl.h>

#include <asm/types.h>
#include "videodev.h"	/* change this to "videodev2.h" for v4l2 */

#include "jpeglib.h"

// configuration                                                          


#ifdef VIDIOCGCAP
/* these work for v4l only, not v4l2 */
# define GRAB_SOURCE      1
# define GRAB_NORM        VIDEO_MODE_NTSC	/* maybe _PAL or _SECAM */
#endif

#define JPEG_FILE         "/tmp/webcam.jpeg"
#define JPEG_QUALITY      75

#define GRAB_DEVICE       "/dev/video0"
#define GRAB_WIDTH        320
#define GRAB_HEIGHT       240
#define GRAB_TEXT         "webcam %d.%m.%Y %H:%M:%S"        /* strftime */


void swap_rgb24(char *mem, int n);
/* ------------------------ jpeg stuff--------------- */
/* ------------- can this be done in c++ ?? ----------*/
int
write_jpeg(char *filename, char *data, int width, int height)
{
    struct jpeg_compress_struct cinfo;
    struct jpeg_error_mgr jerr;
    FILE *fp;
    int i;
    unsigned char *line;

    if (NULL == (fp = fopen(filename,"w"))) {
	fprintf(stderr,"can't open %s for writing: %s\n",
		filename,strerror(errno));
	return -1;
    }

    cinfo.err = jpeg_std_error(&jerr);
    jpeg_create_compress(&cinfo);
    jpeg_stdio_dest(&cinfo, fp);
    cinfo.image_width = width;
    cinfo.image_height = height;
    cinfo.input_components = 3;
    cinfo.in_color_space = JCS_RGB;
    jpeg_set_defaults(&cinfo);
    jpeg_set_quality(&cinfo, JPEG_QUALITY, TRUE);
    jpeg_start_compress(&cinfo, TRUE);

    for (i = 0, line = data; i < height; i++, line += width*3)
	jpeg_write_scanlines(&cinfo, &line, 1);
    
    jpeg_finish_compress(&(cinfo));
    jpeg_destroy_compress(&(cinfo));
    fclose(fp);

    return 0;
}

// ---------------------------------------------------------------------- */
/* capture stuff  - v4l2                                                  */

#ifdef VIDIOC_QUERYCAP

static struct v4l2_capability    grab_cap;
static struct v4l2_format        grab_pix;
static int                       grab_fd, grab_size;
static unsigned char            *grab_data;

void
grab_init()
{
    if (-1 == (grab_fd = open(GRAB_DEVICE,O_RDWR))) {
	perror("open " GRAB_DEVICE);
	exit(1);
    }
    if (-1 == ioctl(grab_fd,VIDIOC_QUERYCAP,&grab_cap)) {
	fprintf(stderr,"wrong device\n");
	exit(1);
    }
    if (-1 == ioctl(grab_fd, VIDIOC_G_FMT, &grab_pix)) {
        perror("ioctl VIDIOC_G_FMT");
	exit(1);
    }
    grab_pix.pixelformat = V4L2_PIX_FMT_BGR24;
    grab_pix.depth  = 24;
    grab_pix.width  = GRAB_WIDTH;
    grab_pix.height = GRAB_HEIGHT;
    if (-1 == ioctl(grab_fd, VIDIOC_S_FMT, &grab_pix)) {
	perror("ioctl VIDIOC_S_FMT");
	exit(1);
    }
    grab_size = grab_pix.width * grab_pix.height * ((grab_pix.depth+7)/8);
    fprintf(stderr,"grabber: using %dx%dx%d => %d byte\n",
	    grab_pix.width,grab_pix.height,grab_pix.depth,grab_size);
    if (NULL == (grab_data = malloc(grab_size))) {
	fprintf(stderr,"out of virtual memory\n");
	exit(1);
    }
}

unsigned char*
grab_one(int *width, int *height)
{
    int rc;

    for (;;) {
	rc = read(grab_fd,grab_data,grab_size);
	if (rc == grab_size) {
	    swap_rgb24(grab_data,grab_pix.width*grab_pix.height);
	    *width  = grab_pix.width;
	    *height = grab_pix.height;
	    return grab_data;
	}
	fprintf(stderr,"grabber: read: %d != %d\n",grab_size,rc);
	if (-1 == rc)
	    perror("grabber: read");
    }
}

#endif

/* ---------------------------------------------------------------------- */
/* capture stuff  -  old v4l (bttv)                                       */

#ifdef VIDIOCGCAP

static struct video_capability   grab_cap;
static struct video_mmap         grab_buf;
static struct video_channel	 grab_chan;
static int                       grab_fd, grab_size;
static unsigned char            *grab_data;

void
grab_init()
{
	

    if (-1 == (grab_fd = open(GRAB_DEVICE,O_RDWR))) {
	perror("open " GRAB_DEVICE);
	exit(1);
    }
    if (-1 == ioctl(grab_fd,VIDIOCGCAP,&grab_cap)) {
	fprintf(stderr,"wrong device\n");
	exit(1);
    }

    /* set image source and TV norm */
    grab_chan.channel = GRAB_SOURCE;
    if (-1 == ioctl(grab_fd,VIDIOCGCHAN,&grab_chan)) {
	perror("ioctl VIDIOCGCHAN");
	exit(1);
    }
    grab_chan.channel = GRAB_SOURCE;    
    grab_chan.norm    = GRAB_NORM;
    if (-1 == ioctl(grab_fd,VIDIOCSCHAN,&grab_chan)) {
	perror("ioctl VIDIOCSCHAN");
	exit(1);
    }

    grab_buf.format = VIDEO_PALETTE_RGB24;
    grab_buf.frame  = 0;
    grab_buf.width  = GRAB_WIDTH;
    grab_buf.height = GRAB_HEIGHT;
    grab_size = grab_buf.width * grab_buf.height * 3;
    grab_data = mmap(0,grab_size,PROT_READ|PROT_WRITE,MAP_SHARED,grab_fd,0);
    if (-1 == (int)grab_data) {
	perror("mmap");
	exit(1);
	
    }
}

unsigned char*
grab_one(int *width, int *height)
{

	puts("\a"); /* sound a beep before the grabbing process takes place*/
 	sleep(5);   /* so we can be ready for it, then delays 5 seconds    */ 
		    /* the beep only works when 'grabit' is run from       */
		    /* the console as a stand-alone program  	           */
	for (;;) {
 	if (-1 == ioctl(grab_fd,VIDIOCMCAPTURE,&grab_buf)) {
	    perror("ioctl VIDIOCMCAPTURE");
        } else {
	    if (-1 == ioctl(grab_fd,VIDIOCSYNC,&grab_buf)) {
		perror("ioctl VIDIOCSYNC");
	    } else {
		swap_rgb24(grab_data,grab_buf.width*grab_buf.height);
		*width  = grab_buf.width;
		*height = grab_buf.height;
		return grab_data;
	    }
        }
	sleep(1);
    }
}

#endif

/* ---------------------------------------------------------------------- */

#if 0
# define CHAR_HEIGHT  8
# define CHAR_WIDTH   8
# define CHAR_START   1
# include "font_8x8.h"
#else
# define CHAR_HEIGHT  11
# define CHAR_WIDTH   6
# define CHAR_START   4
# include "font_6x11.h"
#endif

void
add_text(char *image, int width, int height)
{
    time_t      t;
    struct tm  *tm;
    char        line[128],*ptr;
    int         i,x,y,f,len;

    time(&t);
    tm = localtime(&t);
    len = strftime(line,127,GRAB_TEXT,tm);
    fprintf(stderr,"%s\n",line);

    for (y = 0; y < CHAR_HEIGHT; y++) {
	ptr = image + 3 * width * (height-CHAR_HEIGHT-2+y) + 12;
	for (x = 0; x < len; x++) {
	    f = fontdata[line[x] * CHAR_HEIGHT + y];
	    for (i = CHAR_WIDTH-1; i >= 0; i--) {
		if (f & (CHAR_START << i)) {
		    ptr[0] = 255;
		    ptr[1] = 255;
		    ptr[2] = 255;
		}
		ptr += 3;
	    }
	}
    }
}

void
swap_rgb24(char *mem, int n)
{
    char  c;
    char *p = mem;
    int   i = n;
    
    while (--i) {
	c = p[0]; p[0] = p[2]; p[2] = c;
	p += 3;
    }
}

int
main(int argc, char *argv[])
{
    unsigned char *image;
    int width, height;

    
    grab_init();
    
	image = grab_one(&width,&height);
	add_text(image,width,height);
	write_jpeg(JPEG_FILE,image,width,height);

    return 0;
}
