/***************************************************************************
                          kwebcam.cpp  -  description
                             -------------------
    begin                : Sat Nov  6 05:44:07 EST 1999
    copyright            : (C) 1999 by Troy Ogden
    email                : badger@bookshelves.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "kwebcam.h"
#include "kweboptions.h"
#include "ftplib.h"

KWebcam::KWebcam(QWidget *parent, const char *name)
	 : KTMainWindow(name)
	{
	setCaption(i18n("Welcome To KWebCam!"));
	setMinimumSize(500,400); // set the window box size
	setMaximumSize(500,400); // we want the window to stay one size for now

	m_menubar = new KMenuBar(this);
// obligatory file/quit box...
	fileMenu = new QPopupMenu();
	m_menubar->insertItem(i18n("&File"),fileMenu);
	quitMenu = new QPopupMenu();
	fileMenu->insertItem(i18n("&Quit"),qApp,SLOT(quit()) );
// set up the menu bar....
	m_helpMenu = kapp->getHelpMenu(TRUE,"KWebCam (version 0.1.4)\n\n"
				   "Troy Ogden\n\nbadger@bookshelves.net");

	m_menubar->insertItem(i18n("&Help"),m_helpMenu);

// the options dialog popup to set the runtime options
	optionsMenu = new QPopupMenu();
	m_menubar->insertItem(i18n("&Options"),optionsMenu);
	optionsMenu->insertItem(i18n("&Setup"),this,SLOT(getOptions()));
 	setMenu(m_menubar);

// set up the rest of the widget
	quit = new QPushButton("E&xit KWebCam",this,"quit");
	quit->setGeometry(20,260,135,30);
	quit->setFont(QFont("Times",18,QFont::Bold));
	connect(quit,SIGNAL(clicked()),qApp,SLOT(quit()));

	thebutton = new QPushButton(this,"thebutton");
	thebutton->setText("S&tart");
	thebutton->setToggleButton(TRUE);
	thebutton->setGeometry(20,60,135,30);
	thebutton->setFont(QFont("Times",18,QFont::Bold));
	connect(thebutton,SIGNAL(released()),SLOT(toggleTextSLOT()));

// some simple instructions on the widget
	mylabel= new QLabel("Press the start Button\n"
			"to begin the capture\n"
			"and sending process.\n",this);
	mylabel->setGeometry(20,100,125,80);

// checkbox for offline mode.....
	offlinebutton = new QCheckBox("Use Off-line Mode", this);
	offlinebutton->setGeometry(20,200,150,30);

//build a status bar for information
	my_statusbar = new KStatusBar(this);
	my_statusbar->insertItem(i18n("Ready"),1);
	setStatusBar(my_statusbar);

// box to show the uploading jpeg	
	picLabel = new QLabel(this, "picLabel");
	picLabel->setGeometry(175,155,320,240);
	picLabel->setFrameStyle(QFrame::Box|QFrame::Plain);

// stderr readout window...
	my_frame = new QLabel(this,"frame");
	my_frame->setGeometry(175,60,320,40);
	my_frame->setFrameStyle(QFrame::Panel|QFrame::Sunken);

	optionsDlg = new KWebOptions(0,"optionsdlg");
	timer = new QTimer(this);
	connect(timer,SIGNAL(timeout()),SLOT(timerDone()));

	} // end of this big ole function

// ########################################################################################

KWebcam::~KWebcam()
	{
//	if( m_camProcess->isRunning() )
//		m_camProcess->kill();	
	}


void KWebcam::timerDone()
	{
// check the interval for the upload and refresh rate on the pic.....
	int interval;
	config = kapp->getConfig();
	config->setGroup("General");
	interval = config->readNumEntry("delay");
// change it if we need to....
	if ( interval == 1)(timer->changeInterval(20000));
	if ( interval == 2)(timer->changeInterval(30000));
	if ( interval == 3)(timer->changeInterval(45000));
	if ( interval == 4)(timer->changeInterval(60000));
	if ( interval == 5)(timer->changeInterval(120000));
	if ( interval == 6)(timer->changeInterval(180000));
	if ( interval == 7)(timer->changeInterval(300000));
	if ( interval == 8)(timer->changeInterval(600000));
	camProcess();
	repaint(FALSE);
	}

// change the buttons text and call the camProcess() function
void KWebcam::toggleTextSLOT()
	{
	 if (thebutton->isOn())
		{
    		thebutton->setText("Sto&p");
		timer->start(10000,FALSE); // ten second start to get started...

// are we in off-line mode?
		if (!offlinebutton->isChecked())
			{
			kwebConnect();
			}
		}

	 if(!thebutton->isOn())
		{
		thebutton->setText("S&tart");
		timer->stop();
		my_frame->setText("");
		}
	}

void KWebcam::kwebConnect()
	{
	config = kapp->getConfig();
	config->setGroup("General");
	QString ftp_host = config->readEntry("server");
	QString user = config->readEntry("username");
	QString pass = config->readEntry("password");
	QString dir = config->readEntry("directory");
	QString image = config->readEntry("imgname");

// first we need to connect...
	if(!ftpOpen(ftp_host)==1)
		{
		QMessageBox::message("Error","Could not open host.\n"
			"Check the server name in the options window.\n");
		thebutton->setOn(FALSE);
		return;
		}		

// login....
	if (!ftpLogin(user,pass))
		{
		QMessageBox::message("Error","Could not login");
		thebutton->setOn(FALSE);
		ftpQuit();
		return;
		}		

// set the directory.... and return if all was sucessful...		
	if (!ftpChdir(dir)==1)
		{
		QMessageBox::message("Error","Could not change directory");
		thebutton->setOn(FALSE);
		return;
		}
	}

// this is the actuall grab and uploading function
// this event is called by timerdone()
void KWebcam::camProcess()
	{
    	m_camProcess = new KProcess();

// set up signal and slot for stdout...
	connect(m_camProcess,SIGNAL(receivedStderr(KProcess*, char*, int)),
			this,SLOT(readStderr(KProcess*, char*, int)) );
	*m_camProcess << "grabit";
	m_camProcess->start(KProcess::NotifyOnExit,KProcess::All);
	statusBar()->message("Checking for new image",2000);
	
     if (!offlinebutton->isChecked())
         {
		config = kapp->getConfig();
		config->setGroup("General");
		QString dir = config->readEntry ("directory");
		QString image = config->readEntry("imgname");
		QString imgdir = config->readEntry("imgdir");
		ftpPut(("/tmp/"+image),(dir+image),FTPLIB_IMAGE);
     	statusBar()->message("Uploading!",3000);

	     }
	}

// stopping the cam
void KWebcam::stopCam()	
	{
	if(m_camProcess->isRunning())
		m_camProcess->kill(SIGTERM);
	}

// repaint the widget to get the new image
void KWebcam::paintEvent(QPaintEvent *)
	{
	QPixmap my_pix;
	my_pix.load("/tmp/webcam.jpeg");
	QPainter painter(picLabel);
	painter.drawPixmap(0,0,my_pix);
	}

void KWebcam::getOptions()
	{
// Create the options dialog object
	optionsDlg->exec();
	return;
	}

// toss the information coming from 'grabit' where the user can see it.....
// I didn't write this, I don't understand it, it just works :-)
void KWebcam::readStderr(KProcess *m_camProcess,char* buffer,int buflen)
	{
	char mybuffer[1001];
	int amount;
	if(buflen > 1000)
		amount = 1000;
	else
		amount = buflen;

	memcpy(mybuffer,buffer,amount);
	mybuffer[amount] = '\0';

	formatstring = mybuffer;
	int pos = formatstring.find('\n');
	QString newstring;

	if(pos != -1)
		newstring = formatstring.left(pos);
	else
		newstring = formatstring;

	my_frame->setText(newstring.data());
	}								

/*	// end of kwebcam.cpp        */
