/***************************************************************************
                          FILENAME  -  description                              
                             -------------------                                         
    begin                : DATE                                           
    copyright            : (C) YEAR by AUTHOR                         
    email                : EMAIL                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "lost_dirchooserdialog.h"

#include <kmsgbox.h>
#include <kfiledialog.h>

#include <qlayout.h>
#include <qlineedit.h>
#include <qbutton.h>
#include <qlistbox.h>



LoST_DirChooserDialog::LoST_DirChooserDialog(QWidget *parent, const char *name )
:QDialog(parent,name, true)
{
	QGridLayout* gridLayout = new QGridLayout(this, 3, 1, 10);
	gridLayout->addRowSpacing(1, 15);
	
	
	QHBoxLayout* firstRowLayout = new QHBoxLayout();
	gridLayout->addLayout(firstRowLayout, 0, 0);
	
	lineEdit_ = new QLineEdit(this);
	lineEdit_->setMaxLength(512);
	lineEdit_->setMinimumSize(20, 20);
	lineEdit_->setMaximumSize(800, 20);
	firstRowLayout->addWidget(lineEdit_, 1);
	
	QButton* browseButton = new QPushButton("Browse", this);
	connect( browseButton, SIGNAL( clicked() ), SLOT( slotBrowse() ) );
	browseButton->setFixedSize(browseButton->sizeHint());
	firstRowLayout->addWidget(browseButton, 1);
	
	
	
	
	QHBoxLayout* secondRowLayout = new QHBoxLayout();
	gridLayout->addLayout(secondRowLayout, 1, 0);
	
	QVBoxLayout* listBoxLayout = new QVBoxLayout();
	listBoxLayout->addStretch(20);
	secondRowLayout->addLayout(listBoxLayout);
	
	listBox_ = new QListBox(this);
	listBox_->setMinimumSize(20, 20);
	listBox_->setMaximumSize(800, 600);
	listBoxLayout->addWidget(listBox_, 1);
	
	
	
	QVBoxLayout* buttonsLayout = new QVBoxLayout();
	secondRowLayout->addLayout(buttonsLayout);
	
	QButton* addButton = new QPushButton("Add", this);
	addButton->setFixedSize(addButton->sizeHint());
	connect( addButton, SIGNAL( clicked() ), SLOT( slotAddToList() ) );
	buttonsLayout->addWidget(addButton, 1);
	
	QButton* editButton = new QPushButton("Edit", this);
	editButton->setFixedSize(editButton->sizeHint());
	connect( editButton, SIGNAL( clicked() ), SLOT( slotEditFileInList() ) );
	buttonsLayout->addWidget(editButton, 1);
	
	QButton* removeButton = new QPushButton("Remove", this);
	removeButton->setFixedSize(removeButton->sizeHint());
	connect( removeButton, SIGNAL( clicked() ), SLOT( slotRemoveFromList() ) );
	buttonsLayout->addWidget(removeButton, 1);
	
	QButton* removeAllButton = new QPushButton("Remove all", this);
	removeAllButton->setFixedSize(removeAllButton->sizeHint());
	connect( removeAllButton, SIGNAL( clicked() ), SLOT( slotRemoveAllFromList() ) );
	buttonsLayout->addWidget(removeAllButton, 1);

	
		
	QHBoxLayout* thirdRowLayout = new QHBoxLayout();
	gridLayout->addLayout(thirdRowLayout, 2, 0);
	
	QPushButton* okButton = new QPushButton("Ok", this);
	okButton->setFixedSize(okButton->sizeHint());
	connect( okButton, SIGNAL( clicked() ), SLOT( slotOk() ) );
	thirdRowLayout->addWidget(okButton, 50);
	
	QPushButton* cancelButton = new QPushButton("Cancel", this);
	cancelButton->setFixedSize(cancelButton->sizeHint());
	connect( cancelButton, SIGNAL( clicked() ), SLOT( slotCancel() ) );
	thirdRowLayout->addWidget(cancelButton, 50);
	
	
	
	gridLayout->activate();
}

LoST_DirChooserDialog::~LoST_DirChooserDialog()
{
}

void LoST_DirChooserDialog::setExcludeDirs(const StdStringList& list)
{
	StdStringListIterator iter( (StdStringList&)list );
	std::string* str = iter.first();
	while(str)
	{
		QString qstr;
		copyStdStringToQString(qstr, *str);
		listBox_->insertItem(qstr);
		str = iter.next();
	}
}
	
void LoST_DirChooserDialog::getExcludeDirs(StdStringList& list)
{
	for (uint i=0;i<listBox_->count();i++)
	{
		const char* text = listBox_->text(i);
		std::string str(text);
		list.insert(list.end(), str);
	}
}

void LoST_DirChooserDialog::slotBrowse()
{
	const char* sel = lineEdit_->text();
	KDirDialog dlg(sel, this, "Name ???");
	if (!dlg.exec())
	{
		return;
	}
	QString dir = dlg.selectedFile();
	listBox_->insertItem(dir);
}

void LoST_DirChooserDialog::slotEditFileInList()
{
	int sel = listBox_->currentItem();
	const char* text = listBox_->text(sel);
	//KMsgBox::message(this, "", text);
	lineEdit_->setText(text);
	
	slotRemoveFromList();
}

void LoST_DirChooserDialog::slotAddToList()
{
	listBox_->insertItem( lineEdit_->text() );
}

void LoST_DirChooserDialog::slotRemoveAllFromList()
{
	listBox_->clear();
}

void LoST_DirChooserDialog::slotRemoveFromList()
{
	int sel = listBox_->currentItem();
	listBox_->removeItem(sel);
}

void LoST_DirChooserDialog::slotOk()
{
	close();
	setResult(1);
}

void LoST_DirChooserDialog::slotCancel()
{
	close();
	setResult(0);
}















