// Local includes
#include "configdialog.h"
#include "modcolumns.h"
#include "moddlgproperties.h"
#include "modstartdatabase.h"
#include "modstartlistview.h"
#include "moddefaultsdatabase.h"

// QT includes
#include <qlabel.h>

// KDE includes
#include <klocale.h>
#include <kapp.h>
#include <ktreelist.h>
#include <kiconloader.h>
#include <kseparator.h>

#include <iostream.h>

ConfigDialog::ConfigDialog(QWidget* parent, const char* name) : QDialog(parent, name, true)
{
  this->setCaption(i18n("PeopleSpace Preferences"));
  this->resize(450, 420);

  fModuleList.setAutoDelete( true );

  fSplitter = new QSplitter(this, "ConfigSplitter");
  fSplitter->setGeometry(0, 0, this->width(), this->height());

  fModuleTree = new KTreeList(fSplitter, "ModuleTree");
  fModuleTree->resize(50, this->height());
  connect(fModuleTree, SIGNAL( singleSelected(int)), this, SLOT( slotModuleTreeSingleClicked(int)));
  connect(fModuleTree, SIGNAL( selected(int)), this, SLOT( slotModuleTreeDoubleClicked(int)));

  initConfigWidget();
  initModules();
}

ConfigDialog::~ConfigDialog()
{
  fModuleList.clear();
}


void ConfigDialog::initConfigWidget()
{
  fConfigWidget = new QWidget(fSplitter, "ConfigWidget");

  KSeparator* separator = new KSeparator(fConfigWidget);
  separator->setGeometry(5, 20, 290, 5);

  fPSLogo = new QLabel(fConfigWidget);
  fPSLogo->setPixmap(Icon("peoplespacelogo.xpm"));
  fPSLogo->setGeometry(145-60, 30, 120, 335);
  fPSLogo->setAlignment( AlignCenter);
  fPSLogo->setFrameStyle( QFrame::Panel | QFrame::Raised );

  separator = new KSeparator(fConfigWidget);
  separator->setGeometry(5, 375, 290, 5);
  
  fModuleTitle = new QLabel(i18n(DEFAULT_TITLE), fConfigWidget);
  fModuleTitle->setFont(QFont("Helvetica",14,QFont::Bold));
  fModuleTitle->setAutoResize( TRUE );
  fModuleTitle->setAlignment(AlignHCenter);
  fModuleTitle->setGeometry(5, 0, fModuleTitle->width(), fModuleTitle->height());

  fHelpButton = new QPushButton(i18n("&Help"), fConfigWidget, "HelpButton");
  fHelpButton->setGeometry(5, 385, 65, 25);
  connect(fHelpButton, SIGNAL( clicked() ), this, SLOT( slotHelpButtonClicked() ));

  fCancelButton = new QPushButton(i18n("&Cancel"), fConfigWidget, "CancelButton");
  fCancelButton->setGeometry(230, 385, 65, 25);
  connect(fCancelButton, SIGNAL( clicked() ), this, SLOT( slotCancelButtonClicked() ));

  fApplyButton = new QPushButton(i18n("&Apply"), fConfigWidget, "ApplyButton");
  fApplyButton->setGeometry(162, 385, 65, 25);
  connect(fApplyButton, SIGNAL( clicked() ), this, SLOT( slotApplyButtonClicked() ));

  fOkButton = new QPushButton(i18n("&Ok"), fConfigWidget, "OkButton");
  fOkButton->setGeometry(94, 385, 65, 25);
  connect(fOkButton, SIGNAL( clicked() ), this, SLOT( slotOkButtonClicked() ));
}

void ConfigDialog::initModules()
{
  ModColumns* module1 = new ModColumns(fConfigWidget, "module_columns");
  addModule(module1);

  ModDlgProperties *module2 = new ModDlgProperties(fConfigWidget, "module_dlgproperties");
  addModule(module2);

  ModStartDatabase *module3 = new ModStartDatabase(fConfigWidget, "module_startdatabase");
  addModule(module3);

  ModStartListView *module4 = new ModStartListView(fConfigWidget, "module_startlistview");
  addModule(module4);

  ModDefaultsDatabase *module5 = new ModDefaultsDatabase(fConfigWidget, "module_defaultsdatabase");
  addModule(module5);
}

void ConfigDialog::addModule(ConfigModuleBase* module)
{
  KTreeListItem* item = NULL;
  bool found = false;
  unsigned int count = 0;
  QPixmap* icon;
  
  item = fModuleTree->itemAt(count);
  while ((item) && (!found))
    {
      // At this point the only items will be root items, so we can just check
      // to see if the section matches
      if (item->getText() == module->section())
	{
	  //cout << "Config adding title: " << module->title() << endl;
	  icon = new QPixmap;
	  *icon = Icon("mini-info.xpm");
	  fModuleTree->addChildItem(i18n(module->title()), icon, count);
	  found = true;
	}
 
      count++;
      item = fModuleTree->itemAt(count);
    }

  if (found)   // The section exists 
    {
      module->hide();
      module->setGeometry(5, 30, 280, 300);
      fModuleList.append(module);
    }

  else
    {
      //cout << "Config adding section: " << module->section() << endl;
      icon = new QPixmap;
      *icon = Icon("mini-book.xpm");
      fModuleTree->insertItem(module->section(), icon, count);
      addModule(module);
    }
  
}

void ConfigDialog::resizeEvent(QResizeEvent* e)
{
  QDialog::resizeEvent(e);

  fSplitter->setGeometry(0, 0, this->width(), this->height());
}

void ConfigDialog::hideAllModules()
{
  ConfigModuleBase* module;

  module = fModuleList.first();
  while (module != 0)
    {
      module->hide();
      module = fModuleList.next();
    }

  fPSLogo->hide();
}

void ConfigDialog::setDisplayedModule(ConfigModuleBase* module)
{
  hideAllModules();

  if (module == 0)
    {
      fModuleTitle->setText(i18n(DEFAULT_TITLE));
      fPSLogo->show();
    }

  else
    {
      fModuleTitle->setText(i18n(module->sectionAndTitle()));
      module->show();
    }
}

//////////////////////////////////////////////////////////////
//////////////////////// SLOTS ///////////////////////////////
void ConfigDialog::slotModuleTreeSingleClicked(int id)
{
  KTreeListItem* item, *parent;
  ConfigModuleBase* module;
  QString section, title;
  bool found = false;

  item = fModuleTree->itemAt(id);
  parent = item->getParent();

  if (item->hasChild())
    {
      setDisplayedModule( 0 );
      return;
    }

  section = parent->getText();
  title = item->getText();

  module = fModuleList.first();
  while ((module != 0) && (!found))
    {
      if ((module->section() == section) && (i18n(module->title()) == title))
	{
	  found = true;
	}
      else
	module = fModuleList.next();
    }

  if (found)
    setDisplayedModule(module);
  else
    setDisplayedModule( 0 );
  
}

void ConfigDialog::slotModuleTreeDoubleClicked(int id)
{
  KTreeListItem* item;

  item = fModuleTree->itemAt(id);

  if (item->hasChild())
    {
      fModuleTree->expandOrCollapseItem(id);
      setDisplayedModule( 0 );
    }
  else
    slotModuleTreeSingleClicked(id);
}

void ConfigDialog::slotApplyButtonClicked()
{
  ConfigModuleBase* module;

  module = fModuleList.first();
  while (module != 0)
    {
      module->saveOptions();
      module = fModuleList.next();
    }
}

void ConfigDialog::slotHelpButtonClicked()
{
}

void ConfigDialog::slotOkButtonClicked()
{
  slotApplyButtonClicked();
  accept();
}

void ConfigDialog::slotCancelButtonClicked()
{
  reject();
}

#include "configdialog.moc"
