// Local includes
#include "databaseinterface.h"
#include "databaseresource.h"
#include "resource.h"

// QT includes
#include <qdatetime.h>
#include <qstring.h>

// Stdlib includes
#include <iostream.h>
#include <stdlib.h>

DBInterface::DBInterface()
{
  fDatabase = new Database;

  fStoragePolicy = dbStorageAppend;
  fInsertionPolicy = dbInsertReplace;
  fLargestKey = 0;
}

DBInterface::~DBInterface()
{
  closeDB();
  delete( fDatabase );
}

DBEntry* DBInterface::fetchEntry(int key)
{
  char keyString[20];

  if (((key > largestKey()) || (key < 100)) || (!exists(key)))
    return NULL;
  
  DBEntry *entry = new DBEntry;

  QString phone, custom, customLabel;

  sprintf(keyString, "%d", key);

  entry->fKey = keyString;
  entry->fFirstname = fetchString(key+field_firstname);
  entry->fLastname = fetchString(key+field_lastname);
  entry->fTitle = fetchString(key+field_title);
  entry->fCompany = fetchString(key+field_company);

  entry->fAddress = fetchString(key+field_address);
  entry->fCity = fetchString(key+field_city);
  entry->fState = fetchString(key+field_state);
  entry->fZip = fetchString(key+field_zip);
  entry->fCountry = fetchString(key+field_country);

  entry->fPhone1 = fetchString(key+field_phone1);
  entry->fPhone1Type = fetchString(key+field_phone1type).toInt();
  entry->fPhone2 = fetchString(key+field_phone2);
  entry->fPhone2Type = fetchString(key+field_phone2type).toInt();
  entry->fPhone3 = fetchString(key+field_phone3);
  entry->fPhone3Type = fetchString(key+field_phone3type).toInt();
  entry->fPhone4 = fetchString(key+field_phone4);
  entry->fPhone4Type = fetchString(key+field_phone4type).toInt();
  entry->fPhone5 = fetchString(key+field_phone5);
  entry->fPhone5Type = fetchString(key+field_phone5type).toInt();

  entry->fCustom1 = fetchString(key+field_custom1);
  entry->fCustom1Label = fetchString(key+field_custom1label);
  entry->fCustom2 = fetchString(key+field_custom2);
  entry->fCustom2Label = fetchString(key+field_custom2label);
  entry->fCustom3 = fetchString(key+field_custom3);
  entry->fCustom3Label = fetchString(key+field_custom3label);
  entry->fCustom4 = fetchString(key+field_custom4);
  entry->fCustom4Label = fetchString(key+field_custom4label);
  
  entry->fComment = fetchString(key+field_comment);
  entry->fReferredBy = fetchString(key+field_referredby);

  entry->fEditDate = Convert::stringToDate(fetchString(key+field_editdate));
  entry->fMergeDate = Convert::stringToDate(fetchString(key+field_mergedate));
  entry->fLastReach = Convert::stringToDate(fetchString(key+field_lastreach));
  entry->fLastAttempt = Convert::stringToDate(fetchString(key+field_lastattempt));
  entry->fLastMeeting = Convert::stringToDate(fetchString(key+field_lastmeeting));

  //cout << "Edit Date: " << entry->editDate << endl;

  entry->fRecordCreator = fetchString(key+field_recordcreator);
  entry->fCreateDate = Convert::stringToDate(fetchString(key+field_createdate));

  entry->fGroup = fetchString(key+field_group).toInt();
  
  // Since the modified flag will be set and nothing was really modified,
  // we should change it back
  entry->fModified = FALSE;

  entry->fDeleteMe = FALSE;

  return entry;
}

QList<DBEntry>* DBInterface::fetchAllEntries()
{
  return NULL;
}

QList<DBEntry>* DBInterface::fetchEntries(int keyOffset, QString patternA, QString patternB)
{
  return NULL;
}

dbOpenType DBInterface::openDBType()
{
  return fDatabase->openDBType();
}

bool DBInterface::exists( int key )
{
  bool errorCode = TRUE;
  DATA_TYPE data;
  
  data.dptr = new char[20];
  sprintf(data.dptr, "%d", key);
  data.dsize = strlen(data.dptr)+1;
  
  errorCode = fDatabase->exists(data);

  return errorCode;
}

bool DBInterface::openDB(QString pathWithFile, dbOpenType flag)
{
  bool success = FALSE;

  success = fDatabase->openDB((char*)(const char*)pathWithFile, flag);
  fLargestKey = fetchInt(0);

  //cout << "Open DB call returned succes of: " << success << endl;

  return success;
}

bool DBInterface::closeDB()
{
  QString largestKeyString;

  switch (fDatabase->openDBType())
    {
    case dbOpenReadWrite:
      largestKeyString.sprintf("%d", fLargestKey);
      storeString(largestKeyString, 0);
      
    case dbOpenRead:
      fDatabase->closeDB();
      return true;

    case dbNotOpen:
      return false;
    }

  return false;
}

bool DBInterface::storeEntry(DBEntry* entry) 
{
 bool success = TRUE;
  int keyInt = 100;
  QString tempKey, tempContent;

  //cout << "Storing entry at key: " << entry->key() << endl;

  if (entry->fKey.toInt() == 0)  // This means the entry is new
    {
      entry->fKey.sprintf("%d", getAvailableKey());
    }

  DATA_TYPE key;
  DATA_TYPE content;

  key.dptr = new char[20];
  content.dptr = new char[255];

  // Original key
  keyInt = entry->fKey.toInt();
  
  // If this one fails, then there is no point in storing the rest of the
  // data because it can only be referenced by this key
  success = storeString(entry->fLastname, keyInt);

  if (!success)
    return FALSE;

  // Set the edit date to today
  entry->fEditDate = QDate::currentDate();

  success = storeString(entry->fLastname, keyInt+field_lastname);
  success = storeString(entry->fFirstname, keyInt+field_firstname);
  success = storeString(entry->fTitle, keyInt+field_title);
  success = storeString(entry->fCompany, keyInt+field_company);
  success = storeString(entry->fAddress, keyInt+field_address);
  success = storeString(entry->fCity, keyInt+field_city);
  success = storeString(entry->fState, keyInt+field_state);
  success = storeString(entry->fZip, keyInt+field_zip);
  success = storeString(entry->fCountry, keyInt+field_country);

  // Phone numbers
  //QString phone;
  //int phoneType;
  //entry->phone1(phone, phoneType);
  success = storeString(entry->fPhone1, keyInt+field_phone1);
  tempContent.sprintf("%d", entry->fPhone1Type);
  success = storeString(tempContent, keyInt+field_phone1type);

  //entry->phone2(phone, phoneType);
  success = storeString(entry->fPhone2, keyInt+field_phone2);
  tempContent.sprintf("%d", entry->fPhone2Type);
  success = storeString(tempContent, keyInt+field_phone2type);

  //entry->phone3(phone, phoneType);
  success = storeString(entry->fPhone3, keyInt+field_phone3);
  tempContent.sprintf("%d", entry->fPhone3Type);
  success = storeString(tempContent, keyInt+field_phone3type);

  //entry->phone4(phone, phoneType);
  success = storeString(entry->fPhone4, keyInt+field_phone4);
  tempContent.sprintf("%d", entry->fPhone4Type);
  success = storeString(tempContent, keyInt+field_phone4type);

  //entry->phone5(phone, phoneType);
  success = storeString(entry->fPhone5, keyInt+field_phone5);
  tempContent.sprintf("%d", entry->fPhone5Type);
  success = storeString(tempContent, keyInt+field_phone5type);

  // Custom fields
  //QString custom, customLabel;
  //entry->custom1(custom, customLabel);
  success = storeString(entry->fCustom1, keyInt+field_custom1);
  success = storeString(entry->fCustom1Label, keyInt+field_custom1label);
  
  //entry->custom2(custom, customLabel);
  success = storeString(entry->fCustom2, keyInt+field_custom2);
  success = storeString(entry->fCustom2Label, keyInt+field_custom2label);
  
  //  entry->custom3(custom, customLabel);
  success = storeString(entry->fCustom3, keyInt+field_custom3);
  success = storeString(entry->fCustom3Label, keyInt+field_custom3label);

  //entry->custom4(custom, customLabel);
  success = storeString(entry->fCustom4, keyInt+field_custom4);
  success = storeString(entry->fCustom4Label, keyInt+field_custom4label);

  success = storeString(entry->fComment, keyInt+field_comment);
  success = storeString(entry->fReferredBy, keyInt+field_referredby);
  success = storeString(Convert::dateToString(entry->fEditDate), keyInt+field_editdate);
  success = storeString(Convert::dateToString(entry->fMergeDate), keyInt+field_mergedate);
  success = storeString(Convert::dateToString(entry->fLastReach), keyInt+field_lastreach);
  success = storeString(Convert::dateToString(entry->fLastAttempt), keyInt+field_lastattempt);
  success = storeString(Convert::dateToString(entry->fLastMeeting), keyInt+field_lastmeeting);
  success = storeString(entry->fRecordCreator, keyInt+field_recordcreator);
  success = storeString(Convert::dateToString(entry->fCreateDate), keyInt+field_createdate);

  // Group
  tempContent.sprintf("%d", entry->fGroup);
  success = storeString(tempContent, keyInt+field_group);

  delete( key.dptr );
  delete( content.dptr );

  return success;
}

bool DBInterface::storeString(QString string, int keyNum, insertionPolicy policy)
{
  DATA_TYPE key;
  DATA_TYPE content;
  int success = FALSE;

  key.dptr = new char[20];
  content.dptr = new char[255];

  sprintf(key.dptr, "%d", keyNum);
  key.dsize = strlen(key.dptr)+1;
  strcpy(content.dptr, (const char*)string);
  content.dsize = strlen(content.dptr) + 1;
  success = !fDatabase->storeData(key, content, policy);
   
  //cout << "Storing entry at Key: " << key.dptr << " Success: " << success << endl;

  delete(key.dptr);
  delete(content.dptr);

  return success;
}

QString DBInterface::fetchString(int key)
{
  DATA_TYPE data;
  DATA_TYPE keyData;
  QString temp;

  keyData.dptr = new char[255];
  sprintf(keyData.dptr, "%d", key);

  keyData.dsize = strlen(keyData.dptr)+1;

  data = fDatabase->fetchData(keyData);
  
  if (data.dptr != NULL)
    {
      data.dptr[data.dsize-1] = '\0';
      temp = data.dptr;
    }

  //cout << "String: " << data.dptr << endl;

  return temp;
}

int DBInterface::fetchInt(int key)
{
 DATA_TYPE data;
  int temp = 0;

  data.dptr = new char[20];

  sprintf(data.dptr, "%d", key);
  data.dsize = strlen(data.dptr)+1;
  
  data = fDatabase->fetchData(data);
  
  if (data.dptr != NULL)
    {
      temp = atoi(data.dptr);
    }

  return temp;
}

bool DBInterface::deleteEntry(int key)
{
  int errorCode = TRUE;
  DATA_TYPE data;
  
  data.dptr = new char[20];
  sprintf(data.dptr, "%d", key);
  data.dsize = strlen(data.dptr)+1;
  
  errorCode = fDatabase->deleteData(data);
  //cout << "Deleting entry at key: " << data.dptr << " With errorCode: " << errorCode << endl;

  return errorCode;
}

insertionPolicy DBInterface::setInsertionPolicy(insertionPolicy policy)
{
  insertionPolicy oldPolicy = fInsertionPolicy;

  fInsertionPolicy = policy;

  return oldPolicy;
}

storagePolicy DBInterface::setStoragePolicy(storagePolicy policy)
{
  storagePolicy oldPolicy = fStoragePolicy;

  fStoragePolicy = policy;

  return oldPolicy;
}

int DBInterface::getAvailableKey()
{
  bool found = FALSE;
  int newKey = 0;
  int key = 100;

  int largestKeyInt =  largestKey();
  

  if (fStoragePolicy == dbStorageAppend)
    {
      newKey = largestKeyInt+100;
      fLargestKey = newKey;
    }
  
  else
    {
      while ((key <= largestKeyInt) && (!found))
	{
	  if (!exists(key))
	    {
	      newKey = key;
	      found = TRUE;
	    }
	  
	  key += 100;
	} 

      if (!found)
	{
	  newKey = largestKeyInt+100;
	  fLargestKey = newKey;
	}
    }

  return newKey;

}

