// Standard headers
#include <iostream.h>

// QT headers
#include <qsize.h>
#include <qpopupmenu.h>

// KDE headers
#include <kapp.h>
#include <kconfig.h>

// local headers
#include "listview.h"
#include "resource.h"

CListView::CListView(QWidget* parent, const char* name) : QListView(parent, name)
{
 fNumColumns = 0;
  
}

CListView::~CListView()
{
  
}

void CListView::saveYourself()
{
}

void CListView::resizeEvent(QResizeEvent* e)
{
  QListView::resizeEvent(e);

  int totalColumnWidth = 0, i = 0;

  for (i = 0; i < fNumColumns - 1; i++)
    totalColumnWidth += columnWidth(i+1);

  setColumnWidth(0, this->width() - totalColumnWidth);
}

int CListView::addColumn(const char * label, int size = -1 ) 
{
  fNumColumns++;

  return QListView::addColumn(label, size);
}

#include "listview.moc"
