#ifndef __LOOKUPDIALOG_H_
#define __LOOKUPDIALOG_H_

// QT includes
#include <qdialog.h>
#include <qstring.h>
#include <qdatetime.h>
class QLineEdit;
class QComboBox;
class QPushButton;
class QGroupBox;
class QDate;

// KDE includes
class KDatePicker;

class LookupDialog : public QDialog
{
  Q_OBJECT

public:
  
  enum eFieldComboItem { combo_firstname = 0, combo_lastname, combo_title, combo_company, combo_address, combo_city, combo_state, 
			 combo_zip, combo_country, combo_phone, combo_custom, combo_referredby, combo_recordcreator, combo_editdate, 
			 combo_mergedate, combo_lastreach, combo_lastattempt, combo_lastmeeting, combo_createdate };

  LookupDialog(QWidget* parent, const char* name);
  ~LookupDialog();

  void setLookupField(int keyOffset);

private:
  QComboBox* fFieldCombo;
  
  QLineEdit* fParam1;
  QLineEdit* fParam2;

  KDatePicker *fDatePicker;

  QGroupBox* fFieldGroupBox;
  QGroupBox* fParamGroupBox;
  QGroupBox* fDatePickerGroupBox;
  
  QPushButton* fLookupButton;
  QPushButton* fCancelButton;

  QDate fSelectedDate;

public slots:
  void slotFieldComboChanged(int);
  void slotLookupButtonClicked();
  void slotCancelButtonClicked();
  void slotDateSelected(QDate);

signals:
  void lookupButtonClicked(int fieldId, QString param1, QString param2);  
};

#endif
