#include "moddefaultsdatabase.h"

// QT includes
#include <qbuttongroup.h>
#include <qradiobutton.h>

// KDE includes
#include <kapp.h>
#include <klocale.h>
#include <kconfig.h>

ModDefaultsDatabase::ModDefaultsDatabase(QWidget* parent, const char* name) : ConfigModuleBase("Database", "Defaults", parent, name)
{
  KConfig* config = kapp->getConfig();
  config->setGroup("DEFAULTS");

  fOpenTypeBtnGrp = new QButtonGroup(i18n("DB Open Type"), this, "OpenTypeBtnGrp");
  fOpenTypeBtnGrp->setGeometry(5, 5, 270, 90);

  QRadioButton *radioButton;

  radioButton = new QRadioButton(i18n("Read / Write"), fOpenTypeBtnGrp);
  radioButton->setGeometry(10, 20, 150, 15);
  fOpenTypeBtnGrp->insert(radioButton);
  radioButton = new QRadioButton(i18n("Read Only"), fOpenTypeBtnGrp);
  radioButton->setGeometry(10, 35, 150, 15);
  fOpenTypeBtnGrp->insert(radioButton);
  radioButton = new QRadioButton(i18n("R/W first. If failure, Read"), fOpenTypeBtnGrp);
  radioButton->setGeometry(10, 50, 160, 15);
  fOpenTypeBtnGrp->insert(radioButton);
  radioButton = new QRadioButton(i18n("Always Ask"), fOpenTypeBtnGrp);
  radioButton->setGeometry(10, 65, 150, 15);
  fOpenTypeBtnGrp->insert(radioButton);

  fOpenType = config->readNumEntry("DBOpenType", 3);
  fOpenTypeBtnGrp->setButton(fOpenType);
  slotOpenTypeChanged(fOpenType);
  connect(fOpenTypeBtnGrp, SIGNAL(clicked(int) ), this, SLOT( slotOpenTypeChanged(int)));

  fStoragePolicyBtnGrp = new QButtonGroup(i18n("Storage Policy"), this, "StoragePolicyBtnGrp");
  fStoragePolicyBtnGrp->setGeometry(5, 105, 270, 60);
  
  radioButton = new QRadioButton(i18n("End of Database"), fStoragePolicyBtnGrp);
  radioButton->setGeometry(10, 20, 150, 15);
  fStoragePolicyBtnGrp->insert(radioButton);
  radioButton = new QRadioButton(i18n("First Available Position"), fStoragePolicyBtnGrp);
  radioButton->setGeometry(10, 35, 150, 15);
  fStoragePolicyBtnGrp->insert(radioButton);
  
  fStoragePolicy = config->readNumEntry("StoragePolicy", 0);
  fStoragePolicyBtnGrp->setButton(fStoragePolicy);
  slotStoragePolicyChanged(fStoragePolicy);
  connect(fStoragePolicyBtnGrp, SIGNAL(clicked(int) ), this, SLOT( slotStoragePolicyChanged(int)));

}

ModDefaultsDatabase::~ModDefaultsDatabase()
{
}

void ModDefaultsDatabase::saveOptions()
{
  KConfig* config = kapp->getConfig();

  config->setGroup("DEFAULTS");
  config->writeEntry("DBOpenType", fOpenType);
  config->writeEntry("StoragePolicy", fStoragePolicy);

  config->sync();
}

///////////////////////////////////////////////////
/////////////////// SLOTS /////////////////////////
void ModDefaultsDatabase::slotOpenTypeChanged(int id)
{
  fOpenType = id;
}

void ModDefaultsDatabase::slotStoragePolicyChanged(int id)
{
  fStoragePolicy = id;
}

#include "moddefaultsdatabase.moc"
