#include "modintro.h"

#include <qlabel.h>
#include <qfont.h>
#include <qstring.h>

#include <kapp.h>
#include <klocale.h>

ModIntro::ModIntro(QWidget* parent, const char* name) : ConfigModuleBase("Introduction", "PeopleSpace", parent, name)
{

  QString caption;
   QLabel* label;

  label = new QLabel(i18n("PeopleSpace Startup Wizard"), this);
  label->setFont(QFont("Helvetica",14,QFont::Bold));
  label->setAutoResize( TRUE );
  label->setAlignment(AlignHCenter);
  label->setGeometry(0, 0, label->width(), label->height());

  caption =  "Welcome to PeopeSpace. This application is\n";
  caption += "designed to allow you to easily manage your\n";
  caption += "contacts without sacrificing information."; 

  label = new QLabel(i18n(caption), this);
  label->setAutoResize( TRUE );
  label->setGeometry(0, 30, label->width(), label->height());

  caption =  "The next couple of pages will walk you through\n";
  caption += "the setup of some of PeopleSpace\'s more power-\n";
  caption += "ful features. Most of the entries will be given an\n";
  caption += "intelligent default. If at any time you are unsure\n";
  caption += "of the question being asked, click the Help button.\n";
  caption += "If you feel like the defaults are enough for now,\n";
  caption += "click the Finish button at any time.\n";
  caption += "All of these options will be changable later in\n";
  caption += "the Preferences dialog.\n\n";
  caption += "Click the Next button to begin...";

  label = new QLabel(i18n(caption), this);
  label->setAutoResize( TRUE );
  label->setGeometry(0, 80, label->width(), label->height());  
}

ModIntro::~ModIntro()
{
}

void ModIntro::saveOptions()
{
}

#include "modintro.moc"
