#include "modstartlistview.h"

// QT includes
#include <qbuttongroup.h>
#include <qradiobutton.h>

// KDE includes
#include <klocale.h>
#include <kapp.h>
#include <kconfig.h>

ModStartListView::ModStartListView(QWidget* parent, const char* name) : ConfigModuleBase("ListView", "Startup", parent, name)
{
  KConfig* config = kapp->getConfig();
  config->setGroup("STARTUP");

 fListViewBtnGrp = new QButtonGroup(i18n("At startup, PeopleSpace should..."), this, "ListViewBtGrp");
 fListViewBtnGrp->setGeometry(10, 5, 270, 75);
 
  QRadioButton* radioButton;

  radioButton = new QRadioButton(i18n("Always display listview."), fListViewBtnGrp);
  radioButton->setGeometry(15, 20, 230, 15);
  fListViewBtnGrp->insert(radioButton);
  radioButton =  new QRadioButton(i18n("Never display listview."), fListViewBtnGrp);
  radioButton->setGeometry(15, 35, 230, 15);
  fListViewBtnGrp->insert(radioButton);
  radioButton =  new QRadioButton(i18n("Restore last state."), fListViewBtnGrp);
  radioButton->setGeometry(15, 50, 230, 15);
  fListViewBtnGrp->insert(radioButton);

  fListView = config->readNumEntry("ListView", 2);
  fListViewBtnGrp->setButton(fListView);
  slotListViewChanged(fListView);
  connect(fListViewBtnGrp, SIGNAL(clicked(int)), this, SLOT(slotListViewChanged(int)));
}

ModStartListView::~ModStartListView()
{
}

void ModStartListView::saveOptions()
{
  KConfig* config = kapp->getConfig();
  
  config->setGroup("STARTUP");
  config->writeEntry("ListView", fListView);
}

void ModStartListView::slotListViewChanged(int id)
{
  fListView = id;
}

#include "modstartlistview.moc"
