#ifndef PEOPLESPACE_H 
#define PEOPLESPACE_H 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

// KDE includes
#include <kapp.h>
#include <ktmainwindow.h>
#include <ktoolbar.h>
class KStatusBar;
class KMenuBar;

// QT includes
#include <qlist.h>
#include <qstring.h>
class QPopupMenu;
 
// Local includes
#include "resource.h"
class PSEntryViewer;
class PSDatabaseManager;
class StartupWizard;
class DBOpenTypeDialog;
class PSEntry;
class PSAssociate;
class LookupDialog;

/**
 * This class serves as the main window for PeopleSpace.  It handles the
 * menus, toolbars, and status bars as well as creating the view.
 *
 * @short Main window class
 * @author Mike Pilone <mpilone@slac.com>
 */
class PeopleSpaceApp : public KTMainWindow
{
  Q_OBJECT

public:
  /**
   * Default Constructor
   */
  PeopleSpaceApp();
  
  /**
   * Default Destructor
   */
  virtual ~PeopleSpaceApp();

protected:
  /**
   * This function is called when it is time for the app to save its
   * properties for session management purposes.
   */
  void saveProperties(KConfig *);
  
  /**
   * This function is called when this app is restored.  The KConfig
   * object points to the session management config file that was saved
   * with @ref saveProperties
   */
  void readProperties(KConfig *);
  
  /** Initializes all the gui items, such as toolbars,
   * menubars, status bars. Should be called from the
   * constructor of this class.  
   */
  void init();   

    /** Creates the toolbar
   */
  void initToolBar();

  /** Creates the statusbar
   */
  void initStatusBar();

  /** Creates the menubar
   */
  void initMenu();

  /** Creates the view and sets the size of the main window.
   * Basically handles setting everthing the user can see.
   */
  void initPSEntryViewer();

  /** Creates the PeopleSpaceEngine.
   */                                  
  void initPSDatabaseManager();

  /** Initializes  the associate. 
   */
  void initAssociate();

 /** Writes the current information about the window to the
   * config, such as size, ect. This method shouldn't be used
   * to save any of the address information
   */
  void saveOptions();             

  /** Reads information about thew window size and position 
   * ect. This should read the settings saved by saveOptions();
   */
  void readOptions();

  /** Asks the user if they are sure that they wa to quit.
   * returns true if they want to, false otherwise.
   */
  bool queryExit();   

  /** Sets the GUI to represent whether a database is open or not
   */
  void thereIsOpenDB(bool state);

  /** Sets the GUI to represent whether a entry has been selected
   */
  void thereIsSelectedEntry(bool state);

  /** First checks for unsaved data. If it exists, the warning will be displayed.
   * Then opens a new database
   */
  void openDatabase(bool isStartup = FALSE);

  bool checkForUnsavedData();

  /** Updates all the elements that show what group filter is being applied
   */
  void updateGroupFilterWidgets(int filter);


private:
  /** The main view of the toplevel window
   */
  PSEntryViewer *fPSEntryViewer;

  /** The engine of the app holds the functions to get things done
   */
  PSDatabaseManager* fPSDatabaseManager;

  /** The welcome wizard
   */
  StartupWizard* fStartupWizard;

  /** This is the first and main toolbar for the application. This 
   * toolbar will hold the buttons to allow for traversing through
   * the contacts as well as open/close/save buttons
   */
  KToolBar *fToolBar1;
  KToolBar::BarPosition fToolBar1Pos;

  /** The status bar of the window
   */
  KStatusBar *fStatusBar;

  /** The menubar for the window
   */
  KMenuBar *fMenuBar;            

  QPopupMenu *fFilePopMenu;
  QPopupMenu *fHelpPopMenu;
  QPopupMenu *fEditPopMenu;
  QPopupMenu *fContactPopMenu;
  QPopupMenu *fLookupPopMenu;
  QPopupMenu *fLookupAddressPopMenu;
  QPopupMenu *fLookupPersonalPopMenu;
  QPopupMenu *fLookupDatePopMenu;
  QPopupMenu *fLookupRecordPopMenu;
  QPopupMenu *fViewPopMenu;
  QPopupMenu *fViewGroupPopMenu;

  PSAssociate* fPSAssociate;

  /** fMainGeom keeps the acutal size of your application and is used to
   * restore your last used application size. */
  QRect fMainGeomRect;     
  QRect fPSAssociateGeomRect;   

  int fGroupFilter;

  LookupDialog* fLookupDialog;

  //////////////////////////////////////////////
  ///////////////////  SLOTS  //////////////////

public slots:
  /**
   * This is called whenever the user Drag n' Drops something into our
   * window
   */
  //void slotDropEvent(KDNDDropZone *);

    /** switch argument for slot selection by menu or toolbar ID */
  void commandCallback(int id_);   

 /** sets the current group filter to 'groupNum'
   */
  void slotGroupFilterChanged(int filter);

  /** Creates a new blank entry
   */
  void slotCreateNewEntry();

  /** Duplicate entry creates a new entry and then copies over all the information
   * that was in the currently displayed entry to it.
   */
  void slotDuplicateEntry();

  /** Saves the loaded etries to the database. This is basically done by passing
   * the entire list to the engine.
   */
  void slotSaveLoadedEntryList();

  /** Marks an entry to be deleted. This will take effect next save
   */
  void slotDeleteViewedEntry();

  /** Displays the open file dialog and allows the user to choose the
   * database to work with
   */
  void slotOpenDatabase(bool isStartup = false);

  /** Called whenever the dtabase manager emits a darabase has opend signal.
   * This function maks sure all the proper options are turned back on and
   * the status bar shows the proper text
   */
  void slotDatabaseHasOpened(QString pathWithFile, int flag);
  void slotDatabaseHasClosed();

 /** Triggered when one of the direction buttons are pressed
   */
  void slotDirectionButtonClicked(int buttonId);

  void slotGroupFilterApplied(int, 
			      QList<QString>*,  
			      QList<QString>*,  
			      QList<QString>*,  
			      QList<QString>*);

  void slotSetViewedEntry(int, bool, bool);

  void slotConnectionBroken();
  void slotReceiveCommand(int, QString);

  /** called whenever unsaved data exists
   */
  void slotUnsavedDataExists() { slotUnsavedDataExists(TRUE); };
  void slotUnsavedDataExists(bool state = TRUE);

  /** Sends the message to the associate to close the database
   */
  void slotCloseDatabase();

  void slotTogglePSAssociateVisible();

  /** Called whenever the looupdialog needs to be displayed
   */
  void slotDisplayLookupDialog(int keyOffset);

  /** Called when the user presses the lookup button
   */
  void slotLookupButtonClicked(int fieldId, QString param1, QString param2);

  /** Shows the preference/config dialog
   */
  void slotShowConfigDialog();
   

protected slots:
  /** Called when the application needs to exit
   */
  void slotAppExit();


};

#endif
