#ifndef PS_DATABASEMANAGER_H_
#define PS_DATABASEMANAGER_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

// Local includes
#include "databaseentry.h"
#include "databaseresource.h"
#include "psentry.h"
class DBInterface;
class ListDialog;

// QT includes
#include <qlist.h>
#include <qobject.h>

// KDE includes
class KStatusBar;

/** The engine will provide a group of methods to do the filtering
 * sorting and loading
 *
 * @author Mike Pilone
 */
class PSDatabaseManager : public QObject
{
  Q_OBJECT

public:
  PSDatabaseManager();
  ~PSDatabaseManager();

  /** Scans the DB using 'groupFilter' and then emits the groupFilterApplied() signal
   */
  void applyGroupFilter(int groupFilter);

  /** Searches the Database trying to match the last search fields used, and 
   * then emits the groupFilterApplied() signal
   */
  void applySearchFilter(int fieldOffset = -1, QString param1 = "", QString param2 = "");

  /** Opens the database 'pathWithFile' using option 'flag'. Options for flag are:
   *<PRE>
   * dbReadWrite = 0
   * dbRead = 1
   * dbNotOpen = 2
   * </PRE>
   * If you choose dbNotOpen, the method will return FALSE. If the DB could be opened
   * according to 'flag', TRUE will be returned, otherwise FALSE will be returned
   */
  bool openDB(QString pathWithFile, dbOpenType flag = dbOpenReadWrite);

  /** Closes the database. Always call this so largestKey will be written to the databse.
   */
  void closeDB();

  /** Creates a new entry and adds it to the database
   */
  int createNewEntry();

  /** Writes the entry list to the database
   */
  void storeEntryList();

  /** Writes a single entry to the DB
  */
  void storeEntry(PSEntry* psEntry);
  
  /** Loads an entry from the database
   */
  PSEntry* fetchEntry(int key);

  ///** Tells the database to reopen itself
  // */
  //void reopenDatabase();

  ///** Checks to see if the database is open
  // */
  //bool databaseIsOpen() ;

  ///** sets the field in the statusbar to the prper text.
  // */
  //void setStatusBarTextToDB(KStatusBar* statusBar);

  /** Loads the desired entry and emits the signal to make sure
   * everything is displaying the same entry
   */
  void setSelectedEntry(int key, bool isNext, bool isPrev);
 
  /** Returns how the databse is open. Options are:
   * <PRE>
   * dbReadWrite = 0
   * dbRead = 1
   * dbNotOpen = 2;
   * </PRE>
   */ 
  dbOpenType openDBType();



protected:
  ///** Adds an item to the list view
  // */
  void addEntryToColumnLists(int key);

  /** Finds the next key by starting at the end of the listand working down 
   * to 0 by 100's
   */
  int getNextLargestKey();

  /** Takes a PSEntry and returns the DBEntry with all the data filled in
   */
  //DBEntry* psEntryToDBEntry(DBEntry* psEntry);

private:
  DBInterface* fDBInterface;
  
  /** The list of loaded entries. To make things faster, once an entry is loaded
   * it will be kept in this list.Once the DB is to be commited, any entry in this
   * list that has been modified will be stored in the DB
   */
  QList<PSEntry> fLoadedEntryList;

  QList<QString>* fColumn1;
  QList<QString>* fColumn2;
  QList<QString>* fColumn3;
  QList<QString>* fColumn4;

signals:
  /** Triggered whenever the database is opened. 'pathWithFile' is the entire path to the
   * file that was opened and 'access' is the access that was achieved.
   */
  void databaseHasOpened(QString pathWithFile, int access);

  /** Triggered whenever the database is closed
   */
  void databaseHasClosed();

  /** Triggered when a group filter is applied. 'groupFilter' is the current group filter,
   * 'column1-4' are the four columns of info the list dialog wants. Column4 will always be
   * the key.
   */
  void groupFilterApplied(int groupFilter, QList<QString>* column1, QList<QString>* column2, QList<QString>* column3, QList<QString>* column4);

  /** Emitted when setSelectedEntry() is called. The 'dbEntry' could be null, which means there 
   * is no selected entry
   */
  void setViewedEntry(PSEntry* dbEntry, bool isNext, bool isPrev);
};

#endif
