#ifndef PS_ENTRY_H
#define PS_ENTRY_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// QT includes
#include <qdatetime.h>
#include <qlist.h>
#include <qstring.h>

// stdlib includes
#include <stdio.h>

// Local includes
#include "databaseentry.h"

/** This is the storage class for a contact. This class provides
 * methods to access all the data within it. This ensures that the
 * modified flag will be set properly when things are changed
 *
 * @author Mike Pilone
 */
class PSEntry
{
 
public:
  PSEntry(DBEntry* dbEntry = NULL);
  ~PSEntry();

  /** Takes a string in the format MM/DD/YYYY and converts it into a QDate.
   * This can be useful when going from QLabels to display dates to the actual 
   * storage container
   */
  //static QDate stringToDate(QString date);

  /** Takes a QDate and returns it in the proper format, MM/DD/YYYY
   */
  //static QString dateToString(QDate date);

  /** Copies all the fields in this entry to a new entry and retiurns 
   * the new entry. This effective duplicates this entry.
   */
  PSEntry* duplicateSelf();

  /** Returns the DBEntry this PSEntry was holding. This method makse sure all the
   * fields in the DBEntry are up to dat
   */
  DBEntry* getDBEntry();

  /** Copies everything in the DBEntry into the PSEntry. This can be dangerous because it
   * will overwrite any changes in the PSEntry
   */
  void sync();

  /** The following are accessor methods. They are self explanitory.
   */
  QString lastName() { return fLastname; };
  void setLastName(QString lastname) { fModified = TRUE; fLastname = lastname; };

  QString firstName() { return fFirstname; };
  void setFirstName(QString firstname) { fModified = TRUE; fFirstname = firstname; };
  
  QString title() { return fTitle; };
  void setTitle(QString title) { fModified = TRUE; fTitle = title; };

  QString company() { return fCompany; };
  void setCompany(QString company) { fModified = TRUE; fCompany = company; };

  QString address() { return fAddress; };
  void setAddress(QString address) { fModified = TRUE; fAddress = address; };

  QString city() { return fCity; };
  void setCity(QString city) { fModified = TRUE; fCity = city; };

  QString state() { return fState; };
  void setState(QString state) { fModified = TRUE; fState = state; };

  QString zip() { return fZip; };
  void setZip(QString zip) { fModified = TRUE; fZip = zip; };

  QString country() { return fCountry; };
  void setCountry(QString country) { fModified = TRUE; fCountry = country; };

  void phone1(QString& phone1, int &phone1Type) { phone1 = fPhone1; phone1Type = (int)fPhone1Type; };
  void setPhone1(QString phone1, int phone1Type) { fModified = TRUE; fPhone1 = phone1; fPhone1Type = (ePhoneType)phone1Type; };

  void phone2(QString& phone2, int &phone2Type) { phone2 = fPhone2; phone2Type = (int)fPhone2Type; };
  void setPhone2(QString phone2, int phone2Type) { fModified = TRUE; fPhone2 = phone2; fPhone2Type = (ePhoneType)phone2Type; };

  void phone3(QString& phone3, int &phone3Type) { phone3 = fPhone3; phone3Type = (int)fPhone3Type; };
  void setPhone3(QString phone3, int phone3Type) { fModified = TRUE; fPhone3 = phone3; fPhone3Type = (ePhoneType)phone3Type; };
  
  void phone4(QString& phone4, int &phone4Type) { phone4 = fPhone4; phone4Type = (int)fPhone4Type; };
  void setPhone4(QString phone4, int phone4Type) { fModified = TRUE; fPhone4 = phone4; fPhone4Type = (ePhoneType)phone4Type; };
  
  void phone5(QString& phone5, int &phone5Type) { phone5 = fPhone5; phone5Type = (int)fPhone5Type; };
  void setPhone5(QString phone5, int phone5Type) { fModified = TRUE; fPhone5 = phone5; fPhone5Type = (ePhoneType)phone5Type; };

  void custom1(QString& custom1, QString& custom1Label) { custom1 = fCustom1; custom1Label = fCustom1Label; };
  void setCustom1(QString custom1, QString custom1Label) { fModified = TRUE; fCustom1 = custom1; fCustom1Label = custom1Label; };

  void custom2(QString& custom2, QString& custom2Label) { custom2 = fCustom2; custom2Label = fCustom2Label; };
  void setCustom2(QString custom2, QString custom2Label) { fModified = TRUE; fCustom2 = custom2; fCustom2Label = custom2Label; };

  void custom3(QString& custom3, QString& custom3Label) { custom3 = fCustom3; custom3Label = fCustom3Label; };
  void setCustom3(QString custom3, QString custom3Label) { fModified = TRUE; fCustom3 = custom3; fCustom3Label = custom3Label; };
  
  void custom4(QString& custom4, QString& custom4Label) { custom4 = fCustom4; custom4Label = fCustom4Label; };
  void setCustom4(QString custom4, QString custom4Label) { fModified = TRUE; fCustom4 = custom4; fCustom4Label = custom4Label; };

  QString comment() { return fComment; };
  void setComment(QString comment) { fModified = TRUE; fComment = comment; };

  QString referredBy() { return fReferredBy; };
  void setReferredBy(QString referredBy) { fModified = TRUE; fReferredBy = referredBy; };

  QDate editDate() { return fEditDate; };
  void setEditDate(QDate editDate) { fModified = TRUE; fEditDate = editDate; };

  QDate mergeDate() { return fMergeDate; };
  void setMergeDate(QDate mergeDate) { fModified = TRUE; fMergeDate = mergeDate; };

  QDate lastReach() { return fLastReach; };
  void setLastReach(QDate lastReach) { fModified = TRUE; fLastReach = lastReach; };

  QDate lastAttempt() { return fLastAttempt; };
  void setLastAttempt(QDate lastAttempt) { fModified = TRUE; fLastAttempt = lastAttempt; };

  QDate lastMeeting() { return fLastMeeting; };
  void setLastMeeting(QDate lastMeeting) { fModified = TRUE; fLastMeeting = lastMeeting; };

  QString recordCreator() { return fRecordCreator; };
  void setRecordCreator(QString recordCreator) { fModified = TRUE; fRecordCreator = recordCreator; };

  QDate createDate() { return fCreateDate; };
  void setCreateDate(QDate createDate) { fModified = TRUE; fCreateDate = createDate; };

  int group() { return (int) fGroup; };
  void setGroup(int group) { fModified = TRUE;  fGroup = (eGroupType)group; };

  bool modified() { return fModified; };
  void setModified(bool state) { fModified = state; };

  bool deleteMe() { return fDeleteMe; };
  void setDeleteMe(bool state) { fModified = TRUE; fDeleteMe = state; };

  int key() { return fKey.toInt(); };
  void setKey(int key);

  /** This enum will be used to store the types of the phone categories
   */
  enum ePhoneType { phoneWork = 0, phoneHome, phoneFax, phoneEmail, phonePager, phoneMobile, phoneMain, phoneOther};
  
  /** This enum provides the choices you can use to set the group field
 */
  enum eGroupType { groupPersonal, groupBusiness, groupUnfiled };
  
  /** This enum provides the choices you can use to catagorize a note
   */
  enum eNoteType { noteTodo = 0, noteReminder, noteNote };
  
  /** This is the stucture that holds notes
   */
  typedef struct NoteStruct
  {
    QDate date;
    QTime time;
    eNoteType noteType;
    QString regaurding;
    QString creator;
  } fNote;
  
protected:
  /** Takes a DBEntry and sets all the fields to default values
   */
  void initDBEntry(DBEntry* dbEntry);

private:
  /** A pointer to the DBEntry this PSEntry was created from and responsible for. This will be retunred
   * when getDBEntry() is called
   */
  DBEntry* fDBEntry;

  /** Stores whether something has been modified in this entry or not.
   */
  bool fModified;

  /** Stores whether this entry should be deleted as of next perge or not
   */
  bool fDeleteMe;

  // These are the fields of an entry
  QString fLastname;
  QString fFirstname;
  
  QString fTitle;
  QString fCompany;
  
  QString fAddress;
  QString fCity;
  QString fState;
  QString fZip;
  QString fCountry;
  
  QString fPhone1;
  QString fPhone2;
  QString fPhone3;
  QString fPhone4;
  QString fPhone5;
  
  QString fCustom1;
  QString fCustom2;
  QString fCustom3;
  QString fCustom4;
  
  QString fComment;
  
  QString fReferredBy;
  
  QDate fEditDate;
  QDate fMergeDate;
  QDate fLastReach;
  QDate fLastAttempt;
  QDate fLastMeeting;
  
  QString fRecordCreator;
  QDate fCreateDate;
  
  QList<NoteStruct> fNotes;
  
  eGroupType fGroup;
  
  QString fCustom1Label;
  QString fCustom2Label;
  QString fCustom3Label;
  QString fCustom4Label;
  
  ePhoneType fPhone1Type;
  ePhoneType fPhone2Type;
  ePhoneType fPhone3Type;
  ePhoneType fPhone4Type;
  ePhoneType fPhone5Type;

  QString fKey;
};  

#endif
