// Local includes
#include "upperwidget.h"
#include "psentry.h"
#include "resource.h"

// QT includes
#include <qlineedit.h>
#include <qmultilinedit.h>
#include <qcombobox.h>
#include <qlabel.h>

// KDE includes
#include <klocale.h>

// Stdlib includes
#include <iostream.h>


UpperWidget::UpperWidget(QWidget* parent, const char* name) : QWidget(parent, name)
{
  QLabel *label;
  int yPos = 8;

  label = new QLabel(i18n("First Name:"), this, "FirstNameLabel");
  label->setGeometry(COL_1_LABEL_X_POS, yPos, 80, 20);
  fFirstName = new QLineEdit(this, "FirstName");
  fFirstName->setGeometry(COL_1_FIELD_X_POS, yPos, 130, 20);
  yPos += 24;
  
  label = new QLabel(i18n("Last Name:"), this, "LastNameLabel");
  label->setGeometry(COL_1_LABEL_X_POS, yPos, 80, 20);
  fLastName = new QLineEdit(this, "LastName");
  fLastName->setGeometry(COL_1_FIELD_X_POS, yPos, 130, 20);
  yPos += 24;
  
  label = new QLabel(i18n("Company:"), this, "CompanyLabel");
  label->setGeometry(COL_1_LABEL_X_POS, yPos, 80, 20);
  fCompany = new QLineEdit(this, "Company");
  fCompany->setGeometry(COL_1_FIELD_X_POS, yPos, 130, 20);
  yPos += 24;
  
  label = new QLabel(i18n("Title:"), this, "TitleLabel");
  label->setGeometry(COL_1_LABEL_X_POS, yPos, 80, 20);
  fTitle = new QLineEdit(this, "Title");
  fTitle->setGeometry(COL_1_FIELD_X_POS, yPos, 130, 20);
  yPos += 26;

  fModified = new QLabel(i18n("Modified"), this, "Modfied");
  fModified->setGeometry(COL_1_LABEL_X_POS+30, yPos, 70, 20);
  fModified->setFrameStyle( QFrame::Box | QFrame::Sunken );
  fModified->setLineWidth(2);

  fDeleteMe = new QLabel(i18n("Deleted"), this, "DeleteMe");
  fDeleteMe->setGeometry(COL_1_LABEL_X_POS+130, yPos, 65, 20);
  fDeleteMe->setFrameStyle( QFrame::Box | QFrame::Sunken );
  fDeleteMe->setLineWidth(2);

  // NEW COLUMN
  yPos = 8;

  label = new QLabel(i18n("Address:"), this, "AddressLabel");
  label->setGeometry(COL_2_LABEL_X_POS, yPos, 80, 20);
  fAddress = new QLineEdit(this, "Address");
  fAddress->setGeometry(COL_2_FIELD_X_POS, yPos, 130, 20);
  yPos += 24;

  label = new QLabel(i18n("City:"), this, "CityLabel");
  label->setGeometry(COL_2_LABEL_X_POS, yPos, 80, 20);
  fCity = new QLineEdit(this, "City");
  fCity->setGeometry(COL_2_FIELD_X_POS, yPos, 130, 20);
  yPos += 24;

  label = new QLabel(i18n("State:"), this, "StateLabel");
  label->setGeometry(COL_2_LABEL_X_POS, yPos, 80, 20);
  fState = new QLineEdit(this, "State");
  fState->setGeometry(COL_2_FIELD_X_POS, yPos, 130, 20);
  yPos += 24;

  label = new QLabel(i18n("Zip:"), this, "ZipLabel");
  label->setGeometry(COL_2_LABEL_X_POS, yPos, 80, 20);
  fZip = new QLineEdit(this, "Zip");
  fZip->setGeometry(COL_2_FIELD_X_POS, yPos, 130, 20);
  yPos += 24;

  label = new QLabel(i18n("Country:"), this, "CountryLabel");
  label->setGeometry(COL_2_LABEL_X_POS, yPos, 80, 20);
  fCountry = new QLineEdit(this, "Country");
  fCountry->setGeometry(COL_2_FIELD_X_POS, yPos, 130, 20);

  // NEW COLUMN
  yPos = 8;

  fPhone1Type = new QComboBox(FALSE, this, "Phone1Type");
  fPhone1Type->setGeometry(COL_3_LABEL_X_POS, yPos, 80, 20);
  initPhoneTypeComboBox(fPhone1Type, 1);
  fPhone1 = new QLineEdit(this, "Phone1");
  fPhone1->setGeometry(COL_3_FIELD_X_POS, yPos, 130, 20);
  yPos += 24;

  fPhone2Type = new QComboBox(FALSE, this, "Phone2Type");
  fPhone2Type->setGeometry(COL_3_LABEL_X_POS, yPos, 80, 20);
  initPhoneTypeComboBox(fPhone2Type, 2);
  fPhone2 = new QLineEdit(this, "Phone2");
  fPhone2->setGeometry(COL_3_FIELD_X_POS, yPos, 130, 20);
  yPos += 24;

  fPhone3Type = new QComboBox(FALSE, this, "Phone3Type");
  fPhone3Type->setGeometry(COL_3_LABEL_X_POS, yPos, 80, 20);
  initPhoneTypeComboBox(fPhone3Type, 3);
  fPhone3 = new QLineEdit(this, "Phone3");
  fPhone3->setGeometry(COL_3_FIELD_X_POS, yPos, 130, 20);
  yPos += 24;

  fPhone4Type = new QComboBox(FALSE, this, "Phone4Type");
  fPhone4Type->setGeometry(COL_3_LABEL_X_POS, yPos, 80, 20);
  initPhoneTypeComboBox(fPhone4Type, 4);
  fPhone4 = new QLineEdit(this, "Phone4");
  fPhone4->setGeometry(COL_3_FIELD_X_POS, yPos, 130, 20);
  yPos += 24;

  fPhone5Type = new QComboBox(FALSE, this, "Phone5Type");
  fPhone5Type->setGeometry(COL_3_LABEL_X_POS, yPos, 80, 20);
  initPhoneTypeComboBox(fPhone5Type, 5);
  fPhone5 = new QLineEdit(this, "Phone5");
  fPhone5->setGeometry(COL_3_FIELD_X_POS, yPos, 130, 20);
  
  connectChangedSignal();
 
}

UpperWidget::~UpperWidget()
{
}

void UpperWidget::saveCurrentlyViewedEntry(PSEntry* entry)
{
  entry->setFirstName(fFirstName->text());
  entry->setLastName(fLastName->text());
  
  entry->setTitle(fTitle->text());
  entry->setCompany(fCompany->text());

  entry->setAddress(fAddress->text());
  entry->setCity(fCity->text());
  entry->setState(fState->text());
  entry->setZip(fZip->text());
  entry->setCountry(fCountry->text());

  entry->setPhone1(fPhone1->text(), fPhone1Type->currentItem());
  entry->setPhone2(fPhone2->text(), fPhone2Type->currentItem());
  entry->setPhone3(fPhone3->text(), fPhone3Type->currentItem());
  entry->setPhone4(fPhone4->text(), fPhone4Type->currentItem());
  entry->setPhone5(fPhone5->text(), fPhone5Type->currentItem());

}

void UpperWidget::setCurrentlyViewedEntry(PSEntry* entry)
{
  disconnectChangedSignal();

  QString tempString;
  int tempInt;

  fLastName->setText(entry->lastName());
  fFirstName->setText(entry->firstName());
  
  fTitle->setText(entry->title());
  fCompany->setText(entry->company());

  fAddress->setText(entry->address());
  fCity->setText(entry->city());
  fState->setText(entry->state());
  fZip->setText(entry->zip());
  fCountry->setText(entry->country());

  entry->phone1(tempString, tempInt);
  fPhone1->setText(tempString);
  fPhone1Type->setCurrentItem(tempInt);
  entry->phone2(tempString, tempInt);
  fPhone2->setText(tempString);
  fPhone2Type->setCurrentItem(tempInt);
  entry->phone3(tempString, tempInt);
  fPhone3->setText(tempString);
  fPhone3Type->setCurrentItem(tempInt);
  entry->phone4(tempString, tempInt);
  fPhone4->setText(tempString);
  fPhone4Type->setCurrentItem(tempInt);
  entry->phone5(tempString, tempInt);
  fPhone5->setText(tempString);
  fPhone5Type->setCurrentItem(tempInt);

  if (entry->deleteMe())
    fDeleteMe->setPalette( QPalette( QColor(150, 0, 0) ) );
  else
    fDeleteMe->setPalette( this->palette() );
  
  if (entry->modified())
    fModified->setPalette( QPalette( QColor(150, 0, 0) ) );
  else
    fModified->setPalette( this->palette() );

  connectChangedSignal();
}

void UpperWidget::setCurrentlyViewedEntryDeleted(bool state)
{
  if (state)
    fDeleteMe->setPalette( QPalette( QColor(150, 0, 0) ) );
  else
    fDeleteMe->setPalette( this->palette() );

  slotViewedEntryChanged();
}

void UpperWidget::setCurrentlyViewedEntryModified()
{
  fModified->setPalette( QPalette( QColor(150, 0, 0) ) );
}

void UpperWidget::resizeEvent(QResizeEvent *e)
{

  QWidget::resizeEvent(e);
}

void UpperWidget::initPhoneTypeComboBox(QComboBox* phoneType, int fieldNum)
{
  phoneType->insertItem(i18n("Work:"), PSEntry::phoneWork);
  phoneType->insertItem(i18n("Home:"), PSEntry::phoneHome);
  phoneType->insertItem(i18n("Fax:"), PSEntry::phoneFax);
  phoneType->insertItem(i18n("Email:"), PSEntry::phoneEmail);
  phoneType->insertItem(i18n("Pager:"), PSEntry::phonePager);
  phoneType->insertItem(i18n("Mobile:"), PSEntry::phoneMobile);
  phoneType->insertItem(i18n("Main:"), PSEntry::phoneMain);
  phoneType->insertItem(i18n("Other:"), PSEntry::phoneOther);
  
  phoneType->setCurrentItem(fieldNum-1);
}

void UpperWidget::connectChangedSignal()
{
  connect(fLastName, SIGNAL( textChanged(const char*) ), this, SLOT( slotViewedEntryChanged() ));
  connect(fFirstName, SIGNAL( textChanged(const char*) ), this, SLOT( slotViewedEntryChanged() ));
  connect(fTitle, SIGNAL( textChanged(const char*) ), this, SLOT( slotViewedEntryChanged() ));
  connect(fCompany, SIGNAL( textChanged(const char*) ), this, SLOT( slotViewedEntryChanged() ));
  connect(fAddress, SIGNAL( textChanged(const char*) ), this, SLOT( slotViewedEntryChanged() ));
  connect(fCity, SIGNAL( textChanged(const char*) ), this, SLOT( slotViewedEntryChanged() ));
  connect(fState, SIGNAL( textChanged(const char*) ), this, SLOT( slotViewedEntryChanged() ));
  connect(fZip, SIGNAL( textChanged(const char*) ), this, SLOT( slotViewedEntryChanged() ));
  connect(fCountry, SIGNAL( textChanged(const char*) ), this, SLOT( slotViewedEntryChanged() ));
  connect(fPhone1, SIGNAL( textChanged(const char*) ), this, SLOT( slotViewedEntryChanged() ));
  connect(fPhone2, SIGNAL( textChanged(const char*) ), this, SLOT( slotViewedEntryChanged() ));
  connect(fPhone3, SIGNAL( textChanged(const char*) ), this, SLOT( slotViewedEntryChanged() ));
  connect(fPhone4, SIGNAL( textChanged(const char*) ), this, SLOT( slotViewedEntryChanged() ));
  connect(fPhone5, SIGNAL( textChanged(const char*) ), this, SLOT( slotViewedEntryChanged() ));
  connect(fPhone1Type, SIGNAL( activated(int) ), this, SLOT( slotViewedEntryChanged() ));
  connect(fPhone2Type, SIGNAL( activated(int) ), this, SLOT( slotViewedEntryChanged() ));
  connect(fPhone3Type, SIGNAL( activated(int) ), this, SLOT( slotViewedEntryChanged() ));
  connect(fPhone4Type, SIGNAL( activated(int) ), this, SLOT( slotViewedEntryChanged() ));
  connect(fPhone5Type, SIGNAL( activated(int) ), this, SLOT( slotViewedEntryChanged() ));
}

void UpperWidget::disconnectChangedSignal()
{
  disconnect(fLastName, SIGNAL( textChanged(const char*) ), this, SLOT( slotViewedEntryChanged() ));
  disconnect(fFirstName, SIGNAL( textChanged(const char*) ), this, SLOT( slotViewedEntryChanged() ));
  disconnect(fTitle, SIGNAL( textChanged(const char*) ), this, SLOT( slotViewedEntryChanged() ));
  disconnect(fCompany, SIGNAL( textChanged(const char*) ), this, SLOT( slotViewedEntryChanged() ));
  disconnect(fAddress, SIGNAL( textChanged(const char*) ), this, SLOT( slotViewedEntryChanged() ));
  disconnect(fCity, SIGNAL( textChanged(const char*) ), this, SLOT( slotViewedEntryChanged() ));
  disconnect(fState, SIGNAL( textChanged(const char*) ), this, SLOT( slotViewedEntryChanged() ));
  disconnect(fZip, SIGNAL( textChanged(const char*) ), this, SLOT( slotViewedEntryChanged() ));
  disconnect(fCountry, SIGNAL( textChanged(const char*) ), this, SLOT( slotViewedEntryChanged() ));
  disconnect(fPhone1, SIGNAL( textChanged(const char*) ), this, SLOT( slotViewedEntryChanged() ));
  disconnect(fPhone2, SIGNAL( textChanged(const char*) ), this, SLOT( slotViewedEntryChanged() ));
  disconnect(fPhone3, SIGNAL( textChanged(const char*) ), this, SLOT( slotViewedEntryChanged() ));
  disconnect(fPhone4, SIGNAL( textChanged(const char*) ), this, SLOT( slotViewedEntryChanged() ));
  disconnect(fPhone5, SIGNAL( textChanged(const char*) ), this, SLOT( slotViewedEntryChanged() ));
  disconnect(fPhone1Type, SIGNAL( activated(int) ), this, SLOT( slotViewedEntryChanged() ));
  disconnect(fPhone2Type, SIGNAL( activated(int) ), this, SLOT( slotViewedEntryChanged() ));
  disconnect(fPhone3Type, SIGNAL( activated(int) ), this, SLOT( slotViewedEntryChanged() ));
  disconnect(fPhone4Type, SIGNAL( activated(int) ), this, SLOT( slotViewedEntryChanged() ));
  disconnect(fPhone5Type, SIGNAL( activated(int) ), this, SLOT( slotViewedEntryChanged() ));
}

void UpperWidget::thereIsASelectedEntry(bool state)
{
  if (state)
    this->show();

  else
    this->hide();

}

////////////////////////////////////////////////////
//////////////////// SLOTS /////////////////////////

void UpperWidget::slotViewedEntryChanged()
{
  emit unsavedDataExists();

  gViewedEntryChanged = TRUE;
  
  fModified->setPalette( QPalette( QColor(150, 0, 0) ) );
}


#include "upperwidget.moc"
