/***************************************************************************
                          vigmeup.cpp  -  description                              
                             -------------------                                         
    begin                : Sun Jun 13 03:59:48 CDT 1999
                                           
    copyright            : (C) 1999 by Sean Melody                         
    email                : vigmeup@c-nix.com                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include <vigmeup.h>


VigmeupApp::VigmeupApp()
{
  setCaption("Vigmeup " VERSION);
//init before reading config, or else segfault.
    initObjects();

  ///////////////////////////////////////////////////////////////////
  // read the config file options
  readOptions();

  ///////////////////////////////////////////////////////////////////
  // call inits to invoke all other construction parts
  initMenuBar();

  initStatusBar();

  //initView();

  ///////////////////////////////////////////////////////////////////
  // enable bars dependend on config file setups

  menuBar()->setMenuBarPos(menu_bar_pos);



}

VigmeupApp::~VigmeupApp()
{
  saveOptions();
  kapp->quit();
}

void VigmeupApp::enableCommand(int id_)
{
  ///////////////////////////////////////////////////////////////////
  // enable menu and toolbar functions by their ID's
  menuBar()->setItemEnabled(id_,true);
  
}

void VigmeupApp::disableCommand(int id_)
{
  ///////////////////////////////////////////////////////////////////
  // disable menu and toolbar functions by their ID's
  menuBar()->setItemEnabled(id_,false);

}


void VigmeupApp::initObjects()

{
 resize(244,358);
	setMaximumSize(244,358);
	//setStyle(WindowsStyle);
	
	label1 = new QLabel(this, "label1");
	label1->setText(":");
	label1->setFont(QFont("helvetica",72,QFont::Normal,(int)0));
	label1->setAlignment(AlignHCenter | AlignTop);
	label1->setGeometry(104,39,36,99);
	label1->setPalette(QPalette(
	  QColorGroup(QColor(0,0,0), QColor(192,192,192),
	  QColor(255,255,255),QColor(96,96,96),QColor(160,160,160),
	  QColor(255,0,0),QColor(255,255,255)),
	  QColorGroup(QColor(0,0,0), QColor(192,192,192),
	  QColor(245,245,245), QColor(68,68,68), QColor(160,160,160),
	  QColor(160,160,160),QColor(255,255,255)),
	  QColorGroup(QColor(0,0,0), QColor(192,192,192),
	  QColor(245,245,245), QColor(68,68,68), QColor(160,160,160),
	  QColor(0,0,0),QColor(255,255,255))));
	label1->setMaximumSize(11111,32767);
	
	label1->setFrameStyle(QFrame::WinPanel | QFrame::Sunken);
	
	timer1 = new QTimer(this, "timer1");
	timer1->start(2000,FALSE);
	
	text1 = new QLineEdit(this, "text1");
	text1->setText("No Mp3 File Selected.");
	text1->setGeometry(-1,199,246,31);
	
	
	scroll3 = new QScrollBar(this, "scroll3");
	scroll3->setValue(10);
	scroll3->setOrientation(QScrollBar::Horizontal);
	scroll3->setGeometry(120,290,97,25);
	
	
	label3 = new QLabel(this, "label3");
	label3->setText("Snooze Length (Minutes)");
	label3->setAlignment(AlignLeft | AlignTop);
	label3->setGeometry(102,322,139,20);
	
	
	button1 = new QPushButton(this, "button1");
	button1->setText("Snooze Bar");
	button1->setFont(QFont("helvetica", 18, QFont::Bold, (int)0));
	button1->setGeometry(0,30,244,42);
	
	
	button1->setPalette(QPalette(
	  QColorGroup(QColor(0,0,0), QColor(0,0,255),
	  QColor(255,255,255),QColor(96,96,96),QColor(160,160,160),
	  QColor(0,0,0),QColor(255,255,255)),
	  QColorGroup(QColor(0,0,0), QColor(192,192,192),
	  QColor(245,245,245), QColor(68,68,68), QColor(160,160,160),
	  QColor(160,160,160),QColor(255,255,255)),
	  QColorGroup(QColor(0,0,0), QColor(192,192,192),
	  QColor(245,245,245), QColor(68,68,68), QColor(160,160,160),
	  QColor(0,0,0),QColor(255,255,255))));


	button3 = new QPushButton(this, "button3");
	button3->setText("Choose Mp3 File...");
	button3->setGeometry(0,174,244,26);

	
	button2 = new QPushButton(this, "button2");
	button2->setText("Choose Mp3 Player...");
	button2->setGeometry(0,231,244,24);

	
	text2 = new QLineEdit(this, "text2");
	text2->setText("No Player Selected.");
	text2->setGeometry(0,255,244,29);

	
	lcd3 = new QLCDNumber(this, "lcd3");
	lcd3->setNumDigits(2);
	lcd3->display(10);
	lcd3->setGeometry(0,285,97,53);

	
	lcd2 = new QLCDNumber(this, "lcd2");
	lcd2->setNumDigits(2);
	lcd2->display(30);
	lcd2->setSegmentStyle(QLCDNumber::Filled);
	lcd2->setGeometry(140,72,104,66);
	lcd2->setPalette(QPalette(
	  QColorGroup(QColor(255,0,0), QColor(192,192,192),
	  QColor(255,255,255),QColor(96,96,96),QColor(160,160,160),
	  QColor(0,0,0),QColor(255,255,255)),
	  QColorGroup(QColor(0,0,0), QColor(192,192,192),
	  QColor(245,245,245), QColor(68,68,68), QColor(160,160,160),
	  QColor(160,160,160),QColor(255,255,255)),
	  QColorGroup(QColor(0,0,0), QColor(192,192,192),
	  QColor(245,245,245), QColor(68,68,68), QColor(160,160,160),
	  QColor(0,0,0),QColor(255,255,255))));

	
	lcd1 = new QLCDNumber(this, "lcd1");
	lcd1->setNumDigits(2);
	lcd1->display(1);
	lcd1->setSegmentStyle(QLCDNumber::Filled);
	lcd1->setGeometry(0,73,104,66);
	lcd1->setPalette(QPalette(
	  QColorGroup(QColor(255,0,0), QColor(192,192,192),
	  QColor(255,255,255),QColor(96,96,96),QColor(160,160,160),
	  QColor(0,0,0),QColor(255,255,255)),
	  QColorGroup(QColor(0,0,0), QColor(192,192,192),
	  QColor(245,245,245), QColor(68,68,68), QColor(160,160,160),
	  QColor(160,160,160),QColor(255,255,255)),
	  QColorGroup(QColor(0,0,0), QColor(192,192,192),
	  QColor(245,245,245), QColor(68,68,68), QColor(160,160,160),
	  QColor(0,0,0),QColor(255,255,255))));

	
	scroll1 = new QScrollBar(this, "scroll1");
	scroll1->setValue(1);
	scroll1->setRange(0,23);
	scroll1->setOrientation(QScrollBar::Horizontal);
	scroll1->setGeometry(0,139,104,35);

	
	scroll2 = new QScrollBar(this, "scroll2");
	scroll2->setValue(30);
	scroll2->setRange(0,59);
	scroll2->setOrientation(QScrollBar::Horizontal);
	scroll2->setGeometry(140,138,104,35);





  QObject::connect(scroll2,SIGNAL(valueChanged(int)),
		lcd2,SLOT(display(int)));
	QObject::connect(scroll1,SIGNAL(valueChanged(int)),
		lcd1,SLOT(display(int)));
	QObject::connect(button2,SIGNAL(clicked()),
		this,SLOT(choosePlayer()));
	QObject::connect(button3,SIGNAL(clicked()),
		this,SLOT(chooseMp3()));
	QObject::connect(button1,SIGNAL(clicked()),
		this,SLOT(snoozeIt()));
	QObject::connect(scroll3,SIGNAL(valueChanged(int)),
		lcd3,SLOT(display(int)));
	QObject::connect(timer1,SIGNAL(timeout()),
		this,SLOT(checkTime()));

	/* initializers */
	vigAlarm=false;
	childPID=0;





}


void VigmeupApp::initMenuBar()
{

  ///////////////////////////////////////////////////////////////////
  // MENUBAR  

  ///////////////////////////////////////////////////////////////////
  // menuBar entry file_menu
  file_menu = new QPopupMenu();
 //file_menu->insertItem(Icon("mini/vigmeupapp.xpm"), i18n("New &Window"), ID_FILE_NEW_WINDOW );
 // file_menu->insertSeparator();
 // file_menu->insertItem(Icon("filenew.xpm"), i18n("&New"), ID_FILE_NEW );
  file_menu->insertItem(Icon("fileopen.xpm"), i18n("Choose Audio &File..."), ID_FILE_CHOOSE_MP3 );
 // file_menu->insertSeparator();
//  file_menu->insertItem(Icon("filefloppy.xpm") ,i18n("&Save"), ID_FILE_SAVE );
  file_menu->insertItem(Icon("fileopen.xpm"), i18n("Choose Audio &Player..."), ID_FILE_CHOOSE_PLAYER );
/*  file_menu->insertItem(i18n("&Close"), ID_FILE_CLOSE );
  file_menu->insertSeparator();
  file_menu->insertItem(Icon("fileprint.xpm"), i18n("&Print"), ID_FILE_PRINT );
  file_menu->insertSeparator();
  file_menu->insertItem(i18n("C&lose Widow"), ID_FILE_CLOSE_WINDOW);
 */
 file_menu->insertSeparator();
  file_menu->insertItem(i18n("E&xit"), ID_FILE_QUIT );

  // file_menu key accelerators

  file_menu->setAccel(CTRL+Key_F, ID_FILE_CHOOSE_MP3);
  file_menu->setAccel(CTRL+Key_P, ID_FILE_CHOOSE_PLAYER);


  ///////////////////////////////////////////////////////////////////
  // menuBar entry action_menu
  action_menu = new QPopupMenu();
  action_menu->insertItem(i18n("&Snooze"), ID_ACTION_SNOOZE );
//  action_menu->insertItem(Icon("editcopy.xpm"), i18n("&Copy"), ID_EDIT_COPY );
 // action_menu->insertItem(Icon("editpaste.xpm"), i18n("&Paste"), ID_EDIT_PASTE );
 
  //action_menu key accelerators
  action_menu->setAccel(CTRL+Key_S, ID_ACTION_SNOOZE);

 

  ///////////////////////////////////////////////////////////////////
  // EDIT YOUR APPLICATION SPECIFIC MENUENTRIES HERE
  

  ///////////////////////////////////////////////////////////////////
  // menuBar entry help_menu
  help_menu = new QPopupMenu();
  help_menu = kapp->getHelpMenu(true, i18n(IDS_APP_ABOUT));


  ///////////////////////////////////////////////////////////////////
  // MENUBAR CONFIGURATION
  // set menuBar() the current menuBar and the position due to config file
  menuBar()->insertItem(i18n("&File"), file_menu);
  menuBar()->insertItem(i18n("&Action"), action_menu);
//  menuBar()->insertItem(i18n("&View"), view_menu);

  ///////////////////////////////////////////////////////////////////
  // INSERT YOUR APPLICATION SPECIFIC MENUENTRIES HERE


  menuBar()->insertSeparator();
  menuBar()->insertItem(i18n("&Help"), help_menu);

  ///////////////////////////////////////////////////////////////////
  // CONNECT THE SUBMENU SLOTS WITH SIGNALS

  CONNECT_CMD(file_menu);
  CONNECT_CMD(action_menu);
 // CONNECT_CMD(view_menu);

}
/*void VigmeupApp::initToolBar()
{

  ///////////////////////////////////////////////////////////////////
  // TOOLBAR
  // set toolBar() the current toolBar and the position due to config file
  toolBar()->insertButton(Icon("filenew.xpm"), ID_FILE_NEW, true, i18n("New File"));
  toolBar()->insertButton(Icon("fileopen.xpm"), ID_FILE_CHOOSE_MP3, true, i18n("Open File"));
  toolBar()->insertButton(Icon("filefloppy.xpm"), ID_FILE_SAVE, true, i18n("Save File"));
  toolBar()->insertButton(Icon("fileprint.xpm"), ID_FILE_PRINT, true, i18n("Print"));
  toolBar()->insertSeparator();
  toolBar()->insertButton(Icon("editcut.xpm"), ID_ACTION_SNOOZE, true, i18n("Cut"));
  toolBar()->insertButton(Icon("editcopy.xpm"), ID_EDIT_COPY, true, i18n("Copy"));
  toolBar()->insertButton(Icon("editpaste.xpm"), ID_EDIT_PASTE, true, i18n("Paste"));
  toolBar()->insertSeparator();
  toolBar()->insertButton(Icon("help.xpm"), ID_HELP, SIGNAL(pressed()), kapp, SLOT(appHelpActivated()), true, i18n("Help"));

  ///////////////////////////////////////////////////////////////////
  // INSERT YOUR APPLICATION SPECIFIC TOOLBARS HERE -e.g. tool_bar_1:
  // add functionality for new created toolbars in:
  // enableCommand, disableCommand, in the menuBar() and an additional function slotViewToolbar_1
  // for that also create a bViewToolbar_1 and a KConfig entry (see Constructor).
  // Also update resource values and commands 


  ///////////////////////////////////////////////////////////////////
  // CONNECT THE TOOLBAR SLOTS WITH SIGNALS - add new created toolbars
  CONNECT_TOOLBAR(toolBar());

} */

void VigmeupApp::initStatusBar()
{
  ///////////////////////////////////////////////////////////////////
  //STATUSBAR
  statusBar()->insertItem(IDS_DEFAULT, ID_STATUS_MSG );
  statusBar()->setInsertOrder(KStatusBar::RightToLeft);

}

/*void VigmeupApp::initView()
{ 
  doc = new VigmeupDoc(this);

  ////////////////////////////////////////////////////////////////////
  // set the main widget here
  KApplication *app=KApplication::getKApplication();
  view = new VigmeupView(app,doc,this);
  setView(view);

} */

bool VigmeupApp::queryExit()
{
  int exit=KMsgBox::yesNo(this, i18n("Exit"), i18n("Really Quit ?"));

  if(exit==1)
    return true;
  else
    return false;
}

void VigmeupApp::saveOptions()
{
  KConfig *config = kapp->getConfig();

   config->setGroup("GENERAL");
config->writeEntry("mp3file", text1->text());
config->writeEntry("ampProgram", text2->text());
config->writeEntry("snoozeLength", scroll3->value());
config->writeEntry("LastHour", scroll1->value());
config->writeEntry("LastMinute", scroll2->value());

  config->setGroup("APPEARANCE");
  config->writeEntry("ShowToolbar",toolBar()->isVisible());
  config->writeEntry("ShowStatusbar",statusBar()->isVisible());
  config->writeEntry("MenuBarPos", (int)menuBar()->menuBarPos());
  config->writeEntry("ToolBar_Pos", (int)toolBar()->barPos());

}

void VigmeupApp::readOptions()
{
  ///////////////////////////////////////////////////////////////////
  // read the config file entries
  KConfig *config = kapp->getConfig();

  config->setGroup("GENERAL");
	text1->setText(config->readEntry("mp3file", "No Mp3 File Selected."));
	snoozeLength=config->readNumEntry("snoozeLength", 10);
	scroll3->setValue(snoozeLength);
	ampProgram=config->readEntry("ampProgram", "No Player Selected.");
	text2->setText(ampProgram);
	scroll1->setValue(config->readNumEntry("LastHour", 1));
	scroll2->setValue(config->readNumEntry("LastMinute", 30));	
  config->setGroup("APPEARANCE");
  bViewToolbar = config->readBoolEntry("ShowToolbar", true);
  bViewStatusbar = config->readBoolEntry("ShowStatusbar", true);
  menu_bar_pos = (KMenuBar::menuPosition)config->readNumEntry("MenuBarPos", KMenuBar::Top); 
//  tool_bar_pos = (KToolBar::BarPosition)config->readNumEntry("ToolBar_Pos", KToolBar::Top);

}


/////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATION
/////////////////////////////////////////////////////////////////////

/*void VigmeupApp::slotFileNewWindow()
{
  slotStatusMsg(i18n("Opening a new Application window..."));
  (new VigmeupApp)->show();
  slotStatusMsg(IDS_DEFAULT);
}

void VigmeupApp::slotFileNew()
{
  slotStatusMsg(i18n("Creating new file..."));

  slotStatusMsg(IDS_DEFAULT);
}

void VigmeupApp::slotFileOpen()
{
  slotStatusMsg(i18n("Opening file..."));

  slotStatusMsg(IDS_DEFAULT);
}


void VigmeupApp::slotFileSave()
{
  slotStatusMsg(i18n("Saving file..."));

  slotStatusMsg(IDS_DEFAULT);
}

void VigmeupApp::slotFileSaveAs()
{
  slotStatusMsg(i18n("Saving file under new filename..."));

  slotStatusMsg(IDS_DEFAULT);
}

void VigmeupApp::slotFileClose()
{
  slotStatusMsg(i18n("Closing file..."));

  slotStatusMsg(IDS_DEFAULT);
}


void VigmeupApp::slotFileCloseWindow()
{
  close();
}
*/
void VigmeupApp::slotFileQuit()
{ 

  ///////////////////////////////////////////////////////////////////
  // exits the Application
  if(this->queryExit())
    {
      saveOptions();
      KTMainWindow::deleteAll();
      kapp->quit();
    }
  else
    slotStatusMsg(IDS_DEFAULT);
    return;
}

void VigmeupApp::slotViewStatusBar()
{
  ///////////////////////////////////////////////////////////////////
  //turn Statusbar on or off
  bViewStatusbar=!bViewStatusbar;
  menuBar()->setItemChecked(ID_VIEW_STATUSBAR, bViewStatusbar);
  enableStatusBar();
  slotStatusMsg(IDS_DEFAULT);
}


void VigmeupApp::slotStatusMsg(const char *text)
{
  ///////////////////////////////////////////////////////////////////
  // change status message permanently
  statusBar()->clear();
  statusBar()->changeItem(text, ID_STATUS_MSG );
}


void VigmeupApp::slotStatusHelpMsg(const char *text)
{
  ///////////////////////////////////////////////////////////////////
  // change status message of whole statusbar temporary (text, msec)
  statusBar()->message(text, 2000);
}



void VigmeupApp::commandCallback(int id_){
  switch (id_){
    ON_CMD(ID_FILE_CHOOSE_MP3,                chooseMp3())
    ON_CMD(ID_FILE_CHOOSE_PLAYER,             choosePlayer())
    ON_CMD(ID_ACTION_SNOOZE,                 snoozeIt())
	ON_CMD(ID_FILE_QUIT,									slotFileQuit())
  }
}

void VigmeupApp::statusCallback(int id_){
  switch (id_){
    ON_STATUS_MSG(ID_FILE_CHOOSE_MP3,         i18n("Chooses Mp3 to Play"))
    ON_STATUS_MSG(ID_FILE_CHOOSE_PLAYER,      i18n("Choose Mp3 Player"))
    ON_STATUS_MSG(ID_ACTION_SNOOZE,          i18n("Snoozes the Alarm"))
	ON_STATUS_MSG(ID_FILE_QUIT,	i18n("Quit VigMeUp"))
  }
}



void
VigmeupApp::checkTime()
{
  if (!vigAlarm) {
    QTime qCurrent;
    QTime qDesired;
    qCurrent.start();
    qDesired.setHMS(lcd1->intValue(), lcd2->intValue(), 0,0);
    //qCurrent.setHMS(QTime::currentTime().hour(), QTime::currentTime().minute(),0,0);
    if (qCurrent.hour() == qDesired.hour())
      { 
	if (qCurrent.minute() == qDesired.minute())
	  { 
	    playMp3(text1->text());
	    toggleAlarm();
	  }
      }
  }
}

bool
VigmeupApp::alarmOff()
{
  return !alarmOn();
}

void
VigmeupApp::toggleAlarm()
{
  if (alarmOff()) {
    vigAlarm = true;
  }
  else 	
    {
      vigAlarm = false;
    }
  
}

bool
VigmeupApp::alarmOn()
{
  return vigAlarm;
}

void
VigmeupApp::playMp3(const char *mp3File)
{
	
  //QString temp1(mp3File);
  
  //	char *file=new char[2056];
  char *program=new char[258];
  if (childPID!=0) {
    
    if (!kill(childPID, SIGQUIT))
      kill(childPID, SIGKILL);
  }
  
  childPID=fork();
  if (childPID==0) {
    
    
    strcpy(program, ampProgram);
    // strcpy(temp, mp3File);
    
    
    //	  cout << "Program " << program << endl;
    //cout << "File " << temp << endl;
    execlp(ampProgram, mp3File);
    exit(0);
  } 
  
  slotStatusMsg("Playing, hit Snooze Bar to Snooze");
  
}

void
VigmeupApp::chooseMp3()
{
  //text1->setText(QFileDialog::getOpenFileName(0, "*.mp3"));
  text1->setText(KFileDialog::getOpenFileName(0,"*.mp2 *.mp3"));
}

void
VigmeupApp::snoozeIt()
{
//Check to see if the alarm is actually on.
  if (alarmOn()) {
    //Give us some new numbers!
    snoozeLength=lcd3->intValue();
    int n=snoozeLength;
    int newLcd1=lcd1->intValue();
    int newLcd2=lcd2->intValue();
    while (snoozeLength>0) {
      if (snoozeLength >= 60) {
	if (newLcd1 == 23) {
	  newLcd1=0;
	} //if
	else {
	  newLcd1+=1;
	} //else
	snoozeLength-=60;
      } //if
      else if ((newLcd2 + snoozeLength) >= 60)  {	
	if (newLcd1 == 23) {
	  newLcd1=0;
	} //if
	else {
	  newLcd1+=1;
	} //else
	newLcd2+=(snoozeLength-60);
	snoozeLength=0;
      } //if
      else {
	newLcd2+=snoozeLength;
	snoozeLength=0;
      } //else
    } //while
    
    //Use signals to change the actual Lcd values.
    //emit(changeLcd1(newLcd1));
    //emit(changeLcd2(newLcd2));
    scroll1->setValue(newLcd1);
    scroll2->setValue(newLcd2);
    
    //now kill the amp and turn the alarm to "off"
    if (childPID!=0) {
      
      if (!kill(childPID, SIGQUIT))
	kill(childPID, SIGKILL);
      
    }
    toggleAlarm();
    snoozeLength=n;
    slotStatusMsg("Ready");
  } //end big main if
}

void
VigmeupApp::choosePlayer()
{
	
	text2->setText(KFileDialog::getOpenFileName());
	ampProgram=text2->text();
	
}































