/***************************************************************************
                          dlgcustomtoolbarinput.cpp
                      -------------------
    description          :
    begin                : Tue Nov 14 2000
    copyright            : (C) 2000 by Kmud Developer Team
    email                : kmud-devel@kmud.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "dlgcustomtoolbarinput.h"

#include "kiconloaderdialog.h"
#include <qdir.h>

DlgCustomToolbarInput::DlgCustomToolbarInput(QWidget *parent, const char *name) : QDialog(parent,name,true)
{
	setCaption(name);
	initDialog();
	
	cmdBrowse->setPixmap(Icon("fileopen.xpm"));	
	
	connect( cmdOk, SIGNAL(clicked()), SLOT(accept()));
	connect( cmdCancel, SIGNAL(clicked()), SLOT(reject()));
	connect( cmdBrowse, SIGNAL(clicked()), SLOT(slotBrowseIcons()));
}

DlgCustomToolbarInput::~DlgCustomToolbarInput()
{
}

QString DlgCustomToolbarInput::getName(void)
{
	return txtName->text();
}

QString DlgCustomToolbarInput::getCommand(void)
{
	return txtCommand->text();
}

QString DlgCustomToolbarInput::getIcon(void)
{
	QString icon =txtIcon->text();
	return icon.stripWhiteSpace();
}

void DlgCustomToolbarInput::setName(QString s)
{
	txtName->setText(s);
}

void DlgCustomToolbarInput::setCommand(QString s)
{
	txtCommand->setText(s);
}

void DlgCustomToolbarInput::setIcon(QString s)
{
	txtIcon->setText(s);
}

void DlgCustomToolbarInput::slotBrowseIcons(void)
{
	KIconLoaderDialog d(this,"IconLoader");
	
	QStrList icon_sel_list;
  	icon_sel_list.append(KApplication::kde_icondir() + "/mini");
  	icon_sel_list.append(QDir::homeDirPath()+"/.kde/share/icons/mini");
  	icon_sel_list.append(KApplication::localkdedir()+"/share/icons/mini");
	
  	d.setDir(&icon_sel_list);
	QString name;
	QString filter;
	filter = "*";
	QPixmap pix = d.selectIcon(name,filter);
	
	txtIcon->setText(name);
}
