/***************************************************************************
                          kmudapplication.h
                      -------------------
    description          :
    begin                : Sun Jan 9 2000
    copyright            : (C) 2000 by Kmud Developer Team
    email                : kmud-devel@kmud.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef KMUDAPPLICATION_H
#define KMUDAPPLICATION_H

#include <kapp.h>
#include <qstring.h>

/**a subclass of KApplication to catch X11-Events for numpad-keywalking
  *@author Stephan Uhlmann
  */

class KmudApplication : public KApplication
{
	Q_OBJECT

public: 
	KmudApplication(int& argc, char** argv, const QString& rAppName);
	~KmudApplication();
  /** enables or disables numpad-macros */
  void setNumpadMacros(bool b);
  /** are numpad macros enabled or disabled? */
  bool getNumpadMacros();
protected: // Protected methods
	/** catch the X11KeyEvents for the numeric keypad to implement the walking with the keypad */
	bool x11EventFilter (XEvent*);

signals: // Signals
  /** emitted if a Keypad-key is pressed */

private: // Private attributes
  /** are numpad macros enabled or disabled? */
  bool numpadMacros;
};

#endif
