#include "pix.h"

extern QString DATADIR;

Block::Block( QWidget *parent, const char *name )
	: QWidget( parent, name )
{
	setMinimumSize( level_width_max*30, level_height_max*30 );
	setMaximumSize( level_width_max*30, level_height_max*30 );
	x1=100;
	pm0.load(KGlobal::dirs()->findResource("appdata","0.xpm"),0,ColorOnly);
	pm0l1r.load(KGlobal::dirs()->findResource("appdata","l1r.xpm"),0,ColorOnly);
	pm0l2r.load(KGlobal::dirs()->findResource("appdata","l2r.xpm"),0,ColorOnly);
	pm0l3r.load(KGlobal::dirs()->findResource("appdata","l3r.xpm"),0,ColorOnly);
	pm0r1l.load(KGlobal::dirs()->findResource("appdata","r1l.xpm"),0,ColorOnly);
	pm0r2l.load(KGlobal::dirs()->findResource("appdata","r2l.xpm"),0,ColorOnly);
	pm0r3l.load(KGlobal::dirs()->findResource("appdata","r3l.xpm"),0,ColorOnly);
	pm0t1b.load(KGlobal::dirs()->findResource("appdata","t1b.xpm"),0,ColorOnly);
	pm0t2b.load(KGlobal::dirs()->findResource("appdata","t2b.xpm"),0,ColorOnly);
	pm0t3b.load(KGlobal::dirs()->findResource("appdata","t3b.xpm"),0,ColorOnly);
	pm0b1t.load(KGlobal::dirs()->findResource("appdata","b1t.xpm"),0,ColorOnly);
	pm0b2t.load(KGlobal::dirs()->findResource("appdata","b2t.xpm"),0,ColorOnly);
	pm0b3t.load(KGlobal::dirs()->findResource("appdata","b3t.xpm"),0,ColorOnly);
	pm2.load(KGlobal::dirs()->findResource("appdata","2.xpm"),0,ColorOnly);
	pm25.load(KGlobal::dirs()->findResource("appdata","2in5.xpm"),0,ColorOnly);
	pmlkr.load(KGlobal::dirs()->findResource("appdata","lkr.xpm"),0,ColorOnly);
	pmrkl.load(KGlobal::dirs()->findResource("appdata","rkl.xpm"),0,ColorOnly);
	pmtkb.load(KGlobal::dirs()->findResource("appdata","tkb.xpm"),0,ColorOnly);
	pmbkt.load(KGlobal::dirs()->findResource("appdata","bkt.xpm"),0,ColorOnly);
	pm3.load(KGlobal::dirs()->findResource("appdata","3.xpm"),0,ColorOnly);
	pm5.load(KGlobal::dirs()->findResource("appdata","5.xpm"),0,ColorOnly);
	pm9.load(KGlobal::dirs()->findResource("appdata","9.xpm"),0,ColorOnly);
	pm10.load(KGlobal::dirs()->findResource("appdata","10.xpm"),0,ColorOnly);
	pm11.load(KGlobal::dirs()->findResource("appdata","11.xpm"),0,ColorOnly);
	pme1.load(KGlobal::dirs()->findResource("appdata","end1.xpm"),0,ColorOnly);
	pme2.load(KGlobal::dirs()->findResource("appdata","end2.xpm"),0,ColorOnly);
	pme3.load(KGlobal::dirs()->findResource("appdata","end3.xpm"),0,ColorOnly);
	pme4.load(KGlobal::dirs()->findResource("appdata","end4.xpm"),0,ColorOnly);
	pme5.load(KGlobal::dirs()->findResource("appdata","end5.xpm"),0,ColorOnly);
	pme6.load(KGlobal::dirs()->findResource("appdata","end6.xpm"),0,ColorOnly);
	pme7.load(KGlobal::dirs()->findResource("appdata","end7.xpm"),0,ColorOnly);
	pme8.load(KGlobal::dirs()->findResource("appdata","end8.xpm"),0,ColorOnly);
	pme9.load(KGlobal::dirs()->findResource("appdata","end9.xpm"),0,ColorOnly);
	pme10.load(KGlobal::dirs()->findResource("appdata","end10.xpm"),0,ColorOnly);
	pmt1.load(KGlobal::dirs()->findResource("appdata","teleport1.xpm"),0,ColorOnly);
	pmt2.load(KGlobal::dirs()->findResource("appdata","teleport2.xpm"),0,ColorOnly);
	pmt3.load(KGlobal::dirs()->findResource("appdata","teleport3.xpm"),0,ColorOnly);
	pmt4.load(KGlobal::dirs()->findResource("appdata","teleport4.xpm"),0,ColorOnly);
	pmt5.load(KGlobal::dirs()->findResource("appdata","teleport5.xpm"),0,ColorOnly);
	pmt6.load(KGlobal::dirs()->findResource("appdata","teleport6.xpm"),0,ColorOnly);
};

void Block::paintEvent( QPaintEvent * )
{
int i,j;
	for (i=0; i<level_width; i++)
	{
		for (j=0; j<level_height; j++)
		{
//			printf ("%i ",level[i][j]);
			if (level[i][j]==0) //empty
				bitBlt( this, i*30, j*30, &pm0);
			if (level[i][j]==100) //l1r
				bitBlt( this, i*30, j*30, &pm0l1r);
			if (level[i][j]==101) //l2r
				bitBlt( this, i*30, j*30, &pm0l2r);
			if (level[i][j]==102) //l3r
				bitBlt( this, i*30, j*30, &pm0l3r);
			if (level[i][j]==103) //r1l
				bitBlt( this, i*30, j*30, &pm0r1l);
			if (level[i][j]==104) //r2l
				bitBlt( this, i*30, j*30, &pm0r2l);
			if (level[i][j]==105) //r3l
				bitBlt( this, i*30, j*30, &pm0r3l);
			if (level[i][j]==106) //t1b
				bitBlt( this, i*30, j*30, &pm0t1b);
			if (level[i][j]==107) //t2b
				bitBlt( this, i*30, j*30, &pm0t2b);
			if (level[i][j]==108) //t3b
					bitBlt( this, i*30, j*30, &pm0t3b);
			if (level[i][j]==109) //b1t
				bitBlt( this, i*30, j*30, &pm0b1t);
			if (level[i][j]==110) //b2t
				bitBlt( this, i*30, j*30, &pm0b2t);
			if (level[i][j]==111) //b3t
				bitBlt( this, i*30, j*30, &pm0b3t);
			if (level[i][j]==2) //red blobby
				bitBlt( this, i*30, j*30, &pm2);
			if (level[i][j]==25) //red blobby in teleporter
				bitBlt( this, i*30, j*30, &pm25);
			if (level[i][j]==200) //main char l->r
				bitBlt( this, i*30, j*30, &pmlkr);
			if (level[i][j]==201) //main char r->l
					bitBlt( this, i*30, j*30, &pmrkl);
			if (level[i][j]==202) //main char t->b
				bitBlt( this, i*30, j*30, &pmtkb);
			if (level[i][j]==203) //main char b->t
				bitBlt( this, i*30, j*30, &pmbkt);
			if (level[i][j]==3)
				bitBlt( this, i*30, j*30, &pm3);
			if (level[i][j]==5)
				bitBlt( this, i*30, j*30, &pm5);
			if (level[i][j]==10) //block
				bitBlt( this, i*30, j*30, &pm10);
			if (level[i][j]==11) //non-movable block
				bitBlt( this, i*30, j*30, &pm11);
			if (level[i][j]==9) //exit
				bitBlt( this, i*30, j*30, &pm9);
// teleporting animations...
			if (level[i][j]==51)
				bitBlt( this, i*30, j*30, &pmt1);
			if (level[i][j]==52)
				bitBlt( this, i*30, j*30, &pmt2);
			if (level[i][j]==53)
				bitBlt( this, i*30, j*30, &pmt3);
			if (level[i][j]==54)
				bitBlt( this, i*30, j*30, &pmt4);
			if (level[i][j]==55)
				bitBlt( this, i*30, j*30, &pmt5);
			if (level[i][j]==56)
				bitBlt( this, i*30, j*30, &pmt6);
// end of level animations...
			if (level[i][j]==501)
				bitBlt( this, i*30, j*30, &pme1);
			if (level[i][j]==502)
				bitBlt( this, i*30, j*30, &pme2);
			if (level[i][j]==503)
				bitBlt( this, i*30, j*30, &pme3);
			if (level[i][j]==504)
				bitBlt( this, i*30, j*30, &pme4);
			if (level[i][j]==505)
				bitBlt( this, i*30, j*30, &pme5);
			if (level[i][j]==506)
				bitBlt( this, i*30, j*30, &pme6);
			if (level[i][j]==507)
				bitBlt( this, i*30, j*30, &pme7);
			if (level[i][j]==508)
				bitBlt( this, i*30, j*30, &pme8);
			if (level[i][j]==509)
				bitBlt( this, i*30, j*30, &pme9);
			if (level[i][j]==510)
				bitBlt( this, i*30, j*30, &pme10);
		}
//	printf("\n");
	}
//	printf("\n");
	QPainter p;
	p.begin(this);
	p.drawPixmap(level_width_max*30, level_height_max*30, pm2, 0, 0, -1, -1);
	p.flush();
	p.end();
}
