/***************************************************************************
                          kbeardiroperator.cpp  -  description
                             -------------------
    begin                : Mon Jun 26 2000
    copyright            : (C) 2000 by Bjrn Sahlstrm
    email                : bjorn.sahlstrom@mail.bip.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KBEARDIROPERATOR_H
#define KBEARDIROPERATOR_H
//////////////////////////////////////////////////////
// include files for QT
#include <qwidget.h>
#include <qstring.h>
#include <qwhatsthis.h>
#include <qdir.h>
//////////////////////////////////////////////////////
// include files for KDE
#include <kpropsdlg.h>
#include <kfileview.h>
#include <kurl.h>
#include <kdiroperator.h>
#include <kconfig.h>
#include <ksimpleconfig.h>
#include <kio/jobclasses.h>
#include <kglobalsettings.h>
//////////////////////////////////////////////////////
// application specific includes
#include "kbearftpview.h"
#include "kbearfileiconview.h"
#include "kbearfiledetailview.h"

class KBear;
class KBearFtpView;
class KBearFileDetailView;
class KBearFileIconView;

/**
	*This class is the working class for the different views. It contains a lot of actions for
	*manipulating the views as well as the filesysytem.
	*It also manages all fileview operations like sorting etc.
	*@short This class is the working class for the different views
	*@see KBearFtpView
	*@see KBearFileDetailView
	*@see KBearFileIconView
	*@author Bjrn Sahlstrm
*/
class KBearDirOperator : public KDirOperator {
    Q_OBJECT
	friend class KBearFtpView;
public: // methods
	/** */
	KBearDirOperator( KBearFtpView* ftpView, const KURL& urlName = KURL(),
									 QWidget *parent = 0, const char* name = 0);
	/** */
	virtual ~KBearDirOperator();
	/** sets the users home URL, this is the URL that you will be moved to when pressing the homebutton */
	void setHomeURL( const KURL& url );
	/** */
	KURL getHomeURL() const { return homeURL; };
	/** searches the current path for filename, if found sets it as current
	*@param filename is just the name to search, no url or path
	*@param caseSensitive Set this to true if you want case sensitive search, default = false
	*/
	bool setCurrentItem( const QString& fileName, bool caseSensitive=false ) ;
    /**
     * Reads the default settings for a view, i.e. the default KFile::FileView.
     * Also reads the sorting and whether hidden files should be shown.
     * Note: the default view will not be set - you have to call
     * <pre>@ref setView( KFile::Default )</pre> to apply it.
     */
    virtual void readConfig( KConfig *, const QString& group = QString::null );

    virtual void saveConfig( KConfig *, const QString& group = QString::null );
	/**
	*@returns the KBearFtpView that this operator works for
	*@see setFtpView()
	*/
	KBearFtpView* myFtpView() { return p_myFtpView; };

signals: // Signals
	/** emitted when ever the status for show / hide dotfiles is changed*/
	void showHidden( bool );
	/** emitted when ever the status for show / hide tree view is changed*/
	void showTreeView( bool );
  /**  */
  void failed();

protected slots: // Protected slots
	/** */
	void slotProperties();
	/** deletes the selected file(s) */
	void slotDelete();
	/** deletes the selected file(s) in a way so they become unrecoverable*/
	void slotShred();
	/** stop the loading of current path */
	void stop();
	/** */
	void slotHome();
	/** */
	virtual void activatedMenu( const KFileViewItem* );
	/**  */
	void slotViewLarge();
	/**  */
	void slotViewMedium();
	/**  */
	void slotViewSmall();
	/**  */
	void slotTextRight();
	/**  */
	void slotTextBottom();
	/**  */
	void slotFlowSouth();
	/**  */
	void slotFlowEast();
	/**  */
	void slotTextTruncate();
	/**  */
	void slotTextWordWrap();
	/**  */
	void slotArrangeItemsInGrid();
	/**  */
	void slotToggleIconModeActionMenu();
	/**  */
	void slotOpenInBrowser();
	/**
	*This slot is called when the @ref KIO::Job::result() signal is emitted,
	* e.g. the delete operation is finished
	*@see slotDelete()
	 */
  void slotDeleteFinished( KIO::Job* );
  /**  */
  void slotToggleTreeView();
  /**  */
  void slotSetIconViewMode();
  /**  */
  void slotSetDetailedListViewMode();
  /** Called when @ref KBear::viewSettingsChanged() signal is emitted */
  void slotViewSettingsChanged( bool detailMode, bool iconMode, bool showTree );
  /**  */
	void slotListingStarted();
  /**  */
	void slotListingCompleted();

private: // methods
	/**  */
	void setupExtraActions();
	/**  */
	void setupActionMenus();

private: // attributes
	KActionMenu* fileActionMenu;
	KActionMenu* iconModeActionMenu;
	KAction* myHomeAction;
	KAction* deleteAction;
	KAction* shredAction;
	KAction* propertiesAction;
	KAction* stopAction;
	KAction* browserAction;
	KAction* arrangeItemsAction;
	KToggleAction* detailedListAction;
	KToggleAction* iconViewAction;
	KToggleAction* treeViewAction;
	KToggleAction* largeViewAction;
	KToggleAction* mediumViewAction;
	KToggleAction* smallViewAction;
	KToggleAction* bottomTextAction;
	KToggleAction* rightTextAction;
	KToggleAction* flowEastAction;
	KToggleAction* flowSouthAction;
	KToggleAction* truncateTextAction;
	KToggleAction* wordWrapTextAction;
	KActionCollection* myActionCollection;
	KBearFtpView* p_myFtpView;
	KURL homeURL;
	KFileViewItem* activatedItem;
	KConfig* myConfig;
};
#endif
