/***************************************************************************
                          kbeardirview.h  -  description
                             -------------------
    begin                : Sun Jun 4 2000
    copyright            : (C) 2000 by Bjrn Sahlstrm
    email                : bjorn.sahlstrom@mail.bip.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KBEARDIRVIEW_H
#define KBEARDIRVIEW_H

//////////////////////////////////////////////////////////////////////
// Qt include files
#include <qwidget.h>
#include <qmessagebox.h>
#include <qdragobject.h>
//////////////////////////////////////////////////////////////////////
// KDE include files
#include <klistview.h>
#include <klocale.h>
#include <kfileviewitem.h>
#include <kfilereader.h>
#include <kurl.h>
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "kbeardirviewitem.h"
class KBearFtpView;

/**
  *@author Bjrn Sahlstrm
  **/

class KBearDirView : public KListView  {
   Q_OBJECT
friend class KBearDirViewItem;
public:
	/** Constructor */
	KBearDirView( KBearFtpView* v, QWidget *parent=0, const char *name=0);
	/** Destructor */
	~KBearDirView();
	/**  */
	void setDir( const QString &s );
	/**
	*sets the URL for the view
	*@see KURL
	*/
	void setURL( const KURL& u );
signals: // Signals
  /** This signal is emitted whenever a directory is opened or closed.
	* The @ref QListViewItem* is the item to set as current item
	 */
  void folderStatusChanged( QListViewItem* );
public slots: // Public slots
  /**  */
  void slotNewDirEntry( KFileViewItem* );
  /** This slot is called when a @ref KBearDirViewItem is selected
  *@see KBearDirViewItem
  *@see KBearFtpView::slotDirChanged
  */
  void slotFolderSelected( QListViewItem* );
  /**  */
  void slotSetFolderLocked( QString path );
  /**  */
  void slotToggleShowHidden( bool show );
  /** Called when ever an item has been deleted */
  void slotDeleteItem( KFileItem* item );
protected: // Protected methods
	/**  */
	void sendFolderStatusChanged( QListViewItem* item );
	/**
	*Reimplemented from @ref KListView
	*/
	virtual void contentsDragEnterEvent( QDragEnterEvent *e );
	/**
	*Reimplemented from @ref KListView
	*/
	virtual void contentsDragMoveEvent( QDragMoveEvent *e );
	/**
	*Reimplemented from @ref KListView
	*/
	virtual void contentsDragLeaveEvent( QDragLeaveEvent *e );
	/**
	*Reimplemented from @ref KListView
	*/
	virtual void contentsDropEvent( QDropEvent* e );
	/**
	*Reimplemented from @ref KListView
	*/
	virtual void startDrag();
	/**  */
	void rebuildNewTree();
protected slots:
	/**  */
	void slotOpenFolder();
protected: // Protected attributes
	/**
	*holds the URL of the view
	*@see KURL
	*/
	KURL url;
private:
	QListViewItem* dropItem;
	QTimer myAutoOpenTimer;
	QDragObject* myDragObject;
	KBearFtpView* p_myFtpView;
};
#endif
