/***************************************************************************
                          kbearquickconnect.cpp  -  description
                             -------------------
    begin                : Fri Jun 2 2000
    copyright            : (C) 2000 by Bjrn Sahlstrm
    email                : bjorn.sahlstrom@mail.bip.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "kbearquickconnect.h"

//-----------------------------------------------
KBearQuickConnect::KBearQuickConnect(QWidget *parent, const char *name)
		 : KDialog(parent,name,true){
	initDialog();
	PasswordEdit->setEchoMode( QLineEdit::Password );
//	connect( this, SIGNAL(returnPressed()), SLOT(accept()));
	connect(ConnectButton, SIGNAL(clicked()), SLOT(accept()));
	connect(CancelButton, SIGNAL(clicked()), SLOT(reject()));
}
//-----------------------------------------------
KBearQuickConnect::~KBearQuickConnect(){
}
//-----------------------------------------------
void KBearQuickConnect::accept(){
	SiteInfo siteInfo;
	siteInfo.info.host = HostNameEdit->text();
	siteInfo.info.port = PortSpinBox->value();
	siteInfo.info.anonym = AnonymousCheck->isChecked();
	siteInfo.info.user = UserNameEdit->text();
	siteInfo.info.pass = PasswordEdit->text();
	siteInfo.info.path = RemoteDirEdit->text();
	siteInfo.info.label = siteInfo.info.host;
	close();
	emit remoteConnect( siteInfo.info );
	if( saveSite() ) {
		siteInfo.parent = "Root";
		siteInfo.description = "";
		emit saveToSiteManager( siteInfo );
	}
}
//-----------------------------------------------
void KBearQuickConnect::reject(){
	close();
}
//-----------------------------------------------
