/***************************************************************************
                          itemdlg.cpp  -  description
                             -------------------

    This file is a part of kpl - a program for graphical presentation of
    data sets and functions.

    begin                : Sun Apr 25 1999
    copyright            : (C) 2001 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <dlfcn.h>
#include <qfileinfo.h>
#include <qpushbutton.h>
#include <qbuttongroup.h>
#include <qlistview.h>
#include <qpopupmenu.h>
#include <qheader.h>
#include <qtooltip.h>
#include <qlayout.h>
#include <klocale.h>
#include <kapp.h>
#include <kiconloader.h>
#include <kglobal.h>
#include <kconfig.h>
#include "itemdlg.h"
#include "kpldoc.h"
#include "kplchecklistitem.h"
#include "fitdlg.h"
#include "frameitem.h"
#include "arrayitem.h"
#include "funitem.h"
#include "legenditem.h"

NewItemDlg::NewItemDlg(QWidget* parent, int* i) :
 QDialog(parent, 0, true), ityp(i)
{
  setCaption(i18n("New item"));
  QVBoxLayout* vbox = new QVBoxLayout(this, 11, 6);
  vbox->addWidget(bg = new QButtonGroup(5, Qt::Vertical, this));
  new QPushButton(i18n("Frame"), bg);
  new QPushButton(i18n("Array"), bg);
  new QPushButton(i18n("Function"), bg);
  new QPushButton(i18n("Parametric Function"), bg);
  new QPushButton(i18n("Legend"), bg);
  connect(bg, SIGNAL(clicked(int)), SLOT(slotClicked(int)));
  QHBoxLayout* hbox = new QHBoxLayout(vbox, 6);
  hbox->addItem(new QSpacerItem(10, 10));
  QPushButton* b = new QPushButton(i18n("Cancel"), this);
  hbox->addWidget(b);
  b->setDefault(true);
  connect(b, SIGNAL(clicked()), SLOT(reject()));
  hbox->addItem(new QSpacerItem(10, 10));
}

NewItemDlg::~NewItemDlg()
{
}

void NewItemDlg::slotClicked(int id)
{
  *ityp = id + 1;
  accept();
}

ItemDlg::ItemDlg(KplDoc* model) : m(model), iArr(-1), iFun(-1)
{
  popupMenu = new QPopupMenu();
  popupMenu->setCheckable(true);
  popupMenu->insertItem(i18n("&Edit"), this, SLOT(slotEdit()));
  popupMenu->insertItem(i18n("&Delete"), this, SLOT(slotDelete()));
  popupMenu->insertItem(i18n("&Copy"), this, SLOT(slotCopy()));
  idActive = popupMenu->insertItem(i18n("&Active"), this,
                                   SLOT(slotToggleState()));
  KConfig* config = KGlobal::config();
  config->setGroup("ItemDialog");
  setGeometry(config->readNumEntry("x"),
              config->readNumEntry("y", 20),
              config->readNumEntry("Width", 510),
              config->readNumEntry("Height", 240));
  itemList = new QListView(this);
  itemList->setFrameStyle(QFrame::Panel | QFrame::Sunken);
  itemList->addColumn(i18n("Active"));
  itemList->addColumn(i18n("Type"));
  itemList->addColumn(i18n("Settings"));
  itemList->setRootIsDecorated(true);
  itemList->setAllColumnsShowFocus(true);
  itemList->setSorting(-1);
  itemList->header()->setClickEnabled(false);
  connect(itemList, SIGNAL(returnPressed(QListViewItem*)),
          SLOT(slotList(QListViewItem*)));
  connect(itemList, SIGNAL(currentChanged(QListViewItem*)),
          SLOT(slotSelectionChanged(QListViewItem*)));
  connect(itemList, SIGNAL(rightButtonClicked(QListViewItem*,
    const QPoint&, int)), SLOT(slotPopup(QListViewItem*, const QPoint&)));
  connect(itemList, SIGNAL(mouseButtonPressed(int, QListViewItem*,
    const QPoint&, int)), SLOT(slotButtonPressed(int, QListViewItem*)));
  QHBoxLayout* hbox = new QHBoxLayout(this, 11, 6);
  QVBoxLayout* vbox = new QVBoxLayout(hbox, 6);
  vbox->addItem(new QSpacerItem(10, 10));
  vbox->addWidget(up = new QPushButton(this));
  up->setPixmap(BarIcon("up"));
  connect(up, SIGNAL(clicked()), SLOT(slotMoveUp()));
  vbox->addWidget(down = new QPushButton(this));
  down->setPixmap(BarIcon("down"));
  connect(down, SIGNAL(clicked()), SLOT(slotMoveDown()));
  vbox->addItem(new QSpacerItem(10, 10));
  hbox->addWidget(itemList);
  vbox = new QVBoxLayout(hbox, 6);
  QPushButton* b = new QPushButton(i18n("New"), this);
  vbox->addWidget(b);
  connect(b, SIGNAL(clicked()), SLOT(slotNew()));
  vbox->addWidget(edit = new QPushButton(i18n("Edit"), this));
  connect(edit, SIGNAL(clicked()), SLOT(slotEdit()));
  vbox->addWidget(fit = new QPushButton(i18n("Fit"), this));
  connect(fit, SIGNAL(clicked()), SLOT(slotFit()));
  vbox->addWidget(del = new QPushButton(i18n("Delete"), this));
  connect(del, SIGNAL(clicked()), SLOT(slotDelete()));
  vbox->addWidget(copy = new QPushButton(i18n("Copy"), this));
  connect(copy, SIGNAL(clicked()), SLOT(slotCopy()));
  vbox->addWidget(b = new QPushButton(i18n("Help"), this));
  connect(b, SIGNAL(clicked()), SLOT(slotHelp()));
  vbox->addWidget(b = new QPushButton(i18n("Close"), this));
  connect(b, SIGNAL(clicked()), SLOT(hide()));
  updItemList();
}

ItemDlg::~ItemDlg()
{
  delete popupMenu;
}

void ItemDlg::updItemList()
{
  setCaption(m->URL().fileName() + " - " + i18n("Items"));
  int current = -1;
  if (!itemList->isMultiSelection())
    current = lItem.findRef((KplCheckListItem *) itemList->currentItem());
  itemList->clear();
  up->setEnabled(false);
  down->setEnabled(false);
  lItem.clear();
  int nItems = m->itd.count();
  bool funcs = false, arrays = false;
  if (nItems) {
    KplCheckListItem* parent = 0;
    for (KplItem* item = m->itd.first(); item; item = m->itd.next()) {
      if (parent)
        if (item->iType() == KplItem::Frame)
          lItem.append(new KplCheckListItem(itemList, parent));
        else
          lItem.append(new KplCheckListItem(parent, lItem.getLast()));
      else
        if (item == m->itd.getFirst())
          lItem.append(new KplCheckListItem(itemList));
        else
          lItem.append(new KplCheckListItem(itemList, lItem.getLast()));
      if (item->iType() == KplItem::Frame) {
        parent = lItem.current();
        parent->setOpen(true);
      }
      item->setText(lItem.current(), &arrays, &funcs);
      lItem.current()->setOn(item->active);
      connect(lItem.current(), SIGNAL(stateChanged(KplCheckListItem *, bool)),
              SLOT(slotStateChanged(KplCheckListItem *, bool)));
    }
    KplCheckListItem* itm = lItem.at(QMAX(0, QMIN(current, nItems - 1)));
    itemList->setSelected(itm, true);
    itemList->setCurrentItem(itm);
    itemList->ensureItemVisible(itm);
  }
  edit->setEnabled(nItems);
  fit->setEnabled(arrays && funcs);
  copy->setEnabled(nItems);
  del->setEnabled(nItems);
  itemList->setFocus();
}

void ItemDlg::moveItem(int di)
{
  int is = lItem.findRef((KplCheckListItem *) itemList->currentItem());
  int id = is + di;
  m->moveItem(is, id);
  itemList->setSelected(lItem.at(id), true);
}

void ItemDlg::slotList(QListViewItem* it)
{
  int i = lItem.findRef((KplCheckListItem *) it);
  m->itd.at(i)->editItem(this, m, i);
}

void ItemDlg::slotNew()
{
  int ityp;
  NewItemDlg dlg(this, &ityp);
  if (dlg.exec()) {
    m->newItem((KplItem::ItemTypes) ityp);
    int it = m->itd.count() - 1;
    if ((ityp == KplItem::Array) || (ityp == KplItem::Function) ||
        (ityp == KplItem::ParFunction))
      for (int i = it - 1; i >= 0; i--) {
        ityp = m->itd.at(i)->iType();
        if (ityp == KplItem::Frame)
          break;
        if ((ityp == KplItem::Array) || (ityp == KplItem::Function) ||
            (ityp == KplItem::ParFunction)) {
          m->itd.at(it)->normalize(((ScaledItem*)m->itd.at(i))->fx,
                                   ((ScaledItem*)m->itd.at(i))->fy);
          break;
        }
      }
    if (!m->itd.last()->editItem(this, m, it)) {
      m->setModified();
      m->backupItems();
    }
  }
}

void ItemDlg::slotEdit()
{
  if (!itemList->isMultiSelection()) {
    if (QListViewItem* it = itemList->currentItem())
      slotList(it);
  } else {
    itemList->setMultiSelection(false);
    updItemList();
  }
}

void ItemDlg::slotFit()
{
  unsigned i;
  QList<ArrayItem> arr;
  QList<FunItem> fun;
  if (itemList->isMultiSelection()) {
    for (i = 0; i < m->itd.count(); i++)
      if (itemList->isSelected(lItem.at(i))) {
        switch (m->itd.at(i)->iType()) {
          case KplItem::Array:
            iArr = i;
            arr.append((ArrayItem*) m->itd.at(i));
            break;
          case KplItem::Function:
            iFun = i;
            fun.append((FunItem*) m->itd.at(i));
            break;
          default:
            itemList->setSelected(lItem.at(i), false);
        }
      }
    if ((arr.count() != fun.count()) || (!arr.count()))
      return;
  } else {
    for (i = 0; i < m->itd.count(); i++) {
      if (m->itd.at(i)->iType() == KplItem::Array)
        arr.append((ArrayItem*) m->itd.at(i));
      if (m->itd.at(i)->iType() == KplItem::Function)
        fun.append((FunItem*) m->itd.at(i));
    }
    if ((arr.count() != fun.count()) || (arr.count() != 1)) {
      itemList->setMultiSelection(true);
      if ((iArr >= 0) && (iArr < (int) m->itd.count()) &&
          (iFun >= 0) && (iFun < (int) m->itd.count())) {
        if (m->itd.at(iArr)->iType() == KplItem::Array)
          itemList->setSelected(lItem.at(iArr), true);
        if (m->itd.at(iFun)->iType() == KplItem::Function)
          itemList->setSelected(lItem.at(iFun), true);
      }
      QToolTip::add(this,
        i18n("Select equal number of data sets and functions!"));
      itemList->setFocus();
      return;

    } else {
      iArr = m->itd.findRef(arr.first());
      iFun = m->itd.findRef(fun.first());
    }
  }
  QToolTip::remove(this);
  emit displayMessage(i18n("Fitting function parameters..."));
  FitDlg dlg(this, m, &arr, &fun, FitDlg::ShowDlg);
  dlg.exec();
  itemList->setMultiSelection(false);
  updItemList();
  emit displayMessage(i18n("Ready."));
}

void ItemDlg::slotDelete()
{
  if (!itemList->isMultiSelection()) {
    if (itemList->currentItem())
      m->deleteItem(lItem.findRef((KplCheckListItem *) itemList->currentItem()));
  } else {
    itemList->setMultiSelection(false);
    updItemList();
  }
}

void ItemDlg::slotCopy()
{
  if (!itemList->isMultiSelection()) {
    if (itemList->currentItem()) {
      m->itd.append(m->itd.at(lItem.findRef((KplCheckListItem *) itemList->currentItem()))->copy());
      m->setModified();
      m->backupItems();
    }
  } else {
    itemList->setMultiSelection(false);
    updItemList();
  }
}

void ItemDlg::slotHelp()
{
  kapp->invokeHelp("SEC-ITEMS");
}

void ItemDlg::slotPopup(QListViewItem* item, const QPoint& p)
{
  if (item) {
    itemList->setSelected(item, true);
    popupMenu->setItemChecked(idActive, ((KplCheckListItem*) item)->isOn());
    popupMenu->exec(p);
  }
}

void ItemDlg::slotButtonPressed(int button, QListViewItem* item)
{
  if (item && (button == LeftButton))
    ((KplCheckListItem *)item)->setOn(!((KplCheckListItem*)item)->isOn());
}

void ItemDlg::slotStateChanged(KplCheckListItem* it, bool bState)
{
  m->itd.at(lItem.findRef(it))->active = bState;
  m->setModified();
  m->backupItems(false);
}

void ItemDlg::slotToggleState()
{
  if (KplCheckListItem* item = (KplCheckListItem*) itemList->currentItem())
    item->setOn(!item->isOn());
}

void ItemDlg::slotSelectionChanged(QListViewItem* it)
{
  int i = lItem.findRef((KplCheckListItem*) it);
  up->setEnabled(i > 0);
  down->setEnabled(i < ((int) m->itd.count() - 1));
}

void ItemDlg::slotMoveUp()
{
  moveItem(-1);
}

void ItemDlg::slotMoveDown()
{
  moveItem(+1);
}
