/***************************************************************************
                          itemdlg.h  -  description
                             -------------------

    This file is a part of kpl - a program for graphical presentation of
    data sets and functions.

    begin                : Sun Apr 25 1999
    copyright            : (C) 2001 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef ITEMDLG_H
#define ITEMDLG_H

#include <qdialog.h>
#include <qlist.h>

class QButtonGroup;
class QRadioButton;
class QPopupMenu;
class QListView;
class QListViewItem;
class KplDoc;
class KplCheckListItem;

/**
  * New item  dialog class. Provides a dialog for the selection of the type
  * of a new plot item.
  * @author Werner Stille
  */
class NewItemDlg : public QDialog {
  Q_OBJECT

public:
  /**
   * Constructor.
   * @param parent pointer to parent widget.
   * @param i pointer to item type.
   */
  NewItemDlg(QWidget* parent, int* i);
  /** Destructor. */
  ~NewItemDlg();

protected:
  int* ityp;
  QButtonGroup* bg;

protected slots:
  /** Accepts selection and leaves the dialog. */
  void slotClicked(int id);
};

/**
  * Items dialog class. Provides a dialog for editing the plot item list.
  * @author Werner Stille
  */
class ItemDlg : public QDialog {
  Q_OBJECT

public:
  /**
   * Constructor.
   * @param model pointer to KplDoc model object.
   */
  ItemDlg(KplDoc* model);
  /** Destructor. */
  ~ItemDlg();

public slots:
  /** Updates the item list. */
  void updItemList();

protected:
  /**
   * moves current item up or down.
   * @param delta index difference: -1 true for upwards, +1 for downwards.
   */
  void moveItem(int di);
  KplDoc* m;
  int iArr, iFun, idActive;
  QListView* itemList;
  QList<KplCheckListItem> lItem;
  QPushButton *up, *down, *edit, *fit, *del, *copy;
  QPopupMenu* popupMenu;

protected slots:
  /**
   * Displays a dialog to edit an item according to its type.
   * @param i selected item.
   */
  void slotList(QListViewItem* i);
  /** Displays the dialog to choose the type of a new item. */
  void slotNew();
  /** Displays a dialog to edit an item according to its type. */
  void slotEdit();
  /** Enters parameter fitting. */
  void slotFit();
  /** Deletes the selected item. */
  void slotDelete();
  /** Append a copy of the selected item at the end of the list. */
  void slotCopy();
  /** Displays help for the function settings dialog. */
  void slotHelp();
  /**
   * Displays a popup menu.
   * @param item pointer to clicked QCheckListItem.
   * @param point where popup menu will appear.
   */
  void slotPopup(QListViewItem* item, const QPoint& p);
  /**
   * Toggles active state of item.
   * @param button number of pressed mouse button.
   * @param item pointer to clicked QCheckListItem.
   */
  void slotButtonPressed(int button, QListViewItem* item);
  /** Updates item structure and repaints view. */
  void slotStateChanged(KplCheckListItem* item, bool bState);
  /** Toggles active state of item. */
  void slotToggleState();
  /** Enables/disables move buttons. */
  void slotSelectionChanged(QListViewItem* item);
  /** Moves item up in sequence. */
  void slotMoveUp();
  /** Moves item down in sequence. */
  void slotMoveDown();

signals:
  /**
   * Emitted when status message should be displayed.
   * @param msg message text.
   */
  void displayMessage(const QString& msg);
};

#endif
